<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title>Desa Grow Farm System</title>
    <!-- App favicon -->
    <link rel="shortcut icon" href="assets/images/favicon.ico">

    <!-- App css -->
    <link href="<?php echo e(asset('assets/css/icons.min.css')); ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo e(asset('assets/css/app.min.css')); ?>" rel="stylesheet" type="text/css" id="light-style">
    <link href="<?php echo e(asset('assets/css/app-dark.min.css')); ?>" rel="stylesheet" type="text/css" id="dark-style" />

    <!-- third party css fullcalendar -->
    <link href="<?php echo e(asset('assets/css/vendor/fullcalendar.min.css')); ?>" rel="stylesheet" type="text/css" />
</head>

<body class="loading authentication-bg" data-layout-config='{"darkMode":false}'>
    <?php if(Route::has('login')): ?>
        <?php if(auth()->guard()->check()): ?>
            <script>
                window.location = "<?php echo e(url('/dashboard')); ?>"; // Redirect to the dashboard
            </script>
        <?php endif; ?>
    <?php endif; ?>

    <div class="account-pages mt-5 mb-5">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-5">
                    <div class="card">

                        <!-- Logo -->
                        <div class="card-header pt-4 pb-4 text-center bg-primary">
                            <a href="<?php echo e(url('/')); ?>">
                                <span><img src="<?php echo e(asset('assets/images/logo.png')); ?>" alt="Logo" height="20"></span>
                            </a>
                        </div>

                        <div class="card-body p-4">
                            <div class="text-center w-75 m-auto">
                                <h4 class="text-dark-50 text-center mt-0 font-weight-bold">Daftar Masuk</h4>
                                <p class="text-muted mb-4">Masukkan alamat e-mel dan kata laluan anda untuk mengakses masuk.</p>
                            </div>

                            <form method="POST" action="<?php echo e(route('login')); ?>">
                                <?php echo csrf_field(); ?>

                                <!-- Email Address -->
                                <div class="form-group">
                                    <label for="emailaddress">E-mel</label>
                                    <input class="form-control" type="email" id="emailaddress" name="email" value="<?php echo e(old('email')); ?>" required autofocus placeholder="Masukkan E-mel">
                                    <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <!-- Password -->
                                <div class="form-group">
                                    <a href="<?php echo e(route('password.request')); ?>" class="text-muted float-right"><small>Lupa Kata Laluan?</small></a>
                                    <label for="password">Kata Laluan</label>
                                    <div class="input-group input-group-merge">
                                        <input type="password" id="password" name="password" class="form-control" required placeholder="Masukkan Kata Laluan">
                                        <div class="input-group-append" data-password="false">
                                            <div class="input-group-text">
                                                <span class="password-eye"></span>
                                            </div>
                                        </div>
                                    </div>
                                    <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <!-- Remember Me -->
                                <div class="form-group mb-3">
                                    <div class="custom-control custom-checkbox">
                                        <input type="checkbox" class="custom-control-input" id="checkbox-signin" name="remember" <?php echo e(old('remember') ? 'checked' : ''); ?>>
                                        <label class="custom-control-label" for="checkbox-signin">Ingat Saya</label>
                                    </div>
                                </div>

                                <!-- Submit Button -->
                                <div class="form-group mb-0 text-center">
                                    <button class="btn btn-primary" type="submit"> Daftar Masuk </button>
                                </div>
                            </form>
                        </div> <!-- end card-body -->
                    </div>
                    <!-- end card -->
                </div> <!-- end col -->
            </div>
            <!-- end row -->
        </div>
        <!-- end container -->
    </div>
    <!-- end page -->
<div class="text-center">
    <script>
        document.write(new Date().getFullYear());
    </script> © Hakmilik - Desa Grow Farm System
</div>
   

    <!-- bundle -->
    <script src="<?php echo e(asset('assets/js/vendor.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/app.min.js')); ?>"></script>
</body>

</html>
<?php /**PATH C:\laragon\www\desa-grow-farm\resources\views/auth/login.blade.php ENDPATH**/ ?>