<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('damages', function (Blueprint $table) {
            $table->id();
            $table->foreignId('plantation_id'); // Foreign key to categories
            $table->foreignId('worker_id')->nullable(); // Foreign key to user (pengait)
            $table->foreignId('pest_id')->nullable(); // Foreign key to pest
            $table->text('damage_description')->nullable();
            $table->string('image')->nullable();
            $table->string('image_work')->nullable();
            $table->date('assign_date')->nullable();
            $table->enum('solution_category', ['Meracun', 'Jumpa Tuan Kebun']);
            $table->text('solution_description')->nullable();
            $table->enum('damage_category', ['Haiwan Perosak', 'Lain-lain', 'Penyakit']);
            $table->enum('status', ['Baru', 'Serah Tugas', 'Dalam Kerja', 'Selesai']);
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('damages');
    }
};
