<?php

namespace App\Http\Controllers;

use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;

class UserController extends Controller
{
    public function index()
    {
        $users=User::all();
        return view('admin.index', compact('users'));
    }
    
    public function create()
    {
        return view('admin.create_user');
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'email' => 'required|string|email|max:255|unique:users',
            'password' => 'required|string|min:8|confirmed',
            'role' => 'required|in:Pekerja,Tuan_Kebun',
            'job_type' => 'required|in:Pengopek,Pengait,Penanam,Tiada', // Validate job type
            'address' => 'required|string|max:255',
            'phone' => 'required|string|max:15', // Adjust max length as needed
        ]);

        User::create([
            'name' => $request->name,
            'email' => $request->email,
            'password' => Hash::make($request->password),
            'role' => $request->role,
            'job_type' => $request->job_type,
            'address' => $request->address,
            'phone' => $request->phone,

        ]);

        return redirect()->route('admin.users.index')->with('success', 'Maklumat Pengguna Berjaya Ditambah!');
    }

    public function show($id)
    {
        $user = User::findOrFail($id);
        return view('admin.users.index', compact('user'));
    }

    public function destroy($id)
    {
        $user = User::findOrFail($id);
        $user->delete();

        return redirect()->route('admin.users.index')->with('success', 'Maklumat Pengguna Berjaya Dipadam.');
    }
}

