

<?php $__env->startSection('content'); ?>
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="worker-damage-index">Aduan</a></li>
                        <li class="breadcrumb-item active">Tambah Aduan</li>
                    </ol>
                </div>
                <h4 class="page-title">Pengurusan Aduan</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <h4 class="header-title">Tambah Aduan</h4>
                    <?php if($errors->any()): ?>
                        <div class="alert alert-danger">
                            <ul>
                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><?php echo e($error); ?></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    <?php endif; ?>
                    <form role="form" method="POST" action="<?php echo e(route('damage.store')); ?>" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div class="form-group">
                            <label for="inputKategoriAduan" class="col-form-label">Jenis Aduan</label>
                            <select id="inputKategoriAduan" class="form-control" name="damage_category" required
                                onchange="updatePlantName()">
                                <option selected>Sila Pilih</option>
                                <?php $__currentLoopData = $damageCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($category); ?>"><?php echo e($category); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <!-- Initial Maklumat Kebun section -->
                        <p class="text-muted font-14">Maklumat Kebun</p>
                        <div class="form-row">
                            <div class="form-group col-md-6">
                                <label for="inputKategoriTanaman" class="col-form-label">Lokasi Kebun</label>
                                <select id="inputKategoriTanaman" class="form-control" name="plantation_id" required
                                    onchange="updatePlantName()">
                                    <option selected>Sila Pilih</option>
                                   <?php $__currentLoopData = $allFarms; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $farm): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($farm->id); ?>"><?php echo e($farm->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="form-group col-md-6">
                                <label for="inputNamaPokok" class="col-form-label">Nama Pokok</label>
                                <input type="text" id="inputNamaPokok" class="form-control" name="plant_type">
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="project-overview">Keterangan Penyelesaian</label>
                            <textarea class="form-control" id="project-overview" name="damage_description" rows="5"
                                placeholder="Eg: Terdapat bintik-bintik merah di daun pokok."></textarea>
                        </div>
                        <div class="form-group">
                            <label for="example-fileinput">Muat Naik Gambar</label>
                            <input type="file" name="image" class="form-control" accept="image/">
                        </div>

                        <div class="text-center mt-2">
                            <button type="button" onclick="history.back()" class="btn btn-light mr-3">Batal</button>
                            <button type="submit" class="btn btn-primary">Simpan</button>
                        </div>
                    </form>
                </div> <!-- end card body-->
            </div> <!-- end card-->
        </div> <!-- end col-->
    </div>

    <script>
        const plantationsData = <?php echo json_encode($plantations, 15, 512) ?>;

        function updatePlantName() {
            const plantationId = document.getElementById('inputKategoriTanaman').value;
            const plantNameField = document.getElementById('inputNamaPokok');

            // Find the selected plantation in the plantations data
            const selectedPlantation = plantationsData.find(plantation => plantation.id == plantationId);

            // Update the plant name field if a match is found
            if (selectedPlantation) {
                plantNameField.value = selectedPlantation.plant_detail?.plant_type || "Tidak diketahui";
            } else {
                plantNameField.value = ""; // Clear the field if no plantation is selected
            }
        }
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\desa-grow-farm\resources\views/damage/create.blade.php ENDPATH**/ ?>