@extends('layouts.base')

@section('content')
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <h4 class="page-title">Rekod</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->

    <div class="row">
        <div class="col-12">
            <div class="card widget-inline">
                <div class="card-body p-0">
                    <div class="row no-gutters">
                        <!-- Jumlah Tanaman -->
                        <div class="col">
                            <div class="card shadow-none m-0">
                                <div class="card-body bg-secondary text-center">
                                    <i class="mdi mdi-flower-tulip-outline text-white" style="font-size: 24px;"></i>
                                    <h3 class="text-white"><span>{{ $jumlahTanaman }}</span></h3>
                                    <p class="text-white font-15 mb-0">Jumlah Tanaman</p>
                                </div>
                            </div>
                        </div>
                         <!-- Kebun Kosong -->
                         @if (auth()->user()->role === 'Tuan_Kebun')
                         <div class="col">
                             <div class="card shadow-none m-0 border-left">
                                 <div class="card-body bg-success text-center">
                                     <i class="mdi mdi-basket-unfill text-white" style="font-size: 24px;"></i>
                                     <h3 class="text-white"><span>{{ $kebunKosong }}</span></h3>
                                     <p class="text-white font-15 mb-0">Kebun Kosong</p>
                                 </div>
                             </div>
                         </div>
                         @endif
    
                        <!-- Baru -->
                        <div class="col">
                            <div class="card shadow-none m-0 border-left">
                                <div class="card-body bg-primary text-center">
                                    <i class="mdi mdi-cannabis text-white" style="font-size: 24px;"></i>
                                    <h3 class="text-white"><span>{{ $baru }}</span></h3>
                                    <p class="text-white font-15 mb-0">Baru</p>
                                </div>
                            </div>
                        </div>
    
                        <!-- Tanam -->
                        <div class="col">
                            <div class="card shadow-none m-0 border-left">
                                <div class="card-body bg-info text-center">
                                    <i class=" mdi mdi-data-matrix text-white" style="font-size: 24px;"></i>
                                    <h3 class="text-white"><span>{{ $tanam }}</span></h3>
                                    <p class="text-white font-15 mb-0">Tanam</p>
                                </div>
                            </div>
                        </div>
                    </div> <!-- end row -->
                </div>
            </div> <!-- end card-box-->
        </div> <!-- end col-->
    </div>
    <!-- end row-->

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <h4 class="header-title">Tanaman</h4>
                        @if (auth()->user()->role === 'Tuan_Kebun')
                            <a href="{{ route('plantation.create') }}" class="btn btn-info btn-sm"
                                style="position: absolute; right:2%;">+Tambah Tanaman</a>
                            <br><br>
                        @endif

                    </div>


                    <table id="basic-datatable" class="table dt-responsive nowrap w-100">
                        <thead>
                            <tr>
                                <th>Bil.</th>
                                <th>Kebun</th>
                                <th>Kategori</th>
                                <th>Nama</th>
                                <th>Jumlah Tanam</th>
                                @if (auth()->user()->role === 'Tuan_Kebun' || auth()->user()->job_type === 'Penanam')
                                    <th>Tarikh Menanam</th>
                                @endif
                                @if (auth()->user()->role === 'Tuan_Kebun' || auth()->user()->job_type === 'Pengait')
                                    <th>Tarik Menuai</th>
                                @endif
                                <th>Status</th>
                                <th>Tindakan</th>
                            </tr>
                        </thead>


                        <tbody>
                            @foreach ($filteredPlantations as $plantation)
                                <tr>
                                    <td>{{ $loop->index + 1 }}</td>
                                    <td>{{ $plantation->farm->name }}</td>
                                    <td>
                                        @if ($plantation->farm->category->name == 'Kelapa')
                                            <span class="badge badge-warning">Kelapa</span>
                                        @else
                                            <span class="badge badge-info">{{ $plantation->farm->category->name }}</span>
                                        @endif
                                    </td>
                                    <td>{{ $plantation->plantDetail->plant_type }}</td>
                                    <td>{{ $plantation->quantity_plant }} Batang</td>
                                    @if (auth()->user()->role === 'Tuan_Kebun' || auth()->user()->job_type === 'Penanam')
                                        <td> {{ \Carbon\Carbon::parse($plantation->plant_date)->format('d F Y') }}</td>
                                    @endif
                                    @if (auth()->user()->role === 'Tuan_Kebun' || auth()->user()->job_type === 'Pengait')
                                        <td> {{ \Carbon\Carbon::parse($plantation->harvest_date)->format('d F Y') }}</td>
                                    @endif


                                    <td>
                                        @if ($plantation->status == 'Baru')
                                        <span class="badge badge-danger">Baru</span>
                                    @elseif($plantation->status == 'Proses Tanam' || $plantation->status == 'Proses Tuai')
                                        <span class="badge badge-warning">Dalam Kerja</span>
                                    @elseif($plantation->status == 'Tanam')
                                        @if (Carbon\Carbon::now()->isSameDay($plantation->harvest_date))
                                            <span class="badge badge-danger">Menuai</span>
                                        @else
                                            <span class="badge badge-info">Tanam</span>
                                        @endif
                                    @elseif($plantation->status == 'Tuai Hasil')
                                        <span class="badge badge-success">Tuai Hasil</span>
                                    @elseif($plantation->status == 'Kira Hasil')
                                        <span class="badge badge-light">Kira Hasil</span>
                                    @elseif($plantation->status == 'Selesai')
                                        <span class="badge badge-secondary">Selesai</span>
                                    @endif
                                    </td>
                                    <td class="table-action">
                                        <a href="{{ route('plantation.show', $plantation->id) }}" class="action-icon"> <i
                                                class="mdi mdi-eye-check text-primary"></i></a>
                                        {{-- Tuan Kebun --}}
                                        @if (auth()->user()->role === 'Tuan_Kebun' && $plantation->status === 'Baru')
                                            <a href="{{ route('plantation.edit', $plantation->id) }}" class="action-icon">
                                                <i class="mdi mdi-file-document-edit text-info"></i></a>
                                            <a href="javascript: void(0);" class="action-icon" data-toggle="modal"
                                                data-target="#delete-modal-{{ $plantation->id }}"> <i
                                                    class="mdi mdi-delete text-danger"></i></a>
                                        @endif
                                        {{-- Penanam --}}
                                        @if (auth()->user()->job_type === 'Penanam' && $plantation->status === 'Baru' && now()->greaterThanOrEqualTo($plantation->plant_date))
                                            <a href="javascript: void(0);" class="action-icon" data-toggle="modal"
                                                data-target="#statusTanamModal-{{ $plantation->id }}"> <i
                                                    class="mdi mdi-file-document-edit text-info"></i></a>
                                        @elseif(auth()->user()->job_type === 'Penanam' && $plantation->status === 'Proses Tanam' )
                                            <a href="javascript: void(0);" class="action-icon" data-toggle="modal"
                                                data-target="#kemaskiniTanaman-modal-{{ $plantation->id }}"> <i
                                                    class="mdi mdi-checkbox-multiple-marked text-success"></i></a>
                                        @endif
                                        {{-- Pengait --}}
                                        @if (auth()->user()->job_type === 'Pengait' && $plantation->status === 'Tanam' && now()->greaterThanOrEqualTo($plantation->harvest_date))
                                            <a href="javascript: void(0);" class="action-icon" data-toggle="modal"
                                                data-target="#statusTuaiModal-{{ $plantation->id }}"> <i
                                                    class="mdi mdi-file-document-edit text-info"></i></a>
                                        @elseif(auth()->user()->job_type === 'Pengait' && $plantation->status === 'Proses Tuai' )
                                            <a href="javascript: void(0);" class="action-icon" data-toggle="modal"
                                                data-target="#kemaskiniTuai-modal-{{ $plantation->id }}"> <i
                                                    class="mdi mdi-checkbox-multiple-marked text-success"></i></a>
                                        @endif
                                    </td>
                                </tr>

                                <!-- Status Tanam Modal -->
                                <div class="modal fade" id="statusTanamModal-{{ $plantation->id }}" tabindex="-1"
                                    role="dialog" aria-labelledby="statusModalLabel-{{ $plantation->id }}"
                                    aria-hidden="true">
                                    <div class="modal-dialog" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="statusModalLabel-{{ $plantation->id }}">
                                                    Kemaskini Status {{ $plantation->farm->name }}</h5>
                                                <button type="button" class="close" data-dismiss="modal"
                                                    aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <div class="modal-body">

                                                Anda Pasti Mahu Kemaskini Status Penanaman {{ $plantation->farm->name }}
                                                kepada <b>Dalam Kerja</b>?
                                                <br>
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary"
                                                    data-dismiss="modal">Batal</button>
                                                <form method="POST"
                                                    action="{{ route('plantation.tanam', $plantation->id) }}">
                                                    @csrf
                                                    @method('PATCH')
                                                    <button type="submit" class="btn btn-primary">Betul</button>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- KemaskiniTanam modal -->
                                <div id="kemaskiniTanaman-modal-{{ $plantation->id }}" class="modal fade" tabindex="-1"
                                    role="dialog" aria-hidden="true">
                                    <div class="modal-dialog ">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h4 class="modal-title" id="editModalLabel">Kemaskini Status Tanaman
                                                </h4>
                                                <button type="button" class="close" data-dismiss="modal"
                                                    aria-hidden="true">×</button>
                                            </div>
                                            <div class="modal-body">
                                                <form action="{{ route('plantation.kemaskiniTanam', $plantation->id) }}"
                                                    method="POST" enctype="multipart/form-data">
                                                    @csrf
                                                    @method('PUT')
                                                    <div class="form-row">
                                                        <div class="form-group col-md-12">
                                                            <label for="inputState" class="col-form-label">Nama
                                                                Kebun</label>
                                                            <input type="text" name="plant_category"
                                                                class="form-control"
                                                                value="{{ $plantation->farm->name }}" readonly>
                                                        </div>

                                                        <div class="form-group col-md-6">
                                                            <label for="inputEmail4" class="col-form-label">Jenis
                                                                Pokok</label>
                                                            <input type="text" name="plant_type" class="form-control"
                                                                value="{{ $plantation->farm->category->name }}" readonly>
                                                        </div>
                                                        <div class="form-group col-md-6">
                                                            <label for="inputEmail4" class="col-form-label">Nama
                                                                Pokok</label>
                                                            <input type="text" name="plant_type" class="form-control"
                                                                value="{{ $plantation->plantDetail->plant_type }}" readonly>
                                                        </div>
                                                        <div class="form-group col-md-6">
                                                            <label for="inputEmail4" class="col-form-label">Bilangan
                                                                Tanam</label>
                                                            <input type="text" name="plant_type" class="form-control"
                                                                value="{{ $plantation->quantity_plant }} Batang" readonly>
                                                        </div>
                                                        <div class="form-group col-md-6">
                                                            <label for="inputEmail4" class="col-form-label">Tarikh
                                                                Penanaman</label>
                                                            <input type="text" name="plant_type" class="form-control"
                                                                value="{{ $plantation->plant_date }}" readonly>
                                                        </div>
                                                        <div class="form-group col-md-12">
                                                            <label for="pdf" class="col-form-label">Muat Naik
                                                                Gambar</label>
                                                            <input type="file" name="image_tanam" class="form-control"
                                                                accept="image/" required>
                                                        </div>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-light"
                                                            data-dismiss="modal">Batal</button>
                                                        <button type="submit" class="btn btn-primary">Kemaskini</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div><!-- /.modal-content -->
                                    </div><!-- /.modal-dialog -->
                                </div><!-- /.modal -->

                                <!-- Status Tuai Modal -->
                                <div class="modal fade" id="statusTuaiModal-{{ $plantation->id }}" tabindex="-1"
                                    role="dialog" aria-labelledby="statusModalLabel-{{ $plantation->id }}"
                                    aria-hidden="true">
                                    <div class="modal-dialog" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="statusModalLabel-{{ $plantation->id }}">
                                                    Kemaskini Status {{ $plantation->farm->name }}</h5>
                                                <button type="button" class="close" data-dismiss="modal"
                                                    aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <div class="modal-body">

                                                Anda Pasti Mahu Kemaskini Status Penuaian {{ $plantation->farm->name }}
                                                kepada <b>Dalam Kerja</b>?
                                                <br>
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary"
                                                    data-dismiss="modal">Batal</button>
                                                <form method="POST"
                                                    action="{{ route('plantation.tuai', $plantation->id) }}">
                                                    @csrf
                                                    @method('PATCH')
                                                    <button type="submit" class="btn btn-primary">Betul</button>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- KemaskiniTanam modal -->
                                <div id="kemaskiniTuai-modal-{{ $plantation->id }}" class="modal fade" tabindex="-1"
                                    role="dialog" aria-hidden="true">
                                    <div class="modal-dialog ">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h4 class="modal-title" id="editModalLabel">Kemaskini Status Tanaman
                                                </h4>
                                                <button type="button" class="close" data-dismiss="modal"
                                                    aria-hidden="true">×</button>
                                            </div>
                                            <div class="modal-body">
                                                <form action="{{ route('plantation.kemaskiniTuai', $plantation->id) }}"
                                                    method="POST" enctype="multipart/form-data">
                                                    @csrf
                                                    @method('PUT')
                                                    <div class="form-row">
                                                        <div class="form-group col-md-12">
                                                            <label for="inputState" class="col-form-label">Nama
                                                                Kebun</label>
                                                            <input type="text" name="plant_category"
                                                                class="form-control"
                                                                value="{{ $plantation->farm->name }}" readonly>
                                                        </div>

                                                        <div class="form-group col-md-6">
                                                            <label for="inputEmail4" class="col-form-label">Jenis
                                                                Pokok</label>
                                                            <input type="text" name="plant_type" class="form-control"
                                                                value="{{ $plantation->farm->category->name }}" readonly>
                                                        </div>
                                                        <div class="form-group col-md-6">
                                                            <label for="inputEmail4" class="col-form-label">Nama
                                                                Pokok</label>
                                                            <input type="text" name="plant_type" class="form-control"
                                                                value="{{ $plantation->plantDetail->plant_type }}" readonly>
                                                        </div>
                                                        <div class="form-group col-md-6">
                                                            <label for="inputEmail4" class="col-form-label">Bilangan
                                                                Tandan</label>
                                                            <input type="text" name="plant_type" class="form-control"
                                                                value="{{ $plantation->quantity_plant }} Tandan" readonly>
                                                        </div>
                                                        <div class="form-group col-md-6">
                                                            <label for="inputEmail4" class="col-form-label">Tarikh
                                                                Penuaian</label>
                                                            <input type="text" name="plant_type" class="form-control"
                                                                value="{{ $plantation->harvest_date }}" readonly>
                                                        </div>
                                                        <div class="form-group col-md-12">
                                                            <label for="pdf" class="col-form-label">Muat Naik
                                                                Gambar</label>
                                                            <input type="file" name="image_kait" class="form-control"
                                                                accept="image/" required>
                                                        </div>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-light"
                                                            data-dismiss="modal">Batal</button>
                                                        <button type="submit" class="btn btn-primary">Kemaskini</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div><!-- /.modal-content -->
                                    </div><!-- /.modal-dialog -->
                                </div><!-- /.modal -->

                                <!-- Delete modal -->
                                <div id="delete-modal-{{ $plantation->id }}" class="modal fade" tabindex="-1"
                                    role="dialog" aria-hidden="true">
                                    <div class="modal-dialog ">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h4 class="modal-title" id="deleteModalLabel">Padam Maklumat Tanaman</h4>
                                                <button type="button" class="close" data-dismiss="modal"
                                                    aria-hidden="true">×</button>
                                            </div>
                                            <div class="modal-body">
                                                <p>Adakah anda mahu memadam maklumat ini?</p>
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-light btn-sm" data-dismiss="modal">
                                                    Tidak, Batal
                                                </button>
                                                <form method="POST"
                                                    action="{{ route('plantation.destroy', $plantation->id) }}">
                                                    @csrf
                                                    @method('DELETE')
                                                    <input type="hidden" name="plantation_id"
                                                        value="{{ $plantation->id }}">
                                                    <button type="submit" class="btn btn-danger btn-sm">Betul,
                                                        Padam</button>
                                                </form>
                                            </div>

                                        </div>
                                    </div>
                                </div><!-- /.modal -->
                            @endforeach
                        </tbody>
                    </table>
                </div> <!-- end card body-->
            </div> <!-- end card -->
        </div><!-- end col-->
    </div>
    <!-- end row-->
@endsection
