<?php $__env->startSection('content'); ?>
    <?php if($user->role === 'Tuan_Kebun' || $user->role === 'admin'): ?>
        <div class="row">
            <div class="col-xl-4 col-lg-6">
                <div class="card widget-flat bg-info text-white">
                    <div class="card-body">
                        <div class="float-right">
                            <i class="mdi mdi-pulse widget-icon bg-white text-info"></i>
                        </div>
                        <h5 class="text-uppercase mt-0" title="Growth">Jumlah Pengguna</h5>
                        <h3 class="mt-3 mb-3"><?php echo e($totalUsers); ?> Pengguna</h3>
                    </div>
                </div>
            </div> <!-- end col-->

            <div class="col-xl-4 col-lg-6">
                <div class="card widget-flat bg-success text-white">
                    <div class="card-body">
                        <div class="float-right">
                            <i class="mdi mdi-pulse widget-icon bg-white text-success"></i>
                        </div>
                        <h5 class="text-uppercase mt-0" title="Growth">Jumlah Kebun</h5>
                        <h3 class="mt-3 mb-3"><?php echo e($totalFarms); ?> Kebun</h3>
                    </div>
                </div>
            </div> <!-- end col-->

            <div class="col-xl-4 col-lg-6">
                <div class="card widget-flat bg-primary text-white">
                    <div class="card-body">
                        <div class="float-right">
                            <i class="mdi mdi-pulse widget-icon bg-white text-primary"></i>
                        </div>
                        <h5 class="text-uppercase mt-0" title="Growth">Jumlah Baja</h5>
                        <h3 class="mt-3 mb-3"><?php echo e($totalFertilizerDetails); ?> Baja</h3>
                    </div>
                </div>
            </div> <!-- end col-->
        </div>

        <div class="row">
            <div class="col-sm-6">
                <div class="card">
                    <div class="card-body">
                        <!-- HTML -->
                        <h4 class="header-title">Hasil Terjual (RM)</h4>
                        <div id="chartdiv"></div>
                    </div> <!-- end card body-->
                </div> <!-- end card -->
            </div><!-- end col-->

            <div class="col-sm-6">
                <div class="card">
                    <div class="card-body">
                        <!-- HTML -->
                        <h4 class="header-title">Jumlah Aduan</h4>
                        <div id="chartdiv2"></div>
                    </div> <!-- end card body-->
                </div> <!-- end card -->
            </div><!-- end col-->
        </div>
    <?php endif; ?>
    <?php if($user->role === 'Pekerja' && $user->job_type === 'Penanam'): ?>
        <div class="row">
            <div class="col-xl-6 col-lg-6">
                <div class="card widget-flat bg-primary text-white">
                    <div class="card-body">
                        <div class="float-right">
                            <i class="mdi mdi-pulse widget-icon bg-white text-primary"></i>
                        </div>
                        <h5 class="text-uppercase mt-0" title="Growth">Jumlah Tanam</h5>
                        <h3 class="mt-3 mb-3"><?php echo e($plantCount); ?> Tanam</h3>
                    </div>
                </div>
            </div> <!-- end col-->

            <div class="col-xl-6 col-lg-6">
                <div class="card widget-flat bg-secondary text-white">
                    <div class="card-body">
                        <div class="float-right">
                            <i class="mdi mdi-pulse widget-icon bg-white text-secondary"></i>
                        </div>
                        <h5 class="text-uppercase mt-0" title="Growth">Jumlah Aduan</h5>
                        <h3 class="mt-3 mb-3"><?php echo e($jumlahAduan); ?> Aduan</h3>
                    </div>
                </div>
            </div> <!-- end col-->
        </div>
    <?php elseif($user->role === 'Pekerja' && $user->job_type === 'Pengait'): ?>
        <div class="row">
            <div class="col-xl-6 col-lg-6">
                <div class="card widget-flat bg-primary text-white">
                    <div class="card-body">
                        <div class="float-right">
                            <i class="mdi mdi-pulse widget-icon bg-white text-primary"></i>
                        </div>
                        <h5 class="text-uppercase mt-0" title="Growth">Jumlah Tuai</h5>
                        <h3 class="mt-3 mb-3"><?php echo e($harvestCount); ?> Tuai</h3>
                    </div>
                </div>
            </div> <!-- end col-->
            <div class="col-xl-6 col-lg-6">
                <div class="card widget-flat bg-secondary text-white">
                    <div class="card-body">
                        <div class="float-right">
                            <i class="mdi mdi-pulse widget-icon bg-white text-secondary"></i>
                        </div>
                        <h5 class="text-uppercase mt-0" title="Growth">Jumlah Aduan</h5>
                        <h3 class="mt-3 mb-3"><?php echo e($jumlahAduan); ?> Aduan</h3>
                    </div>
                </div>
            </div> <!-- end col-->
        </div>
    <?php endif; ?>

    
    <div class="container-fluid">
        <!-- Start page title -->
        <div class="row">
            <!-- End page title -->
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-12">
                                <div class="page-title-box">
                                    <div class="page-title-right"></div>
                                    <h4 class="page-title">Jadual Bertugas</h4>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-lg-2">
                                <div id="external-events" class="m-t-20">
                                    <br><br><br><br>
                                    <p class="text-muted">Senarai Tugas:</p>
                                    <div class="external-event text-white" style="background-color:#6c757d; ">
                                        <i class="mdi mdi-checkbox-blank-circle mr-2 vertical-middle"></i>Tanam
                                    </div>
                                    <div class="external-event text-white" style="background-color:#28a745; ">
                                        <i class="mdi mdi-checkbox-blank-circle mr-2 vertical-middle"></i>Baja
                                        Tumbesaran
                                    </div>
                                    <div class="external-event text-white" style="background-color:#17a2b8; ">
                                        <i class="mdi mdi-checkbox-blank-circle mr-2 vertical-middle"></i>Baja Akar
                                    </div>
                                    <div class="external-event text-white" style="background-color:#ffc107; ">
                                        <i class="mdi mdi-checkbox-blank-circle mr-2 vertical-middle"></i>Baja Buah
                                    </div>
                                    <div class="external-event text-white" style="background-color:#dc3545; ">
                                        <i class="mdi mdi-checkbox-blank-circle mr-2 vertical-middle"></i>Baja Matang
                                    </div>
                                    <div class="external-event text-white" style="background-color:#6610f2; ">
                                        <i class="mdi mdi-checkbox-blank-circle mr-2 vertical-middle"></i>Tuai
                                    </div>

                                </div>
                            </div> <!-- end col-->

                            <div class="col-lg-10">
                                <div class="mt-4 mt-lg-0">
                                    <div id="calendar"></div>
                                </div>
                            </div> <!-- end col -->
                        </div> <!-- end row -->
                    </div> <!-- end card body-->
                </div> <!-- end card -->
            </div> <!-- end col-12 -->
        </div> <!-- end row -->
    </div> <!-- container -->

    <style>
        #chartdiv,
        #chartdiv2 {
            width: 100%;
            height: 250px;
        }
    </style>

    <!-- Resources -->
    <script src="https://cdn.amcharts.com/lib/5/index.js"></script>
    <script src="https://cdn.amcharts.com/lib/5/xy.js"></script>
    <script src="https://cdn.amcharts.com/lib/5/themes/Animated.js"></script>
    <script src="https://cdn.amcharts.com/lib/5/percent.js"></script>

    <!-- Chart code -->
    <script>
        am5.ready(function() {
            // Create root element
            var root = am5.Root.new("chartdiv");

            // Set themes
            root.setThemes([
                am5themes_Animated.new(root)
            ]);

            // Create chart
            var chart = root.container.children.push(am5xy.XYChart.new(root, {
                panX: false,
                panY: false,
                paddingLeft: 0,
                wheelX: "panX",
                wheelY: "zoomX",
                layout: root.verticalLayout
            }));

            // Add legend
            var legend = chart.children.push(
                am5.Legend.new(root, {
                    centerX: am5.p50,
                    x: am5.p50
                })
            );

            // Define data
            var data = <?php echo json_encode($chartData, 15, 512) ?>;

            // Create axes
            var xRenderer = am5xy.AxisRendererX.new(root, {
                cellStartLocation: 0.1,
                cellEndLocation: 0.9,
                minorGridEnabled: true
            });

            var xAxis = chart.xAxes.push(am5xy.CategoryAxis.new(root, {
                categoryField: "year",
                renderer: xRenderer,
                tooltip: am5.Tooltip.new(root, {})
            }));

            xRenderer.grid.template.setAll({
                location: 1
            });

            xAxis.data.setAll(data);

            var yAxis = chart.yAxes.push(am5xy.ValueAxis.new(root, {
                renderer: am5xy.AxisRendererY.new(root, {
                    strokeOpacity: 0.1
                })
            }));

            // Add series
            function makeSeries(name, fieldName) {
                var series = chart.series.push(am5xy.ColumnSeries.new(root, {
                    name: name,
                    xAxis: xAxis,
                    yAxis: yAxis,
                    valueYField: fieldName,
                    categoryXField: "year"
                }));

                series.columns.template.setAll({
                    tooltipText: "{name}, {categoryX}: {valueY}",
                    width: am5.percent(90),
                    tooltipY: 0,
                    strokeOpacity: 0
                });

                series.data.setAll(data);

                // Make stuff animate on load
                series.appear();

                series.bullets.push(function() {
                    return am5.Bullet.new(root, {
                        locationY: 0,
                        sprite: am5.Label.new(root, {
                            text: "{valueY}",
                            fill: root.interfaceColors.get("alternativeText"),
                            centerY: 0,
                            centerX: am5.p50,
                            populateText: true
                        })
                    });
                });

                legend.data.push(series);
            }

            makeSeries("Grad A Terjual ", "grade_a_sale");
            makeSeries("Grad B Terjual ", "grade_b_sale");
            makeSeries("Grad C Terjual", "grade_c_sale");

            // Make stuff animate on load
            chart.appear(1000, 100);
        }); // end am5.ready()
    </script>

    <!-- Chart code -->
    <script>
        am5.ready(function() {
            // Create root element
            var root = am5.Root.new("chartdiv2");

            // Set themes
            root.setThemes([
                am5themes_Animated.new(root)
            ]);

            // Create chart
            var chart = root.container.children.push(am5percent.PieChart.new(root, {
                layout: root.verticalLayout
            }));

            // Create series
            var series = chart.series.push(am5percent.PieSeries.new(root, {
                valueField: "value",
                categoryField: "category"
            }));

            // Set data dynamically from the controller
            series.data.setAll([{
                    value: <?php echo e($damageCategories['Haiwan Perosak']); ?>,
                    category: "Haiwan Perosak"
                },
                {
                    value: <?php echo e($damageCategories['Penyakit']); ?>,
                    category: "Penyakit"
                },
                {
                    value: <?php echo e($damageCategories['Lain-lain']); ?>,
                    category: "Lain-lain"
                }
            ]);

            // Play initial series animation
            series.appear(1000, 100);
        }); // end am5.ready()
    </script>



    <!-- Include FullCalendar CSS and JS -->
    <link href="https://cdn.jsdelivr.net/npm/fullcalendar@5.11.3/main.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/fullcalendar@5.11.3/main.min.js"></script>
    <!-- Include Bootstrap JS (required for modal functionality) -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>

    <!-- Initialize the Calendar -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            var calendarEl = document.getElementById('calendar');

            var calendar = new FullCalendar.Calendar(calendarEl, {
                initialView: 'dayGridMonth',
                headerToolbar: {
                    left: 'prev,next today',
                    center: 'title',
                    right: 'dayGridMonth,timeGridWeek,timeGridDay'
                },
                events: <?php echo json_encode($events, 15, 512) ?>,
                eventClick: function(info) {
                    // Populate the modal with event details
                    document.getElementById('eventType').value = info.event.extendedProps.type;
                    document.getElementById('eventFarm').value = info.event.extendedProps.farmName;
                    document.getElementById('eventPlantDetail').value = info.event.extendedProps
                        .plantDetail;
                    document.getElementById('eventStart').value = info.event.start.toLocaleString();

                    // Show penanam and pengait for all event types
                    if (info.event.extendedProps.penanam) {
                        document.getElementById('eventPenanam').value = info.event.extendedProps
                            .penanam;
                        document.getElementById('eventPenanam').closest('.form-group').style.display =
                            'block';
                    } else {
                        document.getElementById('eventPenanam').closest('.form-group').style.display =
                            'none';
                    }

                    if (info.event.extendedProps.pengait) {
                        document.getElementById('eventPengait').value = info.event.extendedProps
                            .pengait;
                        document.getElementById('eventPengait').closest('.form-group').style.display =
                            'block';
                    } else {
                        document.getElementById('eventPengait').closest('.form-group').style.display =
                            'none';
                    }

                    // Show additional fields for fertilization events
                    if (['Tumbesaran', 'Akar', 'Buah', 'Matang'].includes(info.event.extendedProps
                            .type)) {
                        document.getElementById('eventFertilizerName').value = info.event.extendedProps
                            .fertilizer_name;
                        document.getElementById('eventAmount').value = info.event.extendedProps.amount;
                        document.getElementById('eventAmountType').value = info.event.extendedProps
                            .amount_type;
                        document.getElementById('fertilizerDetails').style.display = 'block';

                        // Show the "View Fertilizer Image" button
                        document.getElementById('viewFertilizerImageBtn').style.display =
                            'inline-block';

                        // Set the image source for the fertilizer image modal
                        const imagePath = info.event.extendedProps.fertilizer_image ?
                            info.event.extendedProps
                            .fertilizer_image // Use the full URL from Storage::url
                            :
                            '/images/placeholder.jpg'; // Fallback image
                        document.getElementById('fertilizerImageDisplay').src = imagePath;
                    } else {
                        document.getElementById('fertilizerDetails').style.display = 'none';
                        document.getElementById('viewFertilizerImageBtn').style.display = 'none';
                    }

                    // Show the event details modal
                    var modal = new bootstrap.Modal(document.getElementById('eventModal'));
                    modal.show();
                }
            });

            calendar.render();

            // Add event listener for the "View Fertilizer Image" button
            document.getElementById('viewFertilizerImageBtn').addEventListener('click', function() {
                var fertilizerImageModal = new bootstrap.Modal(document.getElementById(
                    'fertilizerImageModal'));
                fertilizerImageModal.show();
            });
        });
    </script>




    <!-- SweetAlert2 CSS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">

    <!-- SweetAlert2 JS -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Fetch the authenticated user's role and job type
            const userRole = "<?php echo e($user->role); ?>";
            const userJobType = "<?php echo e($user->job_type); ?>";

            // Only proceed if the user is Penanam or Pengait
            if (userRole === 'Pekerja' && (userJobType === 'Penanam' || userJobType === 'Pengait')) {
                // Fetch the events data passed from the backend
                const events = <?php echo json_encode($events, 15, 512) ?>;

                // Log the events for debugging
                console.log(events);

                // Get today's date
                const today = new Date();
                today.setHours(0, 0, 0, 0); // Set time to midnight for accurate comparison

                // Filter events that are due today
                const todayEvents = events.filter(event => {
                    const eventDate = new Date(event.start);
                    eventDate.setHours(0, 0, 0, 0); // Set time to midnight for accurate comparison
                    return eventDate.getTime() === today.getTime(); // Events due today
                });

                // Log the filtered events for debugging
                console.log(todayEvents);

                // Show alerts for today's events
                todayEvents.forEach((event, index) => {
                    // Check if the event type is "Tuai" (harvest) and the user is Pengait
                    if (event.extendedProps.type === 'Tuai' && userJobType !== 'Pengait') {
                        return; // Skip this event if the user is not Pengait
                    }

                    // Check if the event type is "Tanam" (planting) and the user is Penanam
                    if (event.extendedProps.type === 'Tanam' && userJobType !== 'Penanam') {
                        return; // Skip this event if the user is not Penanam
                    }

                    // Delay each alert to avoid overlapping
                    setTimeout(() => {
                        const eventDate = new Date(event.start).toLocaleDateString();
                        let message = `Anda mempunyai tugas "${event.title}" pada ${eventDate}.`;

                        // Customize the message based on the event type
                        switch (event.extendedProps.type) {
                            case 'Tanam':
                                message += "\nTugas: Menanam tanaman.";
                                break;
                            case 'Tuai':
                                message += "\nTugas: Menuai hasil tanaman.";
                                break;
                            case 'Tumbesaran':
                                message += "\nTugas: Membaja (Baja Tumbesaran).";
                                break;
                            case 'Akar':
                                message += "\nTugas: Membaja (Baja Akar).";
                                break;
                            case 'Buah':
                                message += "\nTugas: Membaja (Baja Buah).";
                                break;
                            case 'Matang':
                                message += "\nTugas: Membaja (Baja Matang).";
                                break;
                        }

                        // Show SweetAlert2 alert
                        Swal.fire({
                            title: 'Pengingat Tugas',
                            text: message,
                            icon: 'info',
                            confirmButtonText: 'OK'
                        });
                    }, index * 5000); // Delay each alert by 5 seconds
                });
            }
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\desa-grow-farm\resources\views/dashboard.blade.php ENDPATH**/ ?>