@extends('layouts.base')

@section('content')
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="javascript: void(0);">Tanaman</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('plantation.index') }}">Tanaman</a></li>
                        <li class="breadcrumb-item active">Papar Tanaman</li>
                    </ol>
                </div>
                <h4 class="page-title">Pengurusan Tanaman</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->

    {{-- Display Tuan Kebun --}}
    @if (auth()->user()->role === 'Tuan_Kebun')
        <div class="row">
            <div class="col-xl-12">
                <div class="card mb">
                    <div class="container-fluid mt-2">
                        <div class="row">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-body">
                                        <div class="row g-2">
                                            <div class="col-md-11 col-12">
                                                <h3 class="header-title">Tanaman Semasa #{{ $plantations->id }}</h3>
                                                <p class="text-muted font-12">
                                                    {{ $plantations->created_at->format('d-m-Y') }}
                                                </p>
                                            </div>
                                            <div class="col-md-1 col-12">
                                                @if ($plantations->status == 'Baru')
                                                    <span class="badge badge-danger">Tanaman Baru</span>
                                                @elseif($plantations->status == 'Proses Tanam')
                                                    <span class="badge badge-warning">Dalam Kerja</span>
                                                @elseif($plantations->status == 'Tanam')
                                                    <span class="badge badge-info">Tanam</span>
                                                @elseif($plantations->status == 'Tuai Hasil')
                                                    <span class="badge badge-success">Tuai Hasil</span>
                                                @elseif($plantations->status == 'Kira Hasil')
                                                    <span class="badge badge-light">Kira Hasil</span>
                                                @elseif($plantations->status == 'Selesai')
                                                    <span class="badge badge-secondary">Selesai</span>
                                                @endif
                                            </div>
                                            <div class="col-md-8 col-12">
                                                <!-- assignee -->
                                                <p class="mt-2 mb-1 text-muted font-weight-bold font-12 text-uppercase">
                                                    Ditugaskan Kepada</p>
                                                <div class="media">
                                                    <i class="dripicons-user font-18 text-primary"></i> &nbsp;
                                                    <div class="media-body">
                                                        <h5 class="mt-1 font-14">
                                                            {{ $plantations->penanam->name }} &
                                                            {{ $plantations->pengait->name }}
                                                        </h5>
                                                    </div>
                                                </div>
                                                <!-- end assignee -->
                                            </div> <!-- end col -->
                                            <div class="col-md-4 col-12">
                                                <!-- start due date -->
                                                <p class="mt-2 mb-1 text-muted font-weight-bold font-12 text-uppercase">
                                                    Tarikh
                                                    Tugasan</p>
                                                <div class="media">
                                                    <i class="uil uil-schedule font-18 text-success"></i>
                                                    <div class="media-body">
                                                        <h5 class="mt-1 font-14">
                                                            {{ $plantations->plant_date }} Sehingga
                                                            {{ $plantations->harvest_date }}
                                                        </h5>
                                                    </div>
                                                </div>
                                                <!-- end due date -->
                                            </div> <!-- end col -->
                                        </div>
                                    </div> <!-- end card-body-->
                                </div><!-- end card-->
                            </div> <!-- end col -->
                        </div> <!-- end row -->

                        <div class="row">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-body">
                                        <h4 class="header-title">Maklumat Kebun</h4>
                                        <div class="row justify-content-center  g-2 mt-4">
                                            <div class="col-lg-6">
                                                <label for="example-week">Nama Kebun</label>
                                                <p>{{ $plantations->farm->name }}</p>
                                            </div>

                                            <div class="col-lg-6">
                                                <label for="example-week">Bilangan Tanam</label>
                                                <p>{{ $plantations->quantity_plant }} Batang</p>
                                            </div>
                                            <div class="col-lg-6 mt-2">
                                                <label for="example-week">Saiz Kebun</label>
                                                <p>{{ $plantations->farm->size }} ha</p>
                                            </div>
                                            <div class="col-lg-6 mt-2">
                                                <label for="example-week">Alamat Kebun</label>
                                                <p>{{ $plantations->farm->address }}</p>
                                            </div>
                                        </div>
                                        <hr><br>

                                        <h4 class="header-title ">Maklumat Tanaman</h4>
                                        <div class="row justify-content-center mt-3">
                                            <div class="col-lg-6">
                                                <label for="example-week">Jenis Pokok</label>
                                                <p>{{ $plantations->plantDetail->plant_type }}</p>
                                            </div>

                                            <div class="col-lg-6">
                                                <label for="example-week">Tempoh Kematangan</label>
                                                <p>{{ $plantations->plantDetail->plant_maturity }} Bulan</p>
                                            </div>
                                            <div class="col-lg-6 mt-2">
                                                <label for="example-week">Tarikh Penanaman</label>
                                                <p>{{ $plantations->plant_date }}</p>
                                            </div>
                                            <div class="col-lg-6 mt-2">
                                                <label for="example-week">Tarikh Penuaian</label>
                                                <p>{{ $plantations->harvest_date }}</p>
                                            </div>
                                            <div class="col-lg-6 mt-2">
                                                <label for="example-week">Penanam</label>
                                                <p> <i class="dripicons-user font-18 text-primary"></i>
                                                    &nbsp;{{ $plantations->penanam->name }}</p>
                                            </div>
                                            <div class="col-lg-6 mt-2">
                                                <label for="example-week">Pengait</label>
                                                <p> <i class="dripicons-user font-18 text-primary"></i>
                                                    &nbsp;{{ $plantations->pengait->name }}</p>
                                            </div>

                                            <div class="col-lg-6 mt-2">
                                                <label for="example-week">Bukti Tanam</label>
                                                <p class="form-control-plaintext">
                                                    @if ($plantations && $plantations->image_tanam)
                                                        <a href="{{ Storage::url($plantations->image_tanam) }}"
                                                            target="_blank">Papar Bukti</a>
                                                    @else
                                                        <a href="javascript:void(0);" class="text-muted"
                                                            style="pointer-events: none;">Tiada Bukti Tanam Dimuat Naik</a>
                                                    @endif
                                                </p>
                                            </div>
                                            <div class="col-lg-6 mt-2">
                                                <label for="example-week">Bukti Tuai</label>
                                                <p class="form-control-plaintext">
                                                    @if ($plantations && $plantations->image_kait)
                                                        <a href="{{ Storage::url($plantations->image_kait) }}"
                                                            target="_blank">Papar Bukti</a>
                                                    @else
                                                        <a href="javascript:void(0);" class="text-muted"
                                                            style="pointer-events: none;">Tiada Bukti Kait Dimuat Naik</a>
                                                    @endif
                                                </p>
                                            </div>
                                        </div>
                                    </div> <!-- end card-body-->
                                </div><!-- end card-->
                            </div> <!-- end col -->
                        </div> <!-- end row -->

                        <div class="row">
                            <div class="col-xl-12">
                                <div class="card">
                                    <div class="card-body">
                                        <h4 class="header-title">Maklumat Baja</h4>
                                        <div class="table-responsive mt-1">
                                            <p class="mt-2 mb-1 text-muted  font-13 ">Baja
                                                {{ $plantations->tumbesaran->fertilizerDetail->fertilizerCategory->name }}
                                            </p>
                                            <table class="table table-bordered table-centered mb-0">
                                                <thead class="thead-light">
                                                    <tr>
                                                        <th>Nama </th>
                                                        <th>Kategori Baja </th>
                                                        <th>Quantiti</th>
                                                        <th>Tempoh Membaja</th>
                                                        <th>Kekerapan Membaja</th>
                                                        <th>Tarikh Membaja</th>

                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr>
                                                        <td>{{ $plantations->tumbesaran->fertilizerDetail->fertilizer_name }}
                                                        </td>
                                                        <td>{{ $plantations->tumbesaran->fertilizerDetail->fertilizerCategory->name }}
                                                        </td>
                                                        <td>{{ $plantations->tumbesaran->amount }}{{ $plantations->tumbesaran->amount_type }}
                                                        </td>
                                                        <td>{{ $plantations->tumbesaran->duration }}</td>
                                                        <td>{{ $plantations->tumbesaran->frequency }} Kali</td>
                                                        <td>
                                                            <ul>
                                                                @foreach (explode(',', $plantations->tumbesaran_date) as $date)
                                                                    <li>{{ trim($date) }}</li>
                                                                @endforeach
                                                            </ul>
                                                        </td>
                                                    </tr>

                                                </tbody>
                                            </table>

                                            <br>
                                            <p class="mt-2 mb-1 text-muted  font-13 ">Baja
                                                {{ $plantations->akar->fertilizerDetail->fertilizerCategory->name }}</p>

                                            <table class="table table-bordered table-centered mb-0">
                                                <thead class="thead-light">
                                                    <tr>
                                                        <th>Nama </th>
                                                        <th>Kategori Baja </th>
                                                        <th>Quantiti</th>
                                                        <th>Tempoh Membaja</th>
                                                        <th>Kekerapan Membaja</th>
                                                        <th>Tarikh Membaja</th>

                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr>
                                                        <td>{{ $plantations->akar->fertilizerDetail->fertilizer_name }}
                                                        </td>
                                                        <td>{{ $plantations->akar->fertilizerDetail->fertilizerCategory->name }}
                                                        </td>
                                                        <td>{{ $plantations->akar->amount }}{{ $plantations->akar->amount_type }}
                                                        </td>
                                                        <td>{{ $plantations->akar->duration }}</td>
                                                        <td>{{ $plantations->akar->frequency }} Kali</td>

                                                        <td>
                                                            <ul>
                                                                @foreach (explode(',', $plantations->akar_date) as $date)
                                                                    <li>{{ trim($date) }}</li>
                                                                @endforeach
                                                            </ul>
                                                        </td>
                                                    </tr>

                                                </tbody>
                                            </table>
                                            <br>

                                            <p class="mt-2 mb-1 text-muted  font-13 ">Baja
                                                {{ $plantations->buah->fertilizerDetail->fertilizerCategory->name }}</p>
                                            <table class="table table-bordered table-centered mb-0">
                                                <thead class="thead-light">
                                                    <tr>
                                                        <th>Nama </th>
                                                        <th>Kategori Baja </th>
                                                        <th>Quantiti</th>
                                                        <th>Tempoh Membaja</th>
                                                        <th>Kekerapan Membaja</th>
                                                        <th>Tarikh Membaja</th>

                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr>
                                                        <td>{{ $plantations->buah->fertilizerDetail->fertilizer_name }}
                                                        </td>
                                                        <td>{{ $plantations->buah->fertilizerDetail->fertilizerCategory->name }}
                                                        </td>
                                                        <td>{{ $plantations->buah->amount }}{{ $plantations->buah->amount_type }}
                                                        </td>
                                                        <td>{{ $plantations->buah->duration }}</td>
                                                        <td>{{ $plantations->buah->frequency }} Kali</td>
                                                        <td>
                                                            <button type="button" class="btn btn-secondary"
                                                                data-toggle="modal"
                                                                data-target="#bs-example-modal-lg">Papar
                                                                Tarikh</button>
                                                            <div class="modal fade" id="bs-example-modal-lg"
                                                                tabindex="-1" role="dialog"
                                                                aria-labelledby="myLargeModalLabel" aria-hidden="true">
                                                                <div class="modal-dialog modal-lg">
                                                                    <div class="modal-content">
                                                                        <div class="modal-header">
                                                                            <h4 class="modal-title"
                                                                                id="mylargeModalLabel">
                                                                                Senarai Tarikh Pembajaan</h4>
                                                                            <button type="button" class="close"
                                                                                data-dismiss="modal"
                                                                                aria-hidden="true">×</button>
                                                                        </div>
                                                                        <div class="modal-body">
                                                                            @if (!empty($plantations->buah_date))
                                                                                <table
                                                                                    class="table table-sm table-centered mb-0">
                                                                                    <thead>
                                                                                        <tr>
                                                                                            <th>Bil</th>
                                                                                            <th>Tarikh</th>
                                                                                        </tr>
                                                                                    </thead>
                                                                                    <tbody>
                                                                                        @foreach (explode(',', $plantations->buah_date) as $index => $date)
                                                                                            <tr>
                                                                                                <td>{{ $index + 1 }}
                                                                                                </td>
                                                                                                <td>{{ trim($date) }}
                                                                                                </td>
                                                                                            </tr>
                                                                                        @endforeach
                                                                                    </tbody>
                                                                                </table>
                                                                            @else
                                                                                <p class="text-muted">Tiada tarikh
                                                                                    tersedia.</p>
                                                                            @endif
                                                                        </div>
                                                                    </div><!-- /.modal-content -->
                                                                </div><!-- /.modal-dialog -->
                                                            </div><!-- /.modal -->
                                                        </td>



                                                    </tr>

                                                </tbody>
                                            </table>

                                            <p class="mt-2 mb-1 text-muted  font-13 ">Baja
                                                {{ $plantations->matang->fertilizerDetail->fertilizerCategory->name }}</p>
                                            <table class="table table-bordered table-centered mb-0">
                                                <thead class="thead-light">
                                                    <tr>
                                                        <th>Nama </th>
                                                        <th>Kategori Baja </th>
                                                        <th>Quantiti</th>
                                                        <th>Tempoh Membaja</th>
                                                        <th>Kekerapan Membaja</th>
                                                        <th>Tarikh Membaja</th>

                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr>
                                                        <td>{{ $plantations->matang->fertilizerDetail->fertilizer_name }}
                                                        </td>
                                                        <td>{{ $plantations->matang->fertilizerDetail->fertilizerCategory->name }}
                                                        </td>
                                                        <td>{{ $plantations->matang->amount }}{{ $plantations->matang->amount_type }}
                                                        </td>
                                                        <td>{{ $plantations->matang->duration }}</td>
                                                        <td>{{ $plantations->matang->frequency }} Kali</td>
                                                        <td>
                                                            <ul>
                                                                @foreach (explode(',', $plantations->matang_date) as $date)
                                                                    <li>{{ trim($date) }}</li>
                                                                @endforeach
                                                            </ul>
                                                        </td>

                                                    </tr>

                                                </tbody>
                                            </table>
                                        </div> <!-- end table-responsive-->

                                        <br>
                                        <div class="text-center mt-2">
                                            <button type="button" onclick="history.back()"
                                                class="btn btn-info">Kembali</button>
                                        </div>

                                    </div>

                                </div> <!-- end card-->
                            </div> <!-- end col -->
                        </div>
                    </div> <!-- container-fluid -->

                </div> <!-- end card -->
            </div>

        </div>
    @endif

    {{-- Display Penanam --}}
    @if (auth()->user()->job_type === 'Penanam' )
        <div class="row">
            <div class="col-xl-12">
                <div class="card mb">
                    <div class="container-fluid mt-2">
                        <div class="row">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-body">
                                        <div class="row g-2">
                                            <div class="col-md-11 col-12">
                                                <h3 class="header-title">Tanaman Semasa #{{ $plantations->id }}</h3>
                                                <p class="text-muted font-12">
                                                    {{ $plantations->created_at->format('d-m-Y') }}
                                                </p>
                                            </div>
                                            <div class="col-md-1 col-12">
                                                @if ($plantations->status == 'Baru')
                                                    <span class="badge badge-danger">Tanaman Baru</span>
                                                @elseif($plantations->status == 'Proses Tanam')
                                                    <span class="badge badge-danger">Dalam Kerja</span>
                                                @elseif($plantations->status == 'Tanam')
                                                    <span class="badge badge-info">Tanam</span>
                                                @elseif($plantations->status == 'Tuai Hasil')
                                                    <span class="badge badge-success">Tuai Hasil</span>
                                                @elseif($plantations->status == 'Kira Hasil')
                                                    <span class="badge badge-light">Kira Hasil</span>
                                                @elseif($plantations->status == 'Selesai')
                                                    <span class="badge badge-secondary">Selesai</span>
                                                @endif
                                            </div>
                                            <div class="col-md-8 col-12">
                                                <!-- assignee -->
                                                <p class="mt-2 mb-1 text-muted font-weight-bold font-12 text-uppercase">
                                                    Ditugaskan Kepada</p>
                                                <div class="media">
                                                    <i class="dripicons-user font-18 text-primary"></i> &nbsp;
                                                    <div class="media-body">
                                                        <h5 class="mt-1 font-14">
                                                            {{ $plantations->penanam->name }}
                                                        </h5>
                                                    </div>
                                                </div>
                                                <!-- end assignee -->
                                            </div> <!-- end col -->
                                            <div class="col-md-4 col-12">
                                                <!-- start due date -->
                                                <p class="mt-2 mb-1 text-muted font-weight-bold font-12 text-uppercase">
                                                    Tarikh
                                                    Tugasan</p>
                                                <div class="media">
                                                    <i class="uil uil-schedule font-18 text-success"></i>
                                                    <div class="media-body">
                                                        <h5 class="mt-1 font-14">
                                                            {{ $plantations->plant_date }}
                                                        </h5>
                                                    </div>
                                                </div>
                                                <!-- end due date -->
                                            </div> <!-- end col -->
                                        </div>
                                    </div> <!-- end card-body-->
                                </div><!-- end card-->
                            </div> <!-- end col -->
                        </div> <!-- end row -->

                        <div class="row">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-body">
                                        <h4 class="header-title">Maklumat Kebun</h4>
                                        <div class="row justify-content-center  g-2 mt-4">
                                            <div class="col-lg-6">
                                                <label for="example-week">Nama Kebun</label>
                                                <p>{{ $plantations->farm->name }}</p>
                                            </div>

                                            <div class="col-lg-6">
                                                <label for="example-week">Jenis Kebun</label>
                                                <p>{{ $plantations->farm->category->name }}</p>
                                            </div>
                                            <div class="col-lg-6 mt-2">
                                                <label for="example-week">Saiz Kebun</label>
                                                <p>{{ $plantations->farm->size }} ha</p>
                                            </div>
                                            <div class="col-lg-6 mt-2">
                                                <label for="example-week">Alamat Kebun</label>
                                                <p>{{ $plantations->farm->address }}</p>
                                            </div>
                                        </div>
                                        <hr><br>

                                        <h4 class="header-title ">Maklumat Tanaman</h4>
                                        <div class="row justify-content-center mt-3">
                                            <div class="col-lg-6">
                                                <label for="example-week">Jenis Pokok</label>
                                                <p>{{ $plantations->farm->category->name }}
                                                    {{ $plantations->plantDetail->plant_type }}</p>
                                            </div>

                                            <div class="col-lg-6">
                                                <label for="example-week">Tempoh Kematangan</label>
                                                <p>{{ $plantations->plantDetail->plant_maturity }} Bulan</p>
                                            </div>
                                            <div class="col-lg-6 mt-2">
                                                <label for="example-week">Bilangan Tanam</label>
                                                <p>{{ $plantations->quantity_plant }} Batang</p>
                                            </div>
                                            <div class="col-lg-6 mt-2">
                                                <label for="example-week">Bukti Tanam</label>
                                                <p class="form-control-plaintext">
                                                    @if ($plantations && $plantations->image_tanam)
                                                        <a href="{{ Storage::url($plantations->image_tanam) }}"
                                                            target="_blank">Papar Bukti</a>
                                                    @else
                                                        <a href="javascript:void(0);" class="text-muted"
                                                            style="pointer-events: none;">Tiada Bukti Tanam Dimuat Naik</a>
                                                    @endif
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                </div> <!-- end card-body-->
                            </div><!-- end card-->
                        </div> <!-- end col -->
                    </div> <!-- end row -->

                    <div class="row">
                        <div class="col-xl-12">
                            <div class="card">
                                <div class="card-body">
                                    <h4 class="header-title">Maklumat Baja</h4>
                                    <div class="table-responsive mt-1">
                                        <p class="mt-2 mb-1 text-muted  font-13 ">Baja
                                            {{ $plantations->tumbesaran->fertilizerDetail->fertilizerCategory->name }}
                                        </p>
                                        <table class="table table-bordered table-centered mb-0">
                                            <thead class="thead-light">
                                                <tr>
                                                    <th>Nama </th>
                                                    <th>Kategori Baja </th>
                                                    <th>Quantiti</th>
                                                    <th>Tempoh Membaja</th>
                                                    <th>Kekerapan Membaja</th>
                                                    <th>Tarikh Membaja</th>

                                                </tr>
                                            </thead>
                                            <tbody>
                                                <tr>
                                                    <td>{{ $plantations->tumbesaran->fertilizerDetail->fertilizer_name }}
                                                    </td>
                                                    <td>{{ $plantations->tumbesaran->fertilizerDetail->fertilizerCategory->name }}
                                                    </td>
                                                    <td>{{ $plantations->tumbesaran->amount }}{{ $plantations->tumbesaran->amount_type }}
                                                    </td>
                                                    <td>{{ $plantations->tumbesaran->duration }}</td>
                                                    <td>{{ $plantations->tumbesaran->frequency }} Kali</td>
                                                    <td>
                                                        <ul>
                                                            @foreach (explode(',', $plantations->tumbesaran_date) as $date)
                                                                <li>{{ trim($date) }}</li>
                                                            @endforeach
                                                        </ul>
                                                    </td>
                                                </tr>

                                            </tbody>
                                        </table>

                                        <br>
                                        <p class="mt-2 mb-1 text-muted  font-13 ">Baja
                                            {{ $plantations->akar->fertilizerDetail->fertilizerCategory->name }}</p>

                                        <table class="table table-bordered table-centered mb-0">
                                            <thead class="thead-light">
                                                <tr>
                                                    <th>Nama </th>
                                                    <th>Kategori Baja </th>
                                                    <th>Quantiti</th>
                                                    <th>Tempoh Membaja</th>
                                                    <th>Kekerapan Membaja</th>
                                                    <th>Tarikh Membaja</th>

                                                </tr>
                                            </thead>
                                            <tbody>
                                                <tr>
                                                    <td>{{ $plantations->akar->fertilizerDetail->fertilizer_name }}
                                                    </td>
                                                    <td>{{ $plantations->akar->fertilizerDetail->fertilizerCategory->name }}
                                                    </td>
                                                    <td>{{ $plantations->akar->amount }}{{ $plantations->akar->amount_type }}
                                                    </td>
                                                    <td>{{ $plantations->akar->duration }}</td>
                                                    <td>{{ $plantations->akar->frequency }} Kali</td>

                                                    <td>
                                                        <ul>
                                                            @foreach (explode(',', $plantations->akar_date) as $date)
                                                                <li>{{ trim($date) }}</li>
                                                            @endforeach
                                                        </ul>
                                                    </td>
                                                </tr>

                                            </tbody>
                                        </table>
                                        <br>

                                        <p class="mt-2 mb-1 text-muted  font-13 ">Baja
                                            {{ $plantations->buah->fertilizerDetail->fertilizerCategory->name }}</p>
                                        <table class="table table-bordered table-centered mb-0">
                                            <thead class="thead-light">
                                                <tr>
                                                    <th>Nama </th>
                                                    <th>Kategori Baja </th>
                                                    <th>Quantiti</th>
                                                    <th>Tempoh Membaja</th>
                                                    <th>Kekerapan Membaja</th>
                                                    <th>Tarikh Membaja</th>

                                                </tr>
                                            </thead>
                                            <tbody>
                                                <tr>
                                                    <td>{{ $plantations->buah->fertilizerDetail->fertilizer_name }}
                                                    </td>
                                                    <td>{{ $plantations->buah->fertilizerDetail->fertilizerCategory->name }}
                                                    </td>
                                                    <td>{{ $plantations->buah->amount }}{{ $plantations->buah->amount_type }}
                                                    </td>
                                                    <td>{{ $plantations->buah->duration }}</td>
                                                    <td>{{ $plantations->buah->frequency }} Kali</td>
                                                    <td>
                                                        <button type="button" class="btn btn-secondary"
                                                            data-toggle="modal" data-target="#bs-example-modal-lg">Papar
                                                            Tarikh</button>
                                                        <div class="modal fade" id="bs-example-modal-lg" tabindex="-1"
                                                            role="dialog" aria-labelledby="myLargeModalLabel"
                                                            aria-hidden="true">
                                                            <div class="modal-dialog modal-lg">
                                                                <div class="modal-content">
                                                                    <div class="modal-header">
                                                                        <h4 class="modal-title" id="mylargeModalLabel">
                                                                            Senarai Tarikh
                                                                            Pembajaan</h4>
                                                                        <button type="button" class="close"
                                                                            data-dismiss="modal"
                                                                            aria-hidden="true">×</button>
                                                                    </div>
                                                                    <div class="modal-body">
                                                                        @if (!empty($plantations->buah_date))
                                                                            <table
                                                                                class="table table-sm table-centered mb-0">
                                                                                <thead>
                                                                                    <tr>
                                                                                        <th>Bil</th>
                                                                                        <th>Tarikh</th>
                                                                                    </tr>
                                                                                </thead>
                                                                                <tbody>
                                                                                    @foreach (explode(',', $plantations->buah_date) as $index => $date)
                                                                                        <tr>
                                                                                            <td>{{ $index + 1 }}
                                                                                            </td>
                                                                                            <td>{{ trim($date) }}
                                                                                            </td>
                                                                                        </tr>
                                                                                    @endforeach
                                                                                </tbody>
                                                                            </table>
                                                                        @else
                                                                            <p class="text-muted">Tiada tarikh
                                                                                tersedia.</p>
                                                                        @endif
                                                                    </div>
                                                                </div><!-- /.modal-content -->
                                                            </div><!-- /.modal-dialog -->
                                                        </div><!-- /.modal -->
                                                    </td>



                                                </tr>

                                            </tbody>
                                        </table>

                                        <p class="mt-2 mb-1 text-muted  font-13 ">Baja
                                            {{ $plantations->matang->fertilizerDetail->fertilizerCategory->name }}</p>
                                        <table class="table table-bordered table-centered mb-0">
                                            <thead class="thead-light">
                                                <tr>
                                                    <th>Nama </th>
                                                    <th>Kategori Baja </th>
                                                    <th>Quantiti</th>
                                                    <th>Tempoh Membaja</th>
                                                    <th>Kekerapan Membaja</th>
                                                    <th>Tarikh Membaja</th>

                                                </tr>
                                            </thead>
                                            <tbody>
                                                <tr>
                                                    <td>{{ $plantations->matang->fertilizerDetail->fertilizer_name }}
                                                    </td>
                                                    <td>{{ $plantations->matang->fertilizerDetail->fertilizerCategory->name }}
                                                    </td>
                                                    <td>{{ $plantations->matang->amount }}{{ $plantations->matang->amount_type }}
                                                    </td>
                                                    <td>{{ $plantations->matang->duration }}</td>
                                                    <td>{{ $plantations->matang->frequency }} Kali</td>
                                                    <td>
                                                        <ul>
                                                            @foreach (explode(',', $plantations->matang_date) as $date)
                                                                <li>{{ trim($date) }}</li>
                                                            @endforeach
                                                        </ul>
                                                    </td>

                                                </tr>

                                            </tbody>
                                        </table>
                                    </div> <!-- end table-responsive-->
                                    <br>
                                    <div class="text-center mt-2">
                                        <button type="button" onclick="history.back()"
                                            class="btn btn-primary">Kembali</button>
                                    </div>

                                </div>

                            </div> <!-- end card-->
                        </div> <!-- end col -->
                    </div>
                </div> <!-- container-fluid -->

            </div> <!-- end card -->
        </div>

        </div>
    @endif

    {{-- Display Pengait --}}
    @if (auth()->user()->job_type === 'Pengait')
        <div class="row">
            <div class="col-xl-12">
                <div class="card mb">
                    <div class="container-fluid mt-2">
                        <div class="row">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-body">
                                        <div class="row g-2">
                                            <div class="col-md-11 col-12">
                                                <h3 class="header-title">Tanaman Semasa #{{ $plantations->id }}</h3>
                                                <p class="text-muted font-12">
                                                    {{ $plantations->created_at->format('d-m-Y') }}
                                                </p>
                                            </div>
                                            <div class="col-md-1 col-12">
                                                @if ($plantations->status == 'Baru')
                                                    <span class="badge badge-danger">Tanaman Baru</span>
                                                @elseif($plantations->status == 'Proses Tanam')
                                                    <span class="badge badge-danger">Dalam Kerja</span>
                                                @elseif($plantations->status == 'Tanam')
                                                    <span class="badge badge-info">Tanam</span>
                                                @elseif($plantations->status == 'Tuai Hasil')
                                                    <span class="badge badge-success">Tuai Hasil</span>
                                                @elseif($plantations->status == 'Kira Hasil')
                                                    <span class="badge badge-light">Kira Hasil</span>
                                                @elseif($plantations->status == 'Selesai')
                                                    <span class="badge badge-secondary">Selesai</span>
                                                @endif
                                            </div>
                                            <div class="col-md-8 col-12">
                                                <!-- assignee -->
                                                <p class="mt-2 mb-1 text-muted font-weight-bold font-12 text-uppercase">
                                                    Ditugaskan Kepada</p>
                                                <div class="media">
                                                    <i class="dripicons-user font-18 text-primary"></i> &nbsp;
                                                    <div class="media-body">
                                                        <h5 class="mt-1 font-14">
                                                            {{ $plantations->pengait->name }}
                                                        </h5>
                                                    </div>
                                                </div>
                                                <!-- end assignee -->
                                            </div> <!-- end col -->
                                            <div class="col-md-4 col-12">
                                                <!-- start due date -->
                                                <p class="mt-2 mb-1 text-muted font-weight-bold font-12 text-uppercase">
                                                    Tarikh
                                                    Tugasan</p>
                                                <div class="media">
                                                    <i class="uil uil-schedule font-18 text-success"></i>
                                                    <div class="media-body">
                                                        <h5 class="mt-1 font-14">
                                                            {{ $plantations->harvest_date }}
                                                        </h5>
                                                    </div>
                                                </div>
                                                <!-- end due date -->
                                            </div> <!-- end col -->
                                        </div>
                                    </div> <!-- end card-body-->
                                </div><!-- end card-->
                            </div> <!-- end col -->
                        </div> <!-- end row -->

                        <div class="row">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-body">
                                        <h4 class="header-title">Maklumat Kebun</h4>
                                        <div class="row justify-content-center  g-2 mt-4">
                                            <div class="col-lg-6">
                                                <label for="example-week">Nama Kebun</label>
                                                <p>{{ $plantations->farm->name }}</p>
                                            </div>

                                            <div class="col-lg-6">
                                                <label for="example-week">Jenis Kebun</label>
                                                <p>{{ $plantations->farm->category->name }}</p>
                                            </div>
                                            <div class="col-lg-6 mt-2">
                                                <label for="example-week">Saiz Kebun</label>
                                                <p>{{ $plantations->farm->size }} ha</p>
                                            </div>
                                            <div class="col-lg-6 mt-2">
                                                <label for="example-week">Alamat Kebun</label>
                                                <p>{{ $plantations->farm->address }}</p>
                                            </div>
                                        </div>
                                        <hr><br>

                                        <h4 class="header-title ">Maklumat Tanaman</h4>
                                        <div class="row justify-content-center mt-3">
                                            <div class="col-lg-6">
                                                <label for="example-week">Jenis Pokok</label>
                                                <p>{{ $plantations->farm->category->name }}
                                                    {{ $plantations->plantDetail->plant_type }}</p>
                                            </div>

                                            <div class="col-lg-6">
                                                <label for="example-week">Tempoh Kematangan</label>
                                                <p>{{ $plantations->plantDetail->plant_maturity }} Bulan</p>
                                            </div>
                                            <div class="col-lg-6 mt-2">
                                                <label for="example-week">Bilangan Tuai</label>
                                                <p>{{ $plantations->quantity_plant }} Batang</p>
                                            </div>
                                            <div class="col-lg-6 mt-2">
                                                <label for="example-week">Bukti Tuai</label>
                                                <p class="form-control-plaintext">
                                                    @if ($plantations && $plantations->image_kait)
                                                        <a href="{{ Storage::url($plantations->image_kait) }}"
                                                            target="_blank">Papar Bukti</a>
                                                    @else
                                                        <a href="javascript:void(0);" class="text-muted"
                                                            style="pointer-events: none;">Tiada Bukti Tuai Dimuat Naik</a>
                                                    @endif
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                </div> <!-- end card-body-->
                            </div><!-- end card-->
                        </div> <!-- end col -->

                    </div> <!-- end row -->

                    <div class="row">
                        <div class="col-xl-12">
                            <div class="card">
                                <div class="card-body">
                                    <h4 class="header-title">Maklumat Baja</h4>
                                    <div class="table-responsive mt-1">
                                        <p class="mt-2 mb-1 text-muted  font-13 ">Baja
                                            {{ $plantations->tumbesaran->fertilizerDetail->fertilizerCategory->name }}
                                        </p>
                                        <table class="table table-bordered table-centered mb-0">
                                            <thead class="thead-light">
                                                <tr>
                                                    <th>Nama </th>
                                                    <th>Kategori Baja </th>
                                                    <th>Quantiti</th>
                                                    <th>Tempoh Membaja</th>
                                                    <th>Kekerapan Membaja</th>
                                                    <th>Tarikh Membaja</th>

                                                </tr>
                                            </thead>
                                            <tbody>
                                                <tr>
                                                    <td>{{ $plantations->tumbesaran->fertilizerDetail->fertilizer_name }}
                                                    </td>
                                                    <td>{{ $plantations->tumbesaran->fertilizerDetail->fertilizerCategory->name }}
                                                    </td>
                                                    <td>{{ $plantations->tumbesaran->amount }}{{ $plantations->tumbesaran->amount_type }}
                                                    </td>
                                                    <td>{{ $plantations->tumbesaran->duration }}</td>
                                                    <td>{{ $plantations->tumbesaran->frequency }} Kali</td>
                                                    <td>
                                                        <ul>
                                                            @foreach (explode(',', $plantations->tumbesaran_date) as $date)
                                                                <li>{{ trim($date) }}</li>
                                                            @endforeach
                                                        </ul>
                                                    </td>
                                                </tr>

                                            </tbody>
                                        </table>

                                        <br>
                                        <p class="mt-2 mb-1 text-muted  font-13 ">Baja
                                            {{ $plantations->akar->fertilizerDetail->fertilizerCategory->name }}</p>

                                        <table class="table table-bordered table-centered mb-0">
                                            <thead class="thead-light">
                                                <tr>
                                                    <th>Nama </th>
                                                    <th>Kategori Baja </th>
                                                    <th>Quantiti</th>
                                                    <th>Tempoh Membaja</th>
                                                    <th>Kekerapan Membaja</th>
                                                    <th>Tarikh Membaja</th>

                                                </tr>
                                            </thead>
                                            <tbody>
                                                <tr>
                                                    <td>{{ $plantations->akar->fertilizerDetail->fertilizer_name }}
                                                    </td>
                                                    <td>{{ $plantations->akar->fertilizerDetail->fertilizerCategory->name }}
                                                    </td>
                                                    <td>{{ $plantations->akar->amount }}{{ $plantations->akar->amount_type }}
                                                    </td>
                                                    <td>{{ $plantations->akar->duration }}</td>
                                                    <td>{{ $plantations->akar->frequency }} Kali</td>

                                                    <td>
                                                        <ul>
                                                            @foreach (explode(',', $plantations->akar_date) as $date)
                                                                <li>{{ trim($date) }}</li>
                                                            @endforeach
                                                        </ul>
                                                    </td>
                                                </tr>

                                            </tbody>
                                        </table>
                                        <br>

                                        <p class="mt-2 mb-1 text-muted  font-13 ">Baja
                                            {{ $plantations->buah->fertilizerDetail->fertilizerCategory->name }}</p>
                                        <table class="table table-bordered table-centered mb-0">
                                            <thead class="thead-light">
                                                <tr>
                                                    <th>Nama </th>
                                                    <th>Kategori Baja </th>
                                                    <th>Quantiti</th>
                                                    <th>Tempoh Membaja</th>
                                                    <th>Kekerapan Membaja</th>
                                                    <th>Tarikh Membaja</th>

                                                </tr>
                                            </thead>
                                            <tbody>
                                                <tr>
                                                    <td>{{ $plantations->buah->fertilizerDetail->fertilizer_name }}
                                                    </td>
                                                    <td>{{ $plantations->buah->fertilizerDetail->fertilizerCategory->name }}
                                                    </td>
                                                    <td>{{ $plantations->buah->amount }}{{ $plantations->buah->amount_type }}
                                                    </td>
                                                    <td>{{ $plantations->buah->duration }}</td>
                                                    <td>{{ $plantations->buah->frequency }} Kali</td>
                                                    <td>
                                                        <button type="button" class="btn btn-secondary"
                                                            data-toggle="modal" data-target="#bs-example-modal-lg">Papar
                                                            Tarikh</button>
                                                        <div class="modal fade" id="bs-example-modal-lg" tabindex="-1"
                                                            role="dialog" aria-labelledby="myLargeModalLabel"
                                                            aria-hidden="true">
                                                            <div class="modal-dialog modal-lg">
                                                                <div class="modal-content">
                                                                    <div class="modal-header">
                                                                        <h4 class="modal-title" id="mylargeModalLabel">
                                                                            Senarai Tarikh
                                                                            Pembajaan</h4>
                                                                        <button type="button" class="close"
                                                                            data-dismiss="modal"
                                                                            aria-hidden="true">×</button>
                                                                    </div>
                                                                    <div class="modal-body">
                                                                        @if (!empty($plantations->buah_date))
                                                                            <table
                                                                                class="table table-sm table-centered mb-0">
                                                                                <thead>
                                                                                    <tr>
                                                                                        <th>Bil</th>
                                                                                        <th>Tarikh</th>
                                                                                    </tr>
                                                                                </thead>
                                                                                <tbody>
                                                                                    @foreach (explode(',', $plantations->buah_date) as $index => $date)
                                                                                        <tr>
                                                                                            <td>{{ $index + 1 }}
                                                                                            </td>
                                                                                            <td>{{ trim($date) }}
                                                                                            </td>
                                                                                        </tr>
                                                                                    @endforeach
                                                                                </tbody>
                                                                            </table>
                                                                        @else
                                                                            <p class="text-muted">Tiada tarikh
                                                                                tersedia.</p>
                                                                        @endif
                                                                    </div>
                                                                </div><!-- /.modal-content -->
                                                            </div><!-- /.modal-dialog -->
                                                        </div><!-- /.modal -->
                                                    </td>



                                                </tr>

                                            </tbody>
                                        </table>

                                        <p class="mt-2 mb-1 text-muted  font-13 ">Baja
                                            {{ $plantations->matang->fertilizerDetail->fertilizerCategory->name }}</p>
                                        <table class="table table-bordered table-centered mb-0">
                                            <thead class="thead-light">
                                                <tr>
                                                    <th>Nama </th>
                                                    <th>Kategori Baja </th>
                                                    <th>Quantiti</th>
                                                    <th>Tempoh Membaja</th>
                                                    <th>Kekerapan Membaja</th>
                                                    <th>Tarikh Membaja</th>

                                                </tr>
                                            </thead>
                                            <tbody>
                                                <tr>
                                                    <td>{{ $plantations->matang->fertilizerDetail->fertilizer_name }}
                                                    </td>
                                                    <td>{{ $plantations->matang->fertilizerDetail->fertilizerCategory->name }}
                                                    </td>
                                                    <td>{{ $plantations->matang->amount }}{{ $plantations->matang->amount_type }}
                                                    </td>
                                                    <td>{{ $plantations->matang->duration }}</td>
                                                    <td>{{ $plantations->matang->frequency }} Kali</td>
                                                    <td>
                                                        <ul>
                                                            @foreach (explode(',', $plantations->matang_date) as $date)
                                                                <li>{{ trim($date) }}</li>
                                                            @endforeach
                                                        </ul>
                                                    </td>

                                                </tr>

                                            </tbody>
                                        </table>
                                    </div> <!-- end table-responsive-->
                                    <br>
                                    <div class="text-center mt-2">
                                        <button type="button" onclick="history.back()"
                                            class="btn btn-primary">Kembali</button>
                                    </div>

                                </div>

                            </div> <!-- end card-->
                        </div> <!-- end col -->
                    </div>
                </div> <!-- container-fluid -->

            </div> <!-- end card -->
        </div>

        </div>
    @endif




@endsection
