@extends('layouts.base')

@section('content')
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('harvest.index') }}">Hasil Kebun</a></li>
                        <li class="breadcrumb-item active">Tambah Hasil</li>
                    </ol>
                </div>
                <h4 class="page-title">Pengurusan Hasil</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <h4 class="header-title">Tambah Hasil</h4>
                    @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif
                    <form role="form" method="POST" action="{{ route('harvest.store') }}"
                    enctype="multipart/form-data">
                    @csrf
                    <input type="hidden" name="plantation_id" value="{{ $plantation->id }}">
                        <div class="form-row">
                            <div class="form-group col-md-6">
                                <label for="inputEmail4" class="col-form-label">Nama Kebun</label>
                                <input type="text" class="form-control" id="inputKategoriKebun" name="plant_category"
                                    value="{{ $plantation->farm->name }}" readonly>
                            </div>
                            <div class="form-group col-md-6 ">
                                <label for="inputEmail4" class="col-form-label">Tarikh Menuai</label>
                                <input type="text" class="form-control" id="inputSaizKebun" name="farm_size"
                                    value="{{ $plantation->harvest_date }}" readonly>
                            </div>
                            <input type="hidden" name="harvest_date" value="{{ $plantation->harvest_date }}">
                        </div>
                        <div class="form-row">
                            <div class="form-group col-md-6">
                                <label for="inputState" class="col-form-label">Kategori Pokok</label>
                                <input type="text" class="form-control" id="inputSaizKebun" name="farm_size"
                                    value="{{ $plantation->farm->category->name }}" readonly>
                            </div>
                            <div class="form-group col-md-6">
                                <label for="inputState" class="col-form-label">Nama Pokok</label>
                                <input type="text" class="form-control" id="inputSaizKebun" name="farm_size"
                                    value="{{ $plantation->plantDetail->plant_type }}" readonly>
                            </div>
                        </div>
                        <p class="text-muted font-14">Maklumat Hasil Tuaian</p>
                        <div class="form-group  ">
                            <label for="inputEmail4" class="col-form-label">Jumlah Tuaian</label>
                            <input type="text" class="form-control" id="inputSaizKebun" name="farm_size"
                                value="{{ $plantation->quantity_plant }} Tandan" readonly>
                        </div>
                        <!-- header plant detail -->
                        <div class="nav nav-pills nav-justified form-wizard-header mb-1 bg-primary text-white"
                            style="padding-left:2%; padding-top:1%; padding-bottom:1%;">
                            <div class="row">
                                <div class="media">
                                    <i class="uil uil-trees text-white font-weight-bold font-12 text-uppercase"></i> &nbsp;
                                    <div class="media-body">
                                        <h5 class="mt-1 font-14">
                                            Maklumat Hasil Tuaian
                                        </h5>
                                    </div>
                                </div>
                            </div> <!-- end row -->
                        </div>
                        <!-- end header plant detail -->
                        {{-- Gred A --}}
                        <div class="row">
                            <div class="col">
                                <label for="GredA" class="col-form-label">Gred A</label>
                                <div class="form-group row">
                                    <div class="col-sm-10">
                                        <input type="number" class="form-control"  id="grade_a_quantity" name="grade_a_quantity" placeholder="eg: 15 Tandan">
                                        </div>
                                    <label for="colFormLabel" class="col-sm-2 col-form-label">/Tandan</label>
                                   
                                </div>
                            </div>
                            <div class="col">
                                <label for="GredA" class="col-form-label">Kuantiti</label>
                                <div class="form-group row">
                                    <div class="col-sm-10">
                                        <input type="number" class="form-control" id="grade_a_weight" name="grade_a_weight" placeholder="eg: 50 Kg">
                                        </div>
                                    <label for="colFormLabel" class="col-sm-2 col-form-label">/KG</label>
                                </div>
                            </div>
                        </div>

                        {{-- Gred B --}}
                        <div class="row">
                            <div class="col">
                                <label for="GredB" class="col-form-label">Gred B</label>
                                <div class="form-group row">
                                    <div class="col-sm-10">
                                        <input type="number" class="form-control"  id="grade_b_quantity" name="grade_b_quantity" placeholder="eg: 15 Tandan">
                                        </div>
                                    <label for="colFormLabel" class="col-sm-2 col-form-label">/Tandan</label>
                                   
                                </div>
                            </div>
                            <div class="col">
                                <label for="GredB" class="col-form-label">Kuantiti</label>
                                <div class="form-group row">
                                    <div class="col-sm-10">
                                        <input type="number" class="form-control" id="grade_b_weight" name="grade_b_weight" placeholder="eg: 50 Kg">
                                        </div>
                                    <label for="colFormLabel" class="col-sm-2 col-form-label">/KG</label>
                                </div>
                            </div>
                        </div>

                        {{-- Gred C --}}
                        <div class="row">
                            <div class="col">
                                <label for="GredC" class="col-form-label">Gred C</label>
                                <div class="form-group row">
                                    <div class="col-sm-10">
                                        <input type="number" class="form-control"  id="grade_c_quantity" name="grade_c_quantity" placeholder="eg: 15 Tandan">
                                        </div>
                                    <label for="colFormLabel" class="col-sm-2 col-form-label">/Tandan</label>
                                   
                                </div>
                            </div>
                            <div class="col">
                                <label for="GredC" class="col-form-label">Kuantiti</label>
                                <div class="form-group row">
                                    <div class="col-sm-10">
                                        <input type="number" class="form-control" id="grade_c_weight" name="grade_c_weight" placeholder="eg: 50 Kg">
                                        </div>
                                    <label for="colFormLabel" class="col-sm-2 col-form-label">/KG</label>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col">
                                <label for="GredC" class="col-form-label">Gred Tolak</label>
                                <div class="form-group row">
                                    <div class="col-sm-10">
                                        <input type="number" class="form-control"  id="grade_reject_quantity" name="grade_reject_quantity" placeholder="eg: 15 Tandan">
                                        </div>
                                    <label for="colFormLabel" class="col-sm-2 col-form-label">/Tandan</label>
                                   
                                </div>
                            </div>
                            <div class="col">
                                <label for="GredC" class="col-form-label">Kuantiti</label>
                                <div class="form-group row">
                                    <div class="col-sm-10">
                                        <input type="number" class="form-control" id="grade_reject_weight" name="grade_reject_weight" placeholder="eg: 50 Kg">
                                        </div>
                                    <label for="colFormLabel" class="col-sm-2 col-form-label">/KG</label>
                                </div>
                            </div>
                        </div>
                                        
                        <div class="row justify-content-center align-items-center g-2">
                            <div class="form-group col-md-6">
                                <label for="TotalQuantity" class="col-form-label">Jumlah Keseluruhan (KG)</label>
                                <input type="number" class="form-control" id="total_weight" name="total_weight"
                                    placeholder="(kg)" readonly>
                            </div>
                        </div>
                        
                        <div class="text-center mt-2">
                            <button type="button" onclick="history.back()" class="btn btn-light mr-3">Batal</button>
                            <button type="submit" class="btn btn-primary">Simpan</button>
                        </div>
                    </form>
                </div> <!-- end card body-->
            </div> <!-- end card -->
        </div><!-- end col-->
    </div>
    <!-- end row-->
    <script>
        // Function to calculate total quantity
        function calculateTotalQuantity() {
            const gradeA = parseFloat(document.getElementById('grade_a_weight').value) || 0;
            const gradeB = parseFloat(document.getElementById('grade_b_weight').value) || 0;
            const gradeC = parseFloat(document.getElementById('grade_c_weight').value) || 0;
            const gradeD = parseFloat(document.getElementById('grade_reject_weight').value) || 0;

            // Calculate total
            const total = gradeA + gradeB + gradeC + gradeD;

            // Set total quantity value
            document.getElementById('total_weight').value = total; // Format to 2 decimal places
        }

        // Attach event listeners to grade input fields
        document.getElementById('grade_a_weight').addEventListener('input', calculateTotalQuantity);
        document.getElementById('grade_b_weight').addEventListener('input', calculateTotalQuantity);
        document.getElementById('grade_c_weight').addEventListener('input', calculateTotalQuantity);
        document.getElementById('grade_reject_weight').addEventListener('input', calculateTotalQuantity);
    </script>
@endsection
