@extends('layouts.base')

@section('content')
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <h4 class="page-title">Rekod Baja</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->

    {{-- <div class="row">
        <div class="col-12">
            <div class="card widget-inline">
                <div class="card-body p-0">
                    <div class="row no-gutters">
                        <div class="col">
                            <div class="card shadow-none m-0">
                                <div class="card-body text-center">
                                    <i class="dripicons-briefcase text-muted" style="font-size: 24px;"></i>
                                    <h3><span>29</span></h3>
                                    <p class="text-muted font-15 mb-0">Jumlah Baja</p>
                                </div>
                            </div>
                        </div>

                        <div class="col">
                            <div class="card shadow-none m-0 border-left">
                                <div class="card-body text-center">
                                    <i class="dripicons-checklist text-muted" style="font-size: 24px;"></i>
                                    <h3><span>715</span></h3>
                                    <p class="text-muted font-15 mb-0">Jenis Baja</p>
                                </div>
                            </div>
                        </div>
                    </div> <!-- end row -->
                </div>
            </div> <!-- end card-box-->
        </div> <!-- end col-->
    </div>
    <!-- end row--> --}}

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <h4 class="header-title">Quantiti Baja</h4>
                        <a href="{{ route('fertilizer.create') }}" class="btn btn-info btn-sm"
                            style="position: absolute; right:2%;">+Tambah Quantiti Baja</a>
                        <br><br>
                    </div>


                    <table id="basic-datatable" class="table dt-responsive nowrap w-100">
                        <thead>
                            <tr>
                                <th>Bil. </th>
                                <th>Nama</th>
                                <th>Pokok</th>
                                <th>Jenis Baja</th>
                                <th>Tindakan</th>
                            </tr>
                        </thead>


                        <tbody>
                            @foreach ($fertilizers as $fertilizer)
                                <tr>
                                    <td>{{ $loop->index + 1 }}.</td>
                                    <td>{{ $fertilizer->fertilizerDetail->fertilizer_name }}</td>
                                    <td>{{ $fertilizer->plantDetail->plant_type }}</td>
                                    <td>
                                        @if ($fertilizer->fertilizerDetail->fertilizerCategory->name == 'Tumbesaran')
                                            <span class="badge badge-secondary">Tumbesaran</span>
                                        @elseif ($fertilizer->fertilizerDetail->fertilizerCategory->name == 'Akar Pokok')
                                            <span class="badge badge-warning">Akar Pokok</span>
                                        @elseif ($fertilizer->fertilizerDetail->fertilizerCategory->name == 'Buah')
                                            <span class="badge badge-info">Buah</span>
                                        @elseif ($fertilizer->fertilizerDetail->fertilizerCategory->name == 'Matang')
                                            <span class="badge badge-primary">Matang</span>
                                        @endif
                                    </td>
                                    <td class="table-action">
                                        <a href="{{ route('fertilizer.show', $fertilizer) }}" class="action-icon"> <i
                                                class="mdi mdi-eye-check text-primary"></i></a>
                                        <a href="{{ route('fertilizer.edit', $fertilizer) }}" class="action-icon"> <i
                                                class="mdi mdi-file-document-edit text-info"></i></a>
                                        <a href="javascript: void(0);" class="action-icon" data-toggle="modal"
                                            data-target="#delete-modal-{{ $fertilizer->id }}"
                                            data-id="{{ $fertilizer->id }}"> <i class="mdi mdi-delete text-danger"></i></a>
                                    </td>
                                </tr>


                                <!-- Delete modal -->
                                <div id="delete-modal-{{ $fertilizer->id }}" class="modal fade" tabindex="-1"
                                    role="dialog" aria-hidden="true">
                                    <div class="modal-dialog ">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h4 class="modal-title" id="deleteModalLabel">Padam Maklumat Baja</h4>
                                                <button type="button" class="close" data-dismiss="modal"
                                                    aria-hidden="true">×</button>
                                            </div>
                                            <div class="modal-body">
                                                <p>Adakah anda mahu memadam maklumat ini?</p>
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-light btn-sm" data-dismiss="modal">
                                                    Tidak, Batal
                                                </button>
                                                <form method="POST"
                                                    action="{{ route('fertilizer.destroy', $fertilizer->id) }}">
                                                    @csrf
                                                    @method('DELETE')
                                                    <input type="hidden" name="fertilizer_id"
                                                        value="{{ $fertilizer->id }}">
                                                    <button type="submit" class="btn btn-danger btn-sm">Betul,
                                                        Padam</button>
                                                </form>
                                            </div>

                                        </div>
                                    </div>
                                </div><!-- /.modal -->
                            @endforeach
                        </tbody>
                    </table>
                </div> <!-- end card body-->
            </div> <!-- end card -->
        </div><!-- end col-->
    </div>
    <!-- end row-->
@endsection
