@extends('layouts.base')

@section('content')
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="javascript: void(0);">Baja & Racun</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('fertilizer.index') }}">Baja</a></li>
                        <li class="breadcrumb-item active">Kemaskini Baja</li>
                    </ol>
                </div>
                <h4 class="page-title">Pengurusan Baja</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif
                    <h4 class="header-title">Kemaskini Maklumat Baja</h4>
                    <br>
                    <div class="nav nav-pills nav-justified form-wizard-header mb-1 bg-info text-white"
                        style="padding-left:2%; padding-top:1%; padding-bottom:1%;">
                        <div class="row">
                            <!-- header plant detail -->
                            <div class="media">
                                <i class="uil uil-trees text-white font-weight-bold font-12 text-uppercase"></i> &nbsp;
                                <div class="media-body">
                                    <h5 class="mt-1 font-14">
                                        Maklumat Pokok
                                    </h5>
                                </div>
                            </div>
                            <!-- end header plant detail -->
                        </div> <!-- end row -->
                    </div>
                    <form action="{{ route('fertilizer.update', $fertilizers->id) }}" method="POST"
                        enctype="multipart/form-data">
                        @csrf
                        @method('PUT')
                        <div class="form-row">
                            <div class="form-group col-md-12">
                                <label for="inputState" class="col-form-label">Kategori Pokok</label>
                                <input type="text" name="plant_category" class="form-control"
                                    value="{{$fertilizers->plantDetail->category->name }}" readonly>
                            </div>
                            <div class="form-group col-md-6">
                                <label for="inputNamaPokok" class="col-form-label">Nama Pokok</label>
                                <input type="text" name="plant_type" class="form-control"
                                value="{{ $fertilizers->plantDetail->plant_type }}" readonly>
                            </div>
                            <div class="form-group col-md-6">
                                <label for="inputTempohKematangan" class="col-form-label">Tempoh Kematangan</label>
                                <input type="number" name="plant_maturity" class="form-control"
                                value="{{ $fertilizers->plantDetail->plant_maturity }}" readonly>
                            </div>
                        </div> <br>
                        <div class="nav nav-pills nav-justified form-wizard-header mb-1 bg-info text-white"
                            style="padding-left:2%; padding-top:1%; padding-bottom:1%;">
                            <div class="row">
                                <!-- header plant detail -->
                                <div class="media">
                                    <i class="uil uil-trees text-white font-weight-bold font-12 text-uppercase"></i>
                                    &nbsp;
                                    <div class="media-body">
                                        <h5 class="mt-1 font-14 ">
                                            Maklumat Baja
                                        </h5>
                                    </div>
                                </div>
                                <!-- end header plant detail -->
                            </div> <!-- end row -->
                        </div>
                        <!-- Initial Maklumat Baja section -->

                        <div class="form-row">
                            <div class="form-group col-md-6">
                                <label for="inputKategoriBaja" class="col-form-label">Kegunaan Baja</label>
                                <input type="text" name="fertilizer_type" class="form-control"
                                value="{{ $fertilizers->fertilizerDetail->fertilizerCategory->name}}" readonly>
                            </div>
                            <div class="form-group col-md-6">
                                <label for="inputNamaBaja" class="col-form-label">Nama Baja</label>
                                <input type="text" name="fertilizer_name" class="form-control"
                                value="{{ $fertilizers->fertilizerDetail->fertilizer_name}}" readonly>
                            </div>
                        </div>
                        <div class="form-row">
                            <div class="form-group col-md-6">
                                <label for="inputQuantitiBaja" class="col-form-label">Quantiti Baja</label>
                                <input type ="number" name="amount" class="form-control" id="inputQuantitiRacun"
                                value="{{ $fertilizers->amount }}" min="1" max="5000">
                            </div>
                            <div class="form-group col-md-6">
                                <label for="inputJenisKuantiti" class="col-form-label">Jenis Kuantiti</label>
                                <select id="amount_type" name="amount_type" class="form-control">
                                    <option value="">Sila Pilih</option>
                                    <option value="l/ha" {{ $fertilizers->amount_type == 'l/ha' ? 'selected' : '' }}>l/ha</option>
                                    <option value="ml/ha" {{ $fertilizers->amount_type == 'ml/ha' ? 'selected' : '' }}>ml/ha</option>
                                    <option value="kg/ha" {{ $fertilizers->amount_type == 'kg/ha' ? 'selected' : '' }}>kg/ha</option>
                                    <option value="g/ha" {{ $fertilizers->amount_type == 'g/ha' ? 'selected' : '' }}>g/ha</option>
                                </select>
                            </div>
                        </div>
                        <div class="form-row">
                            <div class="form-group col-md-6">
                                <label for="inputTempohMembaja" class="col-form-label">Tempoh Membaja</label>
                                <select id="duration" name="duration" class="form-control">
                                    <option value="">Sila Pilih</option>
                                    <option value="3 Bulan Pertama" {{ $fertilizers->duration == '3 Bulan Pertama' ? 'selected' : '' }}>3 Bulan Pertama</option>
                                    <option value="6 Bulan Pertama" {{ $fertilizers->duration == '6 Bulan Pertama' ? 'selected' : '' }}>6 Bulan Pertama</option>
                                    <option value="Setiap Bulan" {{ $fertilizers->duration == 'Setiap Bulan' ? 'selected' : '' }}>Setiap Bulan</option>
                                    <option value="Setahun Sekali" {{ $fertilizers->duration == 'Setahun Sekali' ? 'selected' : '' }}>Setahun Sekali</option>
                                </select>
                            </div>
                            <div class="form-group col-md-6">
                                <label for="inputKekerapanBaja" class="col-form-label">Kekerapan Baja</label>
                                <input type="number" name="frequency" class="form-control" id="inputKekerapanBaja" value="{{ $fertilizers->frequency }}">
                            </div>
                        </div>


                        <div class="text-center mt-2">
                            <button type="button" onclick="history.back()" class="btn btn-light mr-3">Batal</button>
                            <button type="submit" class="btn btn-info">Kemaskini</button>
                        </div>
                        <br>
                    </form>

                </div> <!-- end card body-->
            </div> <!-- end card -->
        </div><!-- end col-->
    </div>
@endsection
