<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable, SoftDeletes;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'email',
        'password',
        'role',
        'job_type',
        'address',
        'phone',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
        'password' => 'hashed',
    ];


    // Relationship for plantations where the user is the planter (penanam)
    public function plantationsAsPenanam()
    {
        return $this->hasMany(Plantation::class, 'penanam_id'); // A user can be a planter for many plantations
    }

    // Relationship for plantations where the user is the harvester (pengait)
    public function plantationsAsPengait()
    {
        return $this->hasMany(Plantation::class, 'pengait_id'); // A user can be a harvester for many plantations
    }

    public function plantations()
    {
        return $this->hasMany(Plantation::class);
    }


    public function damagesAsWorker()
    {
        return $this->hasMany(damage::class, 'worker_id'); // A user can be a harvester for many plantations
    }

    public function damages()
    {
        return $this->hasMany(Damage::class);
    }
}
