<?php

namespace App\Http\Controllers;

use App\Models\Fertilizer;
use App\Models\FertilizerDetail;
use App\Models\FertilizerCategory;
use App\Models\Category;
use App\Models\PlantDetail;
use Illuminate\Http\Request;

class FertilizerController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {

        $fertilizers = Fertilizer::with(['plantDetail' => function ($query) {
            $query->withTrashed();
        }, 'fertilizerDetail' => function ($query) {
            $query->withTrashed();
        }])->get();
        $categories = Category::all();
        return view('fertilizer.index', compact('fertilizers', 'categories'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request)
    {
        $categories = Category::all();
        $fertilizerCategories = FertilizerCategory::all(); 
        $plantDetails = PlantDetail::with('category')->get()->groupBy('category_id'); // Assuming you have a category_id in plant_details
        $fertilizerDetails = FertilizerDetail::with(['category', 'fertilizerCategory'])
            ->get()
            ->groupBy('category_id');
    
        // Fetch existing fertilizers for each plant
        $existingFertilizers = [];
        foreach ($plantDetails as $categoryId => $plants) {
            foreach ($plants as $plant) {
                $existingFertilizers[$plant->id] = Fertilizer::where('plant_detail_id', $plant->id)
                    ->pluck('fertilizer_detail_id')
                    ->toArray();
            }
        }
    
        return view('fertilizer.create', compact('plantDetails', 'categories', 'fertilizerDetails', 'fertilizerCategories', 'existingFertilizers'));
    }



    /**
     * Store a newly created resource in storage.
     *
     * @param  \App\Http\Requests\StoreFertilizerRequest  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        // Validate the request
        $request->validate([
            'plant_category' => 'required|exists:categories,id',
            'plant_type' => 'required|exists:plant_details,id',
            'fertilizer_name' => 'required|exists:fertilizer_details,id',
            'amount' => 'required|integer',
            'amount_type' => 'required|string',
            'duration' => 'required|string',
            'frequency' => 'required|integer',
        ]);
        $fertilizer = new Fertilizer();
        $fertilizer->plant_detail_id = $request->plant_type;
        $fertilizer->fertilizer_detail_id = $request->fertilizer_name;
        $fertilizer->amount = $request->amount;
        $fertilizer->amount_type = $request->amount_type;
        $fertilizer->duration = $request->duration;
        $fertilizer->frequency = $request->frequency;
        $fertilizer->save();


        return redirect()->route('fertilizer.index')->with('success', 'Maklumat Baja Berjaya Disimpan.');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Fertilizer  $fertilizer
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $fertilizers = Fertilizer::with(['plantDetail' => function ($query) {
            $query->withTrashed();
        }, 'fertilizerDetail' => function ($query) {
            $query->withTrashed();
        }])->findOrFail($id);
        $categories = Category::all();
        return view('fertilizer.show', compact('fertilizers', 'categories'));
    }


    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Fertilizer  $fertilizer
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $fertilizers = Fertilizer::with(['plantDetail' => function ($query) {
            $query->withTrashed();
        }, 'fertilizerDetail' => function ($query) {
            $query->withTrashed();
        }])->findOrFail($id);
        $categories = Category::all();
        return view('fertilizer.edit', compact('fertilizers', 'categories'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \App\Http\Requests\UpdateFertilizerRequest  $request
     * @param  \App\Models\Fertilizer  $fertilizer
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            'amount' => 'required|integer',
            'amount_type' => 'required|string',
            'duration' => 'required|string',
            'frequency' => 'required|integer',
            
        ]);

        // Find the existing fertilizer record by ID
        $fertilizer = Fertilizer::findOrFail($id);

        // Update the fields with the validated data
        $fertilizer->amount = $request->amount;
        $fertilizer->amount_type = $request->amount_type;
        $fertilizer->duration = $request->duration;
        $fertilizer->frequency = $request->frequency;


        // Save the updated fertilizer record
        $fertilizer->save();

        // Redirect back with a success message
        return redirect()->route('fertilizer.index')->with('success', 'Maklumat Baja Berjaya Dikemaskini.');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Fertilizer  $fertilizer
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $fertilizer = Fertilizer::findOrFail($id);
        $fertilizer->delete();

        return redirect()->route('fertilizer.index')->with('success', 'Maklumat Baja Berjaya Dipadam.');
    }
}
