@extends('layouts.base')

@section('content')
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <h4 class="page-title">Rekod</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->

    <div class="row">
        <div class="col-lg-6 col-xl-6">
            <div class="card widget-flat bg-info text-white">
                <div class="card-body">
                    <div class="float-right">
                        <i class=" mdi mdi-android-debug-bridge widget-icon bg-light text-info"></i>
                    </div>
                    <h5 class="text-uppercase mt-0" title="Growth">Jumlah Racun</h5>
                    <h3 class="mt-3 mb-3">{{ $totalPesticides }} Racun</h3>
                </div>
            </div>
        </div> <!-- end col-->

        <div class="col-lg-6 col-xl-6">
            <div class="card widget-flat bg-success text-white">
                <div class="card-body">
                    <div class="float-right">
                        <i class="mdi mdi-shield-bug widget-icon bg-light text-success"></i>
                    </div>
                    <h5 class="text-uppercase mt-0" title="Growth">Kategori Racun</h5>
                    <h3 class="mt-3 mb-3">{{ $totalPestCategories }} Kategori</h3>
                </div>
            </div>
        </div> <!-- end col-->
    </div>
    <!-- end row-->

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <h4 class="header-title">Racun</h4>
                        <a href="{{ route('pest-detail.create') }}" class="btn btn-info btn-sm"
                            style="position: absolute; right:2%;">+Tambah Racun</a>
                        <br><br>
                    </div>


                    <table id="basic-datatable" class="table dt-responsive nowrap w-100">
                        <thead>
                            <tr>
                                <th>Bil</th>
                                <th>Nama Racun</th>
                                <th>Kegunaan</th>
                                <th>Papar Gambar</th>
                                <th>Tindakan</th>
                            </tr>
                        </thead>


                        <tbody>
                            @foreach ($pestDetail as $pest)
                                <tr>
                                    <td>{{ $loop->index + 1 }}.</td>
                                    <td>{{ $pest->pest_name }}</td>
                                    <td>
                                        @if ($pest->pestCategory->name == 'Kumbang Perosak')
                                            <span class="badge badge-warning">Kumbang Perosak</span>
                                        @elseif($pest->pestCategory->name == 'Ulat Gulong')
                                            <span class="badge badge-primary">Ulat Gulong</span>
                                        @elseif($pest->pestCategory->name == 'Lalat Buah')
                                            <span class="badge badge-info">Lalat Buah</span>
                                        @elseif($pest->pestCategory->name == 'Penggorek Batang Pisang')
                                            <span class="badge badge-secondary">Penggorek Batang Pisang</span>
                                        @elseif($pest->pestCategory->name == 'Nematod')
                                            <span class="badge badge-light">Nematod</span>
                                        @endif
                                    </td>
                                    <td><a href="{{ Storage::url($pest->image) }}" target="_blank">Lihat Racun</a></td>
                                    <td class="table-action">
                                        <a href="javascript: void(0);" class="action-icon text-info" data-toggle="modal"
                                            data-target="#edit-modal-{{ $pest->id }}"> <i
                                                class="mdi mdi-file-document-edit"></i></a>
                                        <a href="javascript: void(0);" class="action-icon text-danger" data-toggle="modal"
                                            data-target="#delete-modal" data-id="{{ $pest->id }}"> <i
                                                class="mdi mdi-delete"></i></a>
                                    </td>
                                </tr>


                                <!-- Edit modal -->
                                <div id="edit-modal-{{ $pest->id }}" class="modal fade" tabindex="-1" role="dialog"
                                    aria-hidden="true">
                                    <div class="modal-dialog ">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h4 class="modal-title" id="editModalLabel">Kemaskini Maklumat Racun
                                                </h4>
                                                <button type="button" class="close" data-dismiss="modal"
                                                    aria-hidden="true">×</button>
                                            </div>
                                            <div class="modal-body">
                                                <form action="{{ route('pest-detail.update', $pest->id) }}" method="POST"
                                                    enctype="multipart/form-data">
                                                    @csrf
                                                    @method('PUT')
                                                    <div class="form-row">
                                                        <div class="form-group col-md-12">
                                                            <label for="inputState" class="col-form-label">Kategori
                                                                Pokok</label>
                                                            <select id="plant_category" name="plant_category"
                                                                class="form-control">
                                                                @foreach ($categories as $category)
                                                                    <option value="{{ $category->id }}"
                                                                        {{ $category->id == $pest->category->id ? 'selected' : '' }}>
                                                                        {{ $category->name }}
                                                                    </option>
                                                                @endforeach
                                                            </select>
                                                        </div>
                                                    </div>

                                                    <div class="form-row">
                                                        <div class="form-group col-md-6">
                                                            <label for="pest_type" class="col-form-label">Kegunaan
                                                                Racun</label>
                                                            <select id="pest_category" name="pest_category"
                                                                class="form-control">
                                                                @foreach ($pest_categories as $pest_category)
                                                                    <option value="{{ $pest_category->id }}"
                                                                        {{ $pest_category->id == $pest->pestCategory->id ? 'selected' : '' }}>
                                                                        {{ $pest_category->name }}
                                                                    </option>
                                                                @endforeach
                                                            </select>
                                                        </div>

                                                        <div class="form-group col-md-6">
                                                            <label for="inputEmail4" class="col-form-label">Nama
                                                                Racun</label>
                                                            <input type="text" name="pest_name" class="form-control"
                                                                value="{{ $pest->pest_name }}">
                                                        </div>

                                                        <div class="form-group  col-md-12 ">
                                                            <label for="iamge"> Kemaskini Gambar (Pilihan)</label>
                                                            <input type="file" name="image" class="form-control">
                                                            <small class="form-text text-muted">Biarkan kosong jika anda
                                                                tidak mahu menukar.</small>
                                                        </div>

                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-light"
                                                            data-dismiss="modal">Batal</button>
                                                        <button type="submit" class="btn btn-info">Kemaskini</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div><!-- /.modal-content -->
                                    </div><!-- /.modal-dialog -->
                                </div><!-- /.modal -->


                                <!-- Delete modal -->
                                <div id="delete-modal" class="modal fade" tabindex="-1" role="dialog"
                                    aria-hidden="true">
                                    <div class="modal-dialog ">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h4 class="modal-title" id="deleteModalLabel">Padam Maklumat Racun
                                                </h4>
                                                <button type="button" class="close" data-dismiss="modal"
                                                    aria-hidden="true">×</button>
                                            </div>
                                            <div class="modal-body">
                                                <p>Adakah anda mahu memadam maklumat ini?</p>
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-light btn-sm" data-dismiss="modal">
                                                    Tidak, Batal
                                                </button>
                                                <form method="POST"
                                                    action="{{ route('pest-detail.destroy', $pest->id) }}">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-danger btn-sm">Betul,
                                                        Padam</button>
                                                </form>
                                            </div>

                                        </div>
                                    </div>
                                </div><!-- /.modal -->
                            @endforeach
                        </tbody>
                    </table>
                </div> <!-- end card body-->
            </div> <!-- end card -->
        </div><!-- end col-->
    </div>
    <!-- end row-->
@endsection
