

<?php $__env->startSection('content'); ?>
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <h4 class="page-title">Rekod</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->

    <div class="row">
        <div class="col-12">
            <div class="card widget-inline">
                <div class="card-body p-0">
                    <div class="row no-gutters">
                        <div class="col">
                            <div class="card shadow-none m-0">
                                <div class="card-body bg-secondary text-center">
                                    <i class="dripicons-briefcase text-white" style="font-size: 24px;"></i>
                                    <h3 class="text-white"><span><?php echo e($totalCustomer); ?></span></h3>
                                    <p class="text-white font-15 mb-0">Jumlah Pelanggan</p>
                                </div>
                            </div>
                        </div>
                    </div> <!-- end row -->
                </div>
            </div> <!-- end card-box-->
        </div> <!-- end col-->
    </div>
    <!-- end row-->

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <h4 class="header-title">Pelanggan</h4>
                        <a href="<?php echo e(route('customer.create')); ?>" class="btn btn-info btn-sm"
                            style="position: absolute; right:2%;">+Tambah Pelanggan</a>
                        <br><br>
                    </div>


                    <table id="basic-datatable" class="table dt-responsive nowrap w-100">
                        <thead>
                            <tr>
                                <th>Bil</th>
                                <th>Nama Syarikat</th>
                                <th>Nama</th>
                                <th>Nombor Telefon</th>
                                <th>Tindakan</th>
                            </tr>
                        </thead>


                        <tbody>
                            <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($loop->index + 1); ?>.</td>
                                    <td><?php echo e($customer->company_name); ?></td>
                                    <td><?php echo e($customer->customer_name); ?></td>
                                    <td><?php echo e($customer->phone_number); ?></td>
                                    <td class="table-action">

                                        <a href="<?php echo e(route('customer.show', $customer)); ?>" class="action-icon"><i
                                            class="mdi mdi-eye-check text-primary"></i></a>
                                        <a href="<?php echo e(route('customer.edit', $customer)); ?>" class="action-icon"> <i
                                                class="mdi mdi-file-document-edit text-info"></i></a>
                                        <a href="javascript: void(0);" class="action-icon" data-toggle="modal"
                                            data-target="#delete-modal" data-id="<?php echo e($customer->id); ?>"> <i
                                                class="mdi mdi-delete text-danger"></i></a>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            <!-- Delete modal -->
                            <div id="delete-modal" class="modal fade" tabindex="-1" role="dialog" aria-hidden="true">
                                <div class="modal-dialog ">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h4 class="modal-title" id="deleteModalLabel">Padam Maklumat Pelanggan
                                            </h4>
                                            <button type="button" class="close" data-dismiss="modal"
                                                aria-hidden="true">×</button>
                                        </div>
                                        <div class="modal-body">
                                            <p>Adakah anda mahu memadam maklumat ini?</p>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-light btn-sm" data-dismiss="modal">
                                                Tidak, Batal
                                            </button>
                                            <form method="POST" action="<?php echo e(route('customer.destroy', $customer->id)); ?>" >
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <button type="submit" class="btn btn-danger btn-sm">Betul,
                                                    Padam</button>
                                            </form>
                                        </div>

                                    </div>
                                </div>
                            </div><!-- /.modal -->
                        </tbody>
                    </table>
                </div> <!-- end card body-->
            </div> <!-- end card -->
        </div><!-- end col-->
    </div>
    <!-- end row-->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\desa-grow-farm\resources\views/customer/index.blade.php ENDPATH**/ ?>