<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class FertilizerDetail extends Model
{
    use HasFactory,SoftDeletes;

    protected $fillable = [
        'category_id',
        'fertilizer_category_id',
        'fertilizer_name',
        'fertilizer_type',
        'image',
    ];

    protected $dates = ['deleted_at'];

    public function category()
    {
        return $this->belongsTo(Category::class);
    }

    public function fertilizerCategory()
    {
        return $this->belongsTo(FertilizerCategory::class);
    }
}
