<div>
    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8 space-y-6">

            <!-- Quick Stats Cards -->
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
                <!-- Course Verification Status Card -->
                <div class="bg-white dark:bg-gray-800 rounded-lg shadow-md p-6">
                    <div class="flex items-center justify-between">
                        <div class="flex items-center">
                            <div class="p-3 rounded-full bg-blue-100 dark:bg-blue-900">
                                <i class="fa fa-file-alt text-blue-600 dark:text-blue-400 text-xl"></i>
                            </div>
                            <div class="ml-4">
                                <p class="text-sm font-medium text-gray-600 dark:text-gray-400">Course Verification</p>
                                <div class="flex items-center space-x-2 mt-1">
                                    <span class="text-xs text-yellow-600 dark:text-yellow-400">
                                        Pending: <?php echo e($stats['courseVerification']['pending']); ?>

                                    </span>
                                    <span class="text-xs text-green-600 dark:text-green-400">
                                        Approved: <?php echo e($stats['courseVerification']['approved']); ?>

                                    </span>
                                    <?php if($stats['courseVerification']['rejected'] > 0): ?>
                                        <span class="text-xs text-red-600 dark:text-red-400">
                                            Rejected: <?php echo e($stats['courseVerification']['rejected']); ?>

                                        </span>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Placement Applications Card -->
                <div class="bg-white dark:bg-gray-800 rounded-lg shadow-md p-6">
                    <div class="flex items-center justify-between">
                        <div class="flex items-center">
                            <div class="p-3 rounded-full bg-purple-100 dark:bg-purple-900">
                                <i class="fa fa-briefcase text-purple-600 dark:text-purple-400 text-xl"></i>
                            </div>
                            <div class="ml-4">
                                <p class="text-sm font-medium text-gray-600 dark:text-gray-400">Placement Applications</p>
                                <div class="flex items-center space-x-2 mt-1">
                                    <span class="text-xs text-gray-700 dark:text-gray-300 font-semibold">
                                        Total: <?php echo e($placementApplicationStats['total']); ?>

                                    </span>
                                    <span class="text-xs text-yellow-600 dark:text-yellow-400">
                                        Pending: <?php echo e($placementApplicationStats['pending']); ?>

                                    </span>
                                    <span class="text-xs text-green-600 dark:text-green-400">
                                        Accepted: <?php echo e($placementApplicationStats['accepted']); ?>

                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Defer Requests Card -->
                <div class="bg-white dark:bg-gray-800 rounded-lg shadow-md p-6">
                    <div class="flex items-center justify-between">
                        <div class="flex items-center">
                            <div class="p-3 rounded-full bg-orange-100 dark:bg-orange-900">
                                <i class="fa fa-calendar-times text-orange-600 dark:text-orange-400 text-xl"></i>
                            </div>
                            <div class="ml-4">
                                <p class="text-sm font-medium text-gray-600 dark:text-gray-400">Defer Requests</p>
                                <div class="flex items-center space-x-2 mt-1">
                                    <span class="text-xs text-yellow-600 dark:text-yellow-400">
                                        Pending: <?php echo e($deferRequestStats['pending']); ?>

                                    </span>
                                    <span class="text-xs text-green-600 dark:text-green-400">
                                        Approved: <?php echo e($deferRequestStats['approved']); ?>

                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Change Requests Card -->
                <div class="bg-white dark:bg-gray-800 rounded-lg shadow-md p-6">
                    <div class="flex items-center justify-between">
                        <div class="flex items-center">
                            <div class="p-3 rounded-full bg-red-100 dark:bg-red-900">
                                <i class="fa fa-exchange-alt text-red-600 dark:text-red-400 text-xl"></i>
                            </div>
                            <div class="ml-4">
                                <p class="text-sm font-medium text-gray-600 dark:text-gray-400">Change Requests</p>
                                <div class="flex items-center space-x-2 mt-1">
                                    <span class="text-xs text-yellow-600 dark:text-yellow-400">
                                        Pending: <?php echo e($changeRequestStats['pending']); ?>

                                    </span>
                                    <span class="text-xs text-green-600 dark:text-green-400">
                                        Approved: <?php echo e($changeRequestStats['approved']); ?>

                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Main Content Grid -->
            <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
                <!-- Left Column: Current Status Overview -->
                <div class="lg:col-span-2 space-y-6">
                    <!-- Current Status Overview -->
                    <div class="bg-white dark:bg-gray-800 rounded-lg shadow-md p-6">
                        <h3 class="text-lg font-semibold text-gray-900 dark:text-gray-100 mb-4">Current Status Overview</h3>

                        <div class="space-y-4">
                            <!-- Course Verification Status -->
                            <div class="border-l-4 <?php echo e($latestCourseVerification ? ($latestCourseVerification->status === 'approved' ? 'border-green-500' : ($latestCourseVerification->status === 'pending' ? 'border-yellow-500' : 'border-red-500')) : 'border-gray-300'); ?> pl-4 py-2">
                                <div class="flex items-center justify-between">
                                    <div>
                                        <h4 class="font-medium text-gray-900 dark:text-gray-100">Course Verification</h4>
                                        <p class="text-sm text-gray-600 dark:text-gray-400">
                                            <?php if($latestCourseVerification): ?>
                                                Status: <span class="font-semibold capitalize"><?php echo e($latestCourseVerification->status); ?></span>
                                                <?php if($latestCourseVerification->remarks): ?>
                                                    <br>Remarks: <?php echo e(\Illuminate\Support\Str::limit($latestCourseVerification->remarks, 50)); ?>

                                                <?php endif; ?>
                                            <?php else: ?>
                                                No verification submitted yet
                                            <?php endif; ?>
                                        </p>
                                    </div>
                                    <a href="<?php echo e(route('student.courseVerification')); ?>"
                                       class="inline-flex items-center gap-1.5 px-3 py-1.5 text-xs font-medium text-white bg-purple-600 hover:bg-purple-700 dark:bg-purple-600 dark:hover:bg-purple-700 rounded-lg transition-colors shadow-sm hover:shadow-md">
                                        <span>View Details</span>
                                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" class="h-3 w-3">
                                            <path stroke-linecap="round" stroke-linejoin="round" d="M13.5 4.5L21 12m0 0l-7.5 7.5M21 12H3" />
                                        </svg>
                                    </a>
                                </div>
                            </div>

                            <!-- Placement Application Status -->
                            <div class="border-l-4 <?php echo e($latestPlacementApplication ? ($latestPlacementApplication->overall_status === 'Approved' ? 'border-green-500' : ($latestPlacementApplication->overall_status === 'Pending' ? 'border-yellow-500' : 'border-red-500')) : 'border-gray-300'); ?> pl-4 py-2">
                                <div class="flex items-center justify-between">
                                    <div>
                                        <h4 class="font-medium text-gray-900 dark:text-gray-100">Placement Application</h4>
                                        <p class="text-sm text-gray-600 dark:text-gray-400">
                                            <?php if($latestPlacementApplication): ?>
                                                Company: <span class="font-semibold"><?php echo e($latestPlacementApplication->companyName); ?></span>
                                                <br>Status: <span class="font-semibold"><?php echo e($latestPlacementApplication->overall_status); ?></span>
                                                <?php if($latestPlacementApplication->studentAcceptance): ?>
                                                    <br>Your Response: <span class="font-semibold capitalize"><?php echo e($latestPlacementApplication->studentAcceptance); ?></span>
                                                <?php endif; ?>
                                            <?php else: ?>
                                                No application submitted yet
                                            <?php endif; ?>
                                        </p>
                                    </div>
                                    <a href="<?php echo e(route('student.placementApplications')); ?>"
                                       class="inline-flex items-center gap-1.5 px-3 py-1.5 text-xs font-medium text-white bg-purple-600 hover:bg-purple-700 dark:bg-purple-600 dark:hover:bg-purple-700 rounded-lg transition-colors shadow-sm hover:shadow-md">
                                        <span>View Details</span>
                                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" class="h-3 w-3">
                                            <path stroke-linecap="round" stroke-linejoin="round" d="M13.5 4.5L21 12m0 0l-7.5 7.5M21 12H3" />
                                        </svg>
                                    </a>
                                </div>
                            </div>

                            <!-- Academic Advisor Info -->
                            <div class="border-l-4 <?php echo e($academicAdvisor ? 'border-blue-500' : 'border-gray-300'); ?> pl-4 py-2">
                                <div class="flex items-center justify-between">
                                    <div>
                                        <h4 class="font-medium text-gray-900 dark:text-gray-100">Academic Advisor</h4>
                                        <p class="text-sm text-gray-600 dark:text-gray-400">
                                            <?php if($academicAdvisor && $academicAdvisor->user): ?>
                                                Advisor: <span class="font-semibold"><?php echo e($academicAdvisor->user->name); ?></span>
                                                <?php if($academicAdvisor->user->email): ?>
                                                    <br>Email: <?php echo e($academicAdvisor->user->email); ?>

                                                <?php endif; ?>
                                            <?php else: ?>
                                                No academic advisor assigned
                                            <?php endif; ?>
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Progress Timeline -->
                    <div class="bg-white dark:bg-gray-800 rounded-lg shadow-md p-6">
                        <h3 class="text-lg font-semibold text-gray-900 dark:text-gray-100 mb-4">Progress Timeline</h3>

                        <div class="relative">
                            <!-- Timeline Line -->
                            <div class="absolute left-4 top-0 bottom-0 w-0.5 bg-gray-300 dark:bg-gray-600"></div>

                            <div class="space-y-6">
                                <!-- Step 1: Course Verification -->
                                <div class="relative flex items-start">
                                    <div class="flex-shrink-0 w-8 h-8 rounded-full flex items-center justify-center <?php echo e($latestCourseVerification && $latestCourseVerification->status === 'approved' ? 'bg-green-500' : ($latestCourseVerification && $latestCourseVerification->status === 'pending' ? 'bg-yellow-500' : 'bg-gray-300 dark:bg-gray-600')); ?>">
                                        <?php if($latestCourseVerification && $latestCourseVerification->status === 'approved'): ?>
                                            <i class="fa fa-check text-white text-sm"></i>
                                        <?php elseif($latestCourseVerification && $latestCourseVerification->status === 'pending'): ?>
                                            <i class="fa fa-clock text-white text-sm"></i>
                                        <?php else: ?>
                                            <i class="fa fa-circle text-white text-xs"></i>
                                        <?php endif; ?>
                                    </div>
                                    <div class="ml-6 flex-1">
                                        <h4 class="font-medium text-gray-900 dark:text-gray-100">Course Verification</h4>
                                        <p class="text-sm text-gray-600 dark:text-gray-400">
                                            <?php if($latestCourseVerification): ?>
                                                <?php echo e(ucfirst($latestCourseVerification->status)); ?>

                                                <?php if($latestCourseVerification->status === 'approved'): ?>
                                                    - Ready for placement applications
                                                <?php endif; ?>
                                            <?php else: ?>
                                                Not started
                                            <?php endif; ?>
                                        </p>
                                    </div>
                                </div>

                                <!-- Step 2: Placement Application -->
                                <div class="relative flex items-start">
                                    <div class="flex-shrink-0 w-8 h-8 rounded-full flex items-center justify-center <?php echo e($latestPlacementApplication && $latestPlacementApplication->overall_status === 'Approved' ? 'bg-green-500' : ($latestPlacementApplication && $latestPlacementApplication->overall_status === 'Pending' ? 'bg-yellow-500' : 'bg-gray-300 dark:bg-gray-600')); ?>">
                                        <?php if($latestPlacementApplication && $latestPlacementApplication->overall_status === 'Approved'): ?>
                                            <i class="fa fa-check text-white text-sm"></i>
                                        <?php elseif($latestPlacementApplication && $latestPlacementApplication->overall_status === 'Pending'): ?>
                                            <i class="fa fa-clock text-white text-sm"></i>
                                        <?php else: ?>
                                            <i class="fa fa-circle text-white text-xs"></i>
                                        <?php endif; ?>
                                    </div>
                                    <div class="ml-6 flex-1">
                                        <h4 class="font-medium text-gray-900 dark:text-gray-100">Placement Application</h4>
                                        <p class="text-sm text-gray-600 dark:text-gray-400">
                                            <?php if($latestPlacementApplication): ?>
                                                <?php echo e($latestPlacementApplication->overall_status); ?>

                                                <?php if($latestPlacementApplication->overall_status === 'Approved' && $latestPlacementApplication->studentAcceptance === 'Accepted'): ?>
                                                    - Ready for supervisor assignment
                                                <?php endif; ?>
                                            <?php else: ?>
                                                Not started
                                            <?php endif; ?>
                                        </p>
                                    </div>
                                </div>

                                <!-- Step 3: Supervisor Assignment -->
                                <div class="relative flex items-start">
                                    <div class="flex-shrink-0 w-8 h-8 rounded-full flex items-center justify-center <?php echo e($supervisorAssignment ? 'bg-green-500' : 'bg-gray-300 dark:bg-gray-600'); ?>">
                                        <?php if($supervisorAssignment): ?>
                                            <i class="fa fa-check text-white text-sm"></i>
                                        <?php else: ?>
                                            <i class="fa fa-circle text-white text-xs"></i>
                                        <?php endif; ?>
                                    </div>
                                    <div class="ml-6 flex-1">
                                        <h4 class="font-medium text-gray-900 dark:text-gray-100">Assigned Supervisor</h4>
                                        <p class="text-sm text-gray-600 dark:text-gray-400">
                                            <?php if($supervisorAssignment): ?>
                                                Assigned - <?php echo e($supervisorAssignment->supervisor->user->name ?? 'N/A'); ?>

                                            <?php else: ?>
                                                Pending assignment
                                            <?php endif; ?>
                                        </p>
                                    </div>
                                </div>

                                <!-- Step 4: Internship -->
                                <div class="relative flex items-start">
                                    <div class="flex-shrink-0 w-8 h-8 rounded-full flex items-center justify-center <?php echo e($supervisorAssignment && $latestPlacementApplication && $latestPlacementApplication->studentAcceptance === 'Accepted' ? 'bg-green-500' : 'bg-gray-300 dark:bg-gray-600'); ?>">
                                        <?php if($supervisorAssignment && $latestPlacementApplication && $latestPlacementApplication->studentAcceptance === 'Accepted'): ?>
                                            <i class="fa fa-check text-white text-sm"></i>
                                        <?php else: ?>
                                            <i class="fa fa-circle text-white text-xs"></i>
                                        <?php endif; ?>
                                    </div>
                                    <div class="ml-6 flex-1">
                                        <h4 class="font-medium text-gray-900 dark:text-gray-100">Internship</h4>
                                        <p class="text-sm text-gray-600 dark:text-gray-400">
                                            <?php if($supervisorAssignment && $latestPlacementApplication && $latestPlacementApplication->studentAcceptance === 'Accepted'): ?>
                                                Ready to begin
                                            <?php else: ?>
                                                Not ready
                                            <?php endif; ?>
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Right Column: Recent Activity -->
                <div class="space-y-6">
                    <!-- Recent Activity/Notifications -->
                    <div class="bg-white dark:bg-gray-800 rounded-lg shadow-md p-6">
                        <h3 class="text-lg font-semibold text-gray-900 dark:text-gray-100 mb-4">Recent Activity</h3>

                        <?php if($recentActivities->isEmpty()): ?>
                            <p class="text-sm text-gray-500 dark:text-gray-400 text-center py-4">
                                No recent activity
                            </p>
                        <?php else: ?>
                            <div class="space-y-4">
                                <?php $__currentLoopData = $recentActivities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $activity): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="border-l-4 <?php echo e($activity['status'] === 'approved' || $activity['status'] === 'Approved' ? 'border-green-500' : ($activity['status'] === 'pending' || $activity['status'] === 'Pending' ? 'border-yellow-500' : 'border-red-500')); ?> pl-4 py-2">
                                        <h4 class="font-medium text-sm text-gray-900 dark:text-gray-100">
                                            <?php echo e($activity['title']); ?>

                                        </h4>
                                        <p class="text-xs text-gray-600 dark:text-gray-400 mt-1">
                                            <?php echo e($activity['description']); ?>

                                        </p>
                                        <p class="text-xs text-gray-500 dark:text-gray-500 mt-1">
                                            <?php echo e($activity['date']->diffForHumans()); ?>

                                        </p>
                                        <?php if($activity['link']): ?>
                                            <a href="<?php echo e($activity['link']); ?>"
                                               class="inline-flex items-center gap-1.5 px-2.5 py-1 text-xs font-medium text-white bg-purple-600 hover:bg-purple-700 dark:bg-purple-600 dark:hover:bg-purple-700 rounded-lg transition-colors shadow-sm hover:shadow-md mt-2">
                                                <span>View</span>
                                                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" class="h-3 w-3">
                                                    <path stroke-linecap="round" stroke-linejoin="round" d="M13.5 4.5L21 12m0 0l-7.5 7.5M21 12H3" />
                                                </svg>
                                            </a>
                                        <?php endif; ?>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        <?php endif; ?>
                    </div>

                    <!-- Supervisor Assignment -->
                    <div class="bg-white dark:bg-gray-800 rounded-lg shadow-md p-6">
                        <h3 class="text-lg font-semibold text-gray-900 dark:text-gray-100 mb-4">Assigned Supervisor</h3>

                        <?php if($supervisorAssignment && $supervisorAssignment->supervisor): ?>
                            <div class="space-y-3">
                                <div>
                                    <p class="text-sm font-medium text-gray-600 dark:text-gray-400">Supervisor Name</p>
                                    <p class="text-base font-semibold text-gray-900 dark:text-gray-100">
                                        <?php echo e($supervisorAssignment->supervisor->user->name); ?>

                                    </p>
                                </div>

                                <?php if($supervisorAssignment->supervisor->lecturerID): ?>
                                    <div>
                                        <p class="text-sm font-medium text-gray-600 dark:text-gray-400">Lecturer ID</p>
                                        <p class="text-sm text-gray-900 dark:text-gray-100">
                                            <?php echo e($supervisorAssignment->supervisor->lecturerID); ?>

                                        </p>
                                    </div>
                                <?php endif; ?>

                                <?php if($supervisorAssignment->supervisor->user->email): ?>
                                    <div>
                                        <p class="text-sm font-medium text-gray-600 dark:text-gray-400">Email</p>
                                        <a href="mailto:<?php echo e($supervisorAssignment->supervisor->user->email); ?>"
                                           class="text-sm text-blue-600 dark:text-blue-400 hover:underline">
                                            <?php echo e($supervisorAssignment->supervisor->user->email); ?>

                                        </a>
                                    </div>
                                <?php endif; ?>

                                <?php if($supervisorAssignment->assignment_notes): ?>
                                    <div>
                                        <p class="text-sm font-medium text-gray-600 dark:text-gray-400">Assignment Notes</p>
                                        <p class="text-sm text-gray-900 dark:text-gray-100">
                                            <?php echo e($supervisorAssignment->assignment_notes); ?>

                                        </p>
                                    </div>
                                <?php endif; ?>

                                <?php if($supervisorAssignment->assigned_at): ?>
                                    <div>
                                        <p class="text-sm font-medium text-gray-600 dark:text-gray-400">Assigned Date</p>
                                        <p class="text-sm text-gray-900 dark:text-gray-100">
                                            <?php echo e($supervisorAssignment->assigned_at->format('M d, Y')); ?>

                                        </p>
                                    </div>
                                <?php endif; ?>
                            </div>
                        <?php else: ?>
                            <p class="text-sm text-gray-500 dark:text-gray-400 text-center py-4">
                                No supervisor assigned yet
                            </p>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div><?php /**PATH C:\Users\User\Desktop\Laravel\Internlink\resources\views\livewire\student-dashboard.blade.php ENDPATH**/ ?>