<div>
    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <!-- Flash Messages -->
            <?php if(session()->has('message')): ?>
                <div class="bg-green-50 border border-green-200 rounded-lg p-4 mb-6">
                    <p class="text-green-700"><?php echo e(session('message')); ?></p>
                </div>
            <?php endif; ?>

            <?php if(session()->has('error')): ?>
                <div class="bg-red-50 border border-red-200 rounded-lg p-4 mb-6">
                    <p class="text-red-700"><?php echo e(session('error')); ?></p>
                </div>
            <?php endif; ?>

    <!-- Analytics Dashboard -->
    <?php if($analytics): ?>
        <div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-8">
            <div class="bg-white rounded-lg shadow p-6">
                <div class="flex items-center">
                    <div class="p-3 rounded-full bg-blue-100">
                        <span class="text-blue-600 text-xl">📊</span>
                    </div>
                    <div class="ml-4">
                        <p class="text-sm font-medium text-gray-600">Total Requests</p>
                        <p class="text-2xl font-bold text-gray-900"><?php echo e($analytics['total']); ?></p>
                    </div>
                </div>
            </div>

            <div class="bg-white rounded-lg shadow p-6">
                <div class="flex items-center">
                    <div class="p-3 rounded-full bg-yellow-100">
                        <span class="text-yellow-600 text-xl">⏳</span>
                    </div>
                    <div class="ml-4">
                        <p class="text-sm font-medium text-gray-600">Pending Review</p>
                        <p class="text-2xl font-bold text-gray-900"><?php echo e($analytics['pending']); ?></p>
                    </div>
                </div>
            </div>

            <div class="bg-white rounded-lg shadow p-6">
                <div class="flex items-center">
                    <div class="p-3 rounded-full bg-green-100">
                        <span class="text-green-600 text-xl">✅</span>
                    </div>
                    <div class="ml-4">
                        <p class="text-sm font-medium text-gray-600">Approved</p>
                        <p class="text-2xl font-bold text-gray-900"><?php echo e($analytics['approved']); ?></p>
                    </div>
                </div>
            </div>

            <div class="bg-white rounded-lg shadow p-6">
                <div class="flex items-center">
                    <div class="p-3 rounded-full bg-red-100">
                        <span class="text-red-600 text-xl">❌</span>
                    </div>
                    <div class="ml-4">
                        <p class="text-sm font-medium text-gray-600">Rejected</p>
                        <p class="text-2xl font-bold text-gray-900"><?php echo e($analytics['rejected']); ?></p>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <!-- Main Content Card -->
    <div class="bg-white shadow rounded-lg">
        <!-- Header -->
        <div class="px-6 py-4 border-b border-gray-200">
            <div class="flex items-center justify-between">
                <h2 class="text-lg font-medium text-gray-900">My Change Requests</h2>
            </div>
        </div>

        <!-- Filters -->
        <div class="px-6 py-4 border-b border-gray-200 bg-gray-50">
            <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
                <!-- Search -->
                <div class="md:col-span-2">
                    <input type="text" wire:model.live.debounce.300ms="search"
                        class="w-full border border-gray-300 rounded-md px-3 py-2 text-sm"
                        placeholder="Search requests...">
                </div>

                <!-- Status Filter -->
                <div>
                    <select wire:model.live="statusFilter"
                        class="w-full border border-gray-300 rounded-md px-3 py-2 text-sm">
                        <option value="">All Status</option>
                        <option value="Pending">Pending</option>
                        <option value="Approved">Approved</option>
                        <option value="Rejected">Rejected</option>
                    </select>
                </div>

                <!-- Per Page -->
                <div>
                    <select wire:model.live="perPage"
                        class="w-full border border-gray-300 rounded-md px-3 py-2 text-sm">
                        <option value="10">10 per page</option>
                        <option value="25">25 per page</option>
                        <option value="50">50 per page</option>
                    </select>
                </div>
            </div>
        </div>

        <!-- Change Requests Table -->
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            <button wire:click="sortBy('justificationID')"
                                class="flex items-center space-x-1 hover:text-gray-700">
                                <span>ID</span>
                                <span><?php echo e($sortField === 'justificationID' ? ($sortDirection === 'asc' ? '↑' : '↓') : '↕'); ?></span>
                            </button>
                        </th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            <button wire:click="sortBy('applicationID')"
                                class="flex items-center space-x-1 hover:text-gray-700">
                                <span>APPLICATION</span>
                                <span><?php echo e($sortField === 'applicationID' ? ($sortDirection === 'asc' ? '↑' : '↓') : '↕'); ?></span>
                            </button>
                        </th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            <button wire:click="sortBy('companyName')"
                                class="flex items-center space-x-1 hover:text-gray-700">
                                <span>COMPANY & POSITION</span>
                                <span><?php echo e($sortField === 'companyName' ? ($sortDirection === 'asc' ? '↑' : '↓') : '↕'); ?></span>
                            </button>
                        </th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            REASON
                        </th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            <button wire:click="sortBy('requestDate')"
                                class="flex items-center space-x-1 hover:text-gray-700">
                                <span>REQUEST DATE</span>
                                <span><?php echo e($sortField === 'requestDate' ? ($sortDirection === 'asc' ? '↑' : '↓') : '↕'); ?></span>
                            </button>
                        </th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            STATUS
                        </th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            ACTIONS
                        </th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    <?php $__empty_1 = true; $__currentLoopData = $requests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $request): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr class="hover:bg-gray-50">
                            <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">
                                #<?php echo e($request->justificationID); ?>

                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                #<?php echo e($request->applicationID); ?>

                            </td>
                            <td class="px-6 py-4 text-sm text-gray-900">
                                <div>
                                    <div class="font-medium"><?php echo e($request->placementApplication->companyName); ?></div>
                                    <div class="text-gray-500"><?php echo e($request->placementApplication->position); ?></div>
                                </div>
                            </td>
                            <td class="px-6 py-4 text-sm text-gray-900">
                                <div class="max-w-xs truncate" title="<?php echo e($request->reason); ?>">
                                    <?php echo e($request->reason); ?>

                                </div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                <?php echo e($request->requestDate->format('M d, Y')); ?>

                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="text-xs space-y-1">
                                    <div>
                                        <span class="font-medium">Committee:</span>
                                        <span
                                            class="inline-flex px-2 py-1 text-xs rounded-full
                                            <?php echo e($request->committeeStatus === 'Approved'
                                                ? 'bg-green-100 text-green-800'
                                                : ($request->committeeStatus === 'Rejected'
                                                    ? 'bg-red-100 text-red-800'
                                                    : 'bg-yellow-100 text-yellow-800')); ?>">
                                            <?php echo e($request->committeeStatus); ?>

                                        </span>
                                    </div>
                                    <div>
                                        <span class="font-medium">Coordinator:</span>
                                        <span
                                            class="inline-flex px-2 py-1 text-xs rounded-full
                                            <?php echo e($request->coordinatorStatus === 'Approved'
                                                ? 'bg-green-100 text-green-800'
                                                : ($request->coordinatorStatus === 'Rejected'
                                                    ? 'bg-red-100 text-red-800'
                                                    : 'bg-yellow-100 text-yellow-800')); ?>">
                                            <?php echo e($request->coordinatorStatus); ?>

                                            <?php if($request->committeeStatus === 'Rejected' && $request->coordinatorStatus === 'Rejected' && !$request->coordinatorID): ?>
                                                <span class="ml-1" title="Auto-rejected due to committee rejection">*</span>
                                            <?php endif; ?>
                                        </span>
                                    </div>
                                </div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                                <div class="flex items-center space-x-2">
                                    <!-- View Details -->
                                    <button wire:click="viewRequest(<?php echo e($request->justificationID); ?>)"
                                        class="text-gray-600 hover:text-gray-900" title="View details">
                                        👁️ View
                                    </button>

                                    <!-- Files Dropdown -->
                                    <?php if($request->files->count() > 0): ?>
                                        <div class="relative group">
                                            <button class="text-gray-600 hover:text-gray-900" title="<?php echo e($request->files->count()); ?> file(s)">
                                                📎 <?php echo e($request->files->count()); ?>

                                            </button>
                                            <div class="absolute right-0 mt-2 w-48 bg-white border border-gray-200 rounded-md shadow-lg opacity-0 invisible group-hover:opacity-100 group-hover:visible transition-all duration-200 z-10">
                                                <div class="py-1">
                                                    <?php $__currentLoopData = $request->files; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $file): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <button wire:click="downloadFile(<?php echo e($file->id); ?>)"
                                                            class="block w-full text-left px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">
                                                            📄 <?php echo e($file->original_name); ?>

                                                        </button>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="7" class="px-6 py-8 text-center text-gray-500">
                                <p class="text-lg font-medium mb-2">No change requests found</p>
                                <p class="text-sm">You haven't submitted any change requests yet.</p>
                                <a href="<?php echo e(route('student.placementApplications')); ?>"
                                   class="mt-4 inline-flex items-center px-4 py-2 bg-blue-600 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-blue-700">
                                    Go to Placement Applications
                                </a>
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <!-- Pagination -->
        <?php if($requests->hasPages()): ?>
            <div class="px-6 py-4 border-t border-gray-200">
                <?php echo e($requests->links()); ?>

            </div>
        <?php endif; ?>
    </div>

    <!-- Change Request Detail Modal -->
    <?php if($showDetailModal && $selectedRequest): ?>
        <div class="fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full z-50" wire:click="closeDetailModal">
            <div class="relative top-20 mx-auto p-5 border w-11/12 md:w-3/4 lg:w-1/2 shadow-lg rounded-md bg-white" wire:click.stop>
                <div class="flex justify-between items-center mb-4">
                    <h3 class="text-lg font-bold text-gray-900">Change Request Details #<?php echo e($selectedRequest->justificationID); ?></h3>
                    <button wire:click="closeDetailModal" class="text-gray-400 hover:text-gray-600">
                        <span class="sr-only">Close</span>
                        <svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                        </svg>
                    </button>
                </div>

                <div class="space-y-6">
                    <!-- Current Placement Application -->
                    <div class="bg-blue-50 p-4 rounded-lg">
                        <h4 class="font-semibold text-blue-800 mb-2">📋 Current Placement Application</h4>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4 text-sm">
                            <div>
                                <span class="font-medium text-blue-700">Application ID:</span>
                                <span class="text-blue-900">#<?php echo e($selectedRequest->placementApplication->applicationID); ?></span>
                            </div>
                            <div>
                                <span class="font-medium text-blue-700">Company:</span>
                                <span class="text-blue-900"><?php echo e($selectedRequest->placementApplication->companyName); ?></span>
                            </div>
                            <div>
                                <span class="font-medium text-blue-700">Position:</span>
                                <span class="text-blue-900"><?php echo e($selectedRequest->placementApplication->position); ?></span>
                            </div>
                            <div>
                                <span class="font-medium text-blue-700">Work Method:</span>
                                <span class="text-blue-900"><?php echo e($selectedRequest->placementApplication->method_of_work_display); ?></span>
                            </div>
                            <div>
                                <span class="font-medium text-blue-700">Duration:</span>
                                <span class="text-blue-900">
                                    <?php echo e($selectedRequest->placementApplication->startDate->format('M d, Y')); ?> -
                                    <?php echo e($selectedRequest->placementApplication->endDate->format('M d, Y')); ?>

                                </span>
                            </div>
                            <div>
                                <span class="font-medium text-blue-700">Application Status:</span>
                                <span class="text-blue-900"><?php echo e($selectedRequest->placementApplication->overall_status); ?></span>
                            </div>
                        </div>
                    </div>

                    <!-- Change Request Information -->
                    <div class="bg-gray-50 p-4 rounded-lg">
                        <h4 class="font-semibold text-gray-800 mb-2">🔄 Change Request Information</h4>
                        <div class="space-y-3">
                            <div>
                                <span class="font-medium text-gray-700">Request Date:</span>
                                <span class="text-gray-900"><?php echo e($selectedRequest->requestDate->format('M d, Y')); ?></span>
                            </div>
                            <div>
                                <span class="font-medium text-gray-700">Reason for Change:</span>
                                <div class="text-gray-900 mt-1 p-3 bg-white rounded border">
                                    <?php echo e($selectedRequest->reason); ?>

                                </div>
                            </div>
                            <?php if($selectedRequest->decisionDate): ?>
                                <div>
                                    <span class="font-medium text-gray-700">Decision Date:</span>
                                    <span class="text-gray-900"><?php echo e($selectedRequest->decisionDate->format('M d, Y')); ?></span>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>

                    <!-- Approval Status -->
                    <div class="bg-gray-50 p-4 rounded-lg">
                        <h4 class="font-semibold text-gray-800 mb-2">📊 Approval Status</h4>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <span class="font-medium text-gray-700">Committee Status:</span>
                                <span class="ml-2 inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium
                                    <?php if($selectedRequest->committeeStatus === 'Approved'): ?> bg-green-100 text-green-800
                                    <?php elseif($selectedRequest->committeeStatus === 'Rejected'): ?> bg-red-100 text-red-800
                                    <?php else: ?> bg-yellow-100 text-yellow-800 <?php endif; ?>">
                                    <?php echo e($selectedRequest->committeeStatus); ?>

                                </span>
                                <?php if($selectedRequest->committee): ?>
                                    <div class="text-sm text-gray-600 mt-1">
                                        Reviewed by: <?php echo e($selectedRequest->committee->user->name); ?>

                                    </div>
                                <?php endif; ?>
                            </div>
                            <div>
                                <span class="font-medium text-gray-700">Coordinator Status:</span>
                                <span class="ml-2 inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium
                                    <?php if($selectedRequest->coordinatorStatus === 'Approved'): ?> bg-green-100 text-green-800
                                    <?php elseif($selectedRequest->coordinatorStatus === 'Rejected'): ?> bg-red-100 text-red-800
                                    <?php else: ?> bg-yellow-100 text-yellow-800 <?php endif; ?>">
                                    <?php echo e($selectedRequest->coordinatorStatus); ?>

                                    <?php if($selectedRequest->committeeStatus === 'Rejected' && $selectedRequest->coordinatorStatus === 'Rejected' && !$selectedRequest->coordinatorID): ?>
                                        <span class="ml-1" title="Auto-rejected due to committee rejection">*</span>
                                    <?php endif; ?>
                                </span>
                                <?php if($selectedRequest->coordinator): ?>
                                    <div class="text-sm text-gray-600 mt-1">
                                        Reviewed by: <?php echo e($selectedRequest->coordinator->user->name); ?>

                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>

                    <!-- Supporting Documents -->
                    <?php if($selectedRequest->files->count() > 0): ?>
                        <div class="bg-green-50 p-4 rounded-lg">
                            <h4 class="font-semibold text-green-800 mb-2">📎 Supporting Documents</h4>
                            <div class="space-y-2">
                                <?php $__currentLoopData = $selectedRequest->files; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $file): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="flex items-center justify-between bg-white p-3 rounded border">
                                        <div class="flex items-center">
                                            <span class="text-green-600 mr-2">📄</span>
                                            <div>
                                                <div class="font-medium text-green-800"><?php echo e($file->original_name); ?></div>
                                                <div class="text-sm text-green-600">
                                                    <?php echo e(number_format($file->file_size / 1024, 1)); ?> KB
                                                </div>
                                            </div>
                                        </div>
                                        <button wire:click="downloadFile(<?php echo e($file->id); ?>)"
                                            class="px-3 py-1 bg-green-600 text-white rounded text-sm hover:bg-green-700">
                                            Download
                                        </button>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    <?php endif; ?>

                    <!-- Lecturer Remarks -->
                    <?php if($selectedRequest->remarks): ?>
                        <div class="bg-purple-50 p-4 rounded-lg">
                            <h4 class="font-semibold text-purple-800 mb-2">💬 Lecturer Remarks</h4>
                            <div class="text-purple-900 p-3 bg-white rounded border">
                                <?php echo e($selectedRequest->remarks); ?>

                            </div>
                        </div>
                    <?php endif; ?>

                    <!-- Next Steps -->
                    <?php if($selectedRequest->overall_status === 'Approved'): ?>
                        <div class="bg-blue-50 border border-blue-200 rounded-lg p-4">
                            <div class="flex items-center">
                                <span class="text-blue-500 text-xl mr-3">ℹ️</span>
                                <div>
                                    <h4 class="font-semibold text-blue-800">Change Request Approved!</h4>
                                    <p class="text-blue-700 mt-1">
                                        Your change request has been approved by both committee and coordinator.
                                        You can now submit a new placement application from the
                                        <a href="<?php echo e(route('student.placementApplications')); ?>" class="underline font-medium">
                                            Placement Applications page
                                        </a>.
                                    </p>
                                </div>
                            </div>
                        </div>
                    <?php elseif($selectedRequest->overall_status === 'Rejected'): ?>
                        <div class="bg-red-50 border border-red-200 rounded-lg p-4">
                            <div class="flex items-center">
                                <span class="text-red-500 text-xl mr-3">❌</span>
                                <div>
                                    <h4 class="font-semibold text-red-800">Change Request Rejected</h4>
                                    <p class="text-red-700 mt-1">
                                        Your change request has been rejected. Please review the lecturer remarks above for feedback.
                                        Your current placement application remains active.
                                    </p>
                                </div>
                            </div>
                        </div>
                    <?php else: ?>
                        <div class="bg-yellow-50 border border-yellow-200 rounded-lg p-4">
                            <div class="flex items-center">
                                <span class="text-yellow-500 text-xl mr-3">⏳</span>
                                <div>
                                    <h4 class="font-semibold text-yellow-800">Change Request Under Review</h4>
                                    <p class="text-yellow-700 mt-1">
                                        Your change request is currently being reviewed by the committee and coordinator.
                                        You will receive an email notification once a decision is made.
                                    </p>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>

                <!-- Modal Footer -->
                <div class="mt-6 flex justify-end">
                    <button wire:click="closeDetailModal"
                        class="px-4 py-2 bg-gray-500 text-white rounded-lg hover:bg-gray-600">
                        Close
                    </button>
                </div>
            </div>
        </div>
    <?php endif; ?>
        </div>
    </div>
</div><?php /**PATH C:\Users\User\Desktop\Laravel\Internlink\resources\views\livewire\student-change-request-history.blade.php ENDPATH**/ ?>