<div>
    <!-- Custom Styles for Better Icon Visibility -->
    <style>
        .sort-icon {
            display: inline-block;
            width: 12px;
            text-align: center;
        }

        .sort-icon:before {
            font-weight: 900;
        }

        /* Fallback for missing FontAwesome */
        .fa-sort:before {
            content: "↕";
        }

        .fa-sort-up:before {
            content: "↑";
        }

        .fa-sort-down:before {
            content: "↓";
        }

        .fa-search:before {
            content: "🔍";
        }

        .fa-eye:before {
            content: "👁️";
        }

        .fa-download:before {
            content: "⬇️";
        }

        .fa-check:before {
            content: "✅";
        }

        .fa-times:before {
            content: "❌";
        }

        .fa-filter:before {
            content: "🔍";
        }

        .modal-overlay {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: rgba(0, 0, 0, 0.5);
            z-index: 50;
        }

        .modal-content {
            position: fixed;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            z-index: 51;
            max-height: 90vh;
            overflow-y: auto;
        }
    </style>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <!-- Statistics Cards -->
            <div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-6">
                <div class="bg-white rounded-lg shadow-md p-6">
                    <div class="flex items-center">
                        <div class="p-3 rounded-full bg-blue-100">
                            <i class="fa fa-file text-blue-600 text-xl"></i>
                        </div>
                        <div class="ml-4">
                            <p class="text-sm font-medium text-gray-600">
                                <?php if($isAcademicAdvisor): ?>
                                    Pending Review
                                <?php else: ?>
                                    Pending Review
                                <?php endif; ?>
                            </p>
                            <p class="text-2xl font-bold text-gray-900"><?php echo e($pendingApplications); ?></p>
                        </div>
                    </div>
                </div>

                <div class="bg-white rounded-lg shadow-md p-6">
                    <div class="flex items-center">
                        <div class="p-3 rounded-full bg-yellow-100">
                            <i class="fa fa-clock text-yellow-600 text-xl"></i>
                        </div>
                        <div class="ml-4">
                            <p class="text-sm font-medium text-gray-600">Total Applications</p>
                            <p class="text-2xl font-bold text-gray-900"><?php echo e($totalApplications); ?></p>
                        </div>
                    </div>
                </div>

                <div class="bg-white rounded-lg shadow-md p-6">
                    <div class="flex items-center">
                        <div class="p-3 rounded-full bg-green-100">
                            <i class="fa fa-check text-green-600 text-xl"></i>
                        </div>
                        <div class="ml-4">
                            <p class="text-sm font-medium text-gray-600">
                                <?php if($isAcademicAdvisor): ?>
                                    Eligible
                                <?php else: ?>
                                    Approved
                                <?php endif; ?>
                            </p>
                            <p class="text-2xl font-bold text-gray-900"><?php echo e($approvedApplications); ?></p>
                        </div>
                    </div>
                </div>

                <div class="bg-white rounded-lg shadow-md p-6">
                    <div class="flex items-center">
                        <div class="p-3 rounded-full bg-red-100">
                            <i class="fa fa-times text-red-600 text-xl"></i>
                        </div>
                        <div class="ml-4">
                            <p class="text-sm font-medium text-gray-600">
                                <?php if($isAcademicAdvisor): ?>
                                    Ineligible
                                <?php else: ?>
                                    Rejected
                                <?php endif; ?>
                            </p>
                            <p class="text-2xl font-bold text-gray-900"><?php echo e($rejectedApplications); ?></p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Flash Messages -->
            <?php if(session()->has('message')): ?>
                <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4" role="alert">
                    <span class="block sm:inline"><?php echo e(session('message')); ?></span>
                </div>
            <?php endif; ?>

            <?php if(session()->has('error')): ?>
                <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4" role="alert">
                    <span class="block sm:inline"><?php echo e(session('error')); ?></span>
                </div>
            <?php endif; ?>

            <!-- Advanced Filters -->
            <div class="px-6 py-4 border-b border-gray-200 bg-gray-50 rounded-lg">
                <div class="grid grid-cols-1 md:grid-cols-3 lg:grid-cols-7 gap-4">
                    <!-- Search -->
                    <div class="lg:col-span-2">
                        <input type="text" wire:model.live.debounce.300ms="search"
                            class="w-full border border-gray-300 rounded-md px-3 py-2 text-sm"
                            placeholder="Search by ID, student name, email...">
                    </div>

                    <!-- Program Filter -->
                    <div>
                        <select wire:model.live="program"
                            class="w-full border border-gray-300 rounded-md px-3 py-2 text-sm dark:text-gray-600">
                            <option value="">All Programs</option>
                            <option value="BCS">Bachelor of Computer Science (Software Engineering) with Honours</option>
                            <option value="BCN">Bachelor of Computer Science (Computer Systems & Networking) with Honours</option>
                            <option value="BCM">Bachelor of Computer Science (Multimedia Software) with Honours</option>
                            <option value="BCY">Bachelor of Computer Science (Cyber Security) with Honours</option>
                            <option value="DRC">Diploma in Computer Science</option>
                        </select>
                    </div>

                    <!-- Semester Filter -->
                    <div>
                        <select wire:model.live="semester"
                            class="w-full border border-gray-300 rounded-md px-3 py-2 text-sm dark:text-gray-600">
                            <option value="">All Semesters</option>
                            <option value="1">Semester 1</option>
                            <option value="2">Semester 2</option>
                        </select>
                    </div>

                    <!-- Year Filter -->
                    <div>
                        <select wire:model.live="year"
                            class="w-full border border-gray-300 rounded-md px-3 py-2 text-sm dark:text-gray-600">
                            <option value="">All Years</option>
                            <?php for($y = date('Y'); $y >= 2020; $y--): ?>
                                <option value="<?php echo e($y); ?>"><?php echo e($y); ?></option>
                            <?php endfor; ?>
                        </select>
                    </div>

                    <!-- Status Filter -->
                    <div>
                        <select wire:model.live="statusFilter"
                            class="w-full border border-gray-300 rounded-md px-3 py-2 text-sm dark:text-gray-600">
                            <option value="">All Status</option>
                            <option value="pending">
                                <?php if($isAcademicAdvisor): ?>
                                    Pending Review
                                <?php else: ?>
                                    Pending Coordinator Review
                                <?php endif; ?>
                            </option>
                            <option value="approved">
                                <?php if($isAcademicAdvisor): ?>
                                    Marked as Eligible
                                <?php else: ?>
                                    Approved
                                <?php endif; ?>
                            </option>
                            <option value="rejected">
                                <?php if($isAcademicAdvisor): ?>
                                    Marked as Ineligible
                                <?php else: ?>
                                    Rejected
                                <?php endif; ?>
                            </option>
                        </select>
                    </div>

                    <!-- Clear Filters -->
                    <div>
                        <button wire:click="clearFilters"
                            class="w-full px-4 py-2 border border-gray-300 rounded-md text-sm font-medium text-gray-700 bg-white hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                            Clear Filters
                        </button>
                    </div>
                </div>
            </div>

            <!-- Bulk Actions Section -->
            <?php if(count($selectedApplications) > 0): ?>
                <div class="bg-blue-50 border border-blue-200 rounded-lg p-4 mb-6">
                    <div class="flex flex-col md:flex-row md:items-center md:justify-between gap-4">
                        <div class="flex items-center">
                            <i class="fa fa-check text-blue-600 text-lg mr-3"></i>
                            <span class="text-sm font-medium text-blue-900">
                                <?php echo e(count($selectedApplications)); ?> application(s) selected
                            </span>
                        </div>

                        <div class="flex flex-col md:flex-row gap-2">
                            <!-- Bulk Remarks Input -->
                            <input type="text" wire:model="remarks"
                                class="px-3 py-2 border border-gray-300 rounded-md text-sm focus:outline-none focus:ring-1 focus:ring-blue-500"
                                placeholder="Remarks (required for reject)">

                            <!-- Bulk Actions Buttons -->
                            <button wire:click="bulkDownload"
                                wire:loading.attr="disabled"
                                wire:target="bulkDownload"
                                class="inline-flex items-center gap-2 px-4 py-2 border border-transparent rounded-lg text-sm font-medium text-white bg-green-600 hover:bg-green-700 dark:bg-green-600 dark:hover:bg-green-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-green-500 disabled:opacity-50 disabled:cursor-not-allowed transition-colors shadow-sm hover:shadow-md">
                                <span wire:loading.remove wire:target="bulkDownload" class="flex items-center gap-2">
                                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-4 h-4">
                                        <path stroke-linecap="round" stroke-linejoin="round" d="M3 16.5v2.25A2.25 2.25 0 0 0 5.25 21h13.5A2.25 2.25 0 0 0 21 18.75V16.5M16.5 12 12 16.5m0 0L7.5 12m4.5 4.5V3" />
                                    </svg>
                                    <span>Download All</span>
                                </span>
                                <span wire:loading wire:target="bulkDownload" class="flex items-center gap-2">
                                    <?php if (isset($component)) { $__componentOriginal5c29929acf227acd7c5fa56a39e71fcc = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal5c29929acf227acd7c5fa56a39e71fcc = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.loading-spinner','data' => ['size' => 'h-4 w-4','color' => 'text-white']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('loading-spinner'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['size' => 'h-4 w-4','color' => 'text-white']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal5c29929acf227acd7c5fa56a39e71fcc)): ?>
<?php $attributes = $__attributesOriginal5c29929acf227acd7c5fa56a39e71fcc; ?>
<?php unset($__attributesOriginal5c29929acf227acd7c5fa56a39e71fcc); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal5c29929acf227acd7c5fa56a39e71fcc)): ?>
<?php $component = $__componentOriginal5c29929acf227acd7c5fa56a39e71fcc; ?>
<?php unset($__componentOriginal5c29929acf227acd7c5fa56a39e71fcc); ?>
<?php endif; ?>
                                    <span>Downloading...</span>
                                </span>
                            </button>

                            <button wire:click="bulkReject"
                                wire:confirm="Are you sure you want to reject <?php echo e(count($selectedApplications)); ?> application(s)?"
                                wire:loading.attr="disabled"
                                wire:target="bulkReject"
                                class="px-4 py-2 border border-transparent rounded-md text-sm font-medium text-white bg-red-600 hover:bg-red-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-500 disabled:opacity-50 disabled:cursor-not-allowed">
                                <span wire:loading.remove wire:target="bulkReject">
                                    <i class="fa fa-times mr-2"></i>
                                    Reject Selected
                                </span>
                                <span wire:loading wire:target="bulkReject" class="flex items-center">
                                    <?php if (isset($component)) { $__componentOriginal5c29929acf227acd7c5fa56a39e71fcc = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal5c29929acf227acd7c5fa56a39e71fcc = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.loading-spinner','data' => ['class' => 'mr-2']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('loading-spinner'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'mr-2']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal5c29929acf227acd7c5fa56a39e71fcc)): ?>
<?php $attributes = $__attributesOriginal5c29929acf227acd7c5fa56a39e71fcc; ?>
<?php unset($__attributesOriginal5c29929acf227acd7c5fa56a39e71fcc); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal5c29929acf227acd7c5fa56a39e71fcc)): ?>
<?php $component = $__componentOriginal5c29929acf227acd7c5fa56a39e71fcc; ?>
<?php unset($__componentOriginal5c29929acf227acd7c5fa56a39e71fcc); ?>
<?php endif; ?>
                                    Rejecting...
                                </span>
                            </button>

                            <button wire:click="bulkApprove"
                                wire:confirm="Are you sure you want to approve <?php echo e(count($selectedApplications)); ?> application(s)?"
                                wire:loading.attr="disabled"
                                wire:target="bulkApprove"
                                class="px-4 py-2 border border-transparent rounded-md text-sm font-medium text-white bg-green-600 hover:bg-green-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-green-500 disabled:opacity-50 disabled:cursor-not-allowed">
                                <span wire:loading.remove wire:target="bulkApprove">
                                    <i class="fa fa-check mr-2"></i>
                                    Approve Selected
                                </span>
                                <span wire:loading wire:target="bulkApprove" class="flex items-center">
                                    <?php if (isset($component)) { $__componentOriginal5c29929acf227acd7c5fa56a39e71fcc = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal5c29929acf227acd7c5fa56a39e71fcc = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.loading-spinner','data' => ['class' => 'mr-2']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('loading-spinner'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'mr-2']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal5c29929acf227acd7c5fa56a39e71fcc)): ?>
<?php $attributes = $__attributesOriginal5c29929acf227acd7c5fa56a39e71fcc; ?>
<?php unset($__attributesOriginal5c29929acf227acd7c5fa56a39e71fcc); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal5c29929acf227acd7c5fa56a39e71fcc)): ?>
<?php $component = $__componentOriginal5c29929acf227acd7c5fa56a39e71fcc; ?>
<?php unset($__componentOriginal5c29929acf227acd7c5fa56a39e71fcc); ?>
<?php endif; ?>
                                    Approving...
                                </span>
                            </button>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
            <br>

            <!-- Table Section -->
            <div class="bg-white rounded-lg shadow-md overflow-hidden">
                <div class="overflow-x-auto">
                    <table class="min-w-full divide-y divide-gray-200">
                        <thead class="bg-gray-50">
                            <tr>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider w-12">
                                    <input type="checkbox" wire:model.live="selectAll"
                                        class="rounded border-gray-300 text-blue-600 focus:ring-blue-500 cursor-pointer"
                                        title="Select all">
                                </th>
                                <th scope="col"
                                    class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    <button wire:click="sortBy('courseVerificationID')"
                                        class="flex items-center hover:text-gray-700">
                                        Application ID
                                        <span class="ml-1 sort-icon">
                                            <?php if($sortField === 'courseVerificationID'): ?>
                                                <?php if($sortDirection === 'asc'): ?>
                                                    <i class="fa fa-sort-up"></i>
                                                <?php else: ?>
                                                    <i class="fa fa-sort-down"></i>
                                                <?php endif; ?>
                                            <?php else: ?>
                                                <i class="fa fa-sort"></i>
                                            <?php endif; ?>
                                        </span>
                                    </button>
                                </th>
                                <th scope="col"
                                    class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    <button wire:click="sortBy('studentID')"
                                        class="flex items-center hover:text-gray-700">
                                        Student ID
                                        <span class="ml-1 sort-icon">
                                            <?php if($sortField === 'studentID'): ?>
                                                <?php if($sortDirection === 'asc'): ?>
                                                    <i class="fa fa-sort-up"></i>
                                                <?php else: ?>
                                                    <i class="fa fa-sort-down"></i>
                                                <?php endif; ?>
                                            <?php else: ?>
                                                <i class="fa fa-sort"></i>
                                            <?php endif; ?>
                                        </span>
                                    </button>
                                </th>
                                <th scope="col"
                                    class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    <button wire:click="sortBy('studentName')"
                                        class="flex items-center hover:text-gray-700">
                                        Student Name
                                        <span class="ml-1 sort-icon">
                                            <?php if($sortField === 'studentName'): ?>
                                                <?php if($sortDirection === 'asc'): ?>
                                                    <i class="fa fa-sort-up"></i>
                                                <?php else: ?>
                                                    <i class="fa fa-sort-down"></i>
                                                <?php endif; ?>
                                            <?php else: ?>
                                                <i class="fa fa-sort"></i>
                                            <?php endif; ?>
                                        </span>
                                    </button>
                                </th>
                                <th scope="col"
                                    class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    Current Credit
                                </th>
                                <th scope="col"
                                    class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    <button wire:click="sortBy('status')" class="flex items-center hover:text-gray-700">
                                        <?php if($isAcademicAdvisor): ?>
                                            Eligibility Status
                                        <?php else: ?>
                                            Status
                                        <?php endif; ?>
                                        <span class="ml-1 sort-icon">
                                            <?php if($sortField === 'status'): ?>
                                                <?php if($sortDirection === 'asc'): ?>
                                                    <i class="fa fa-sort-up"></i>
                                                <?php else: ?>
                                                    <i class="fa fa-sort-down"></i>
                                                <?php endif; ?>
                                            <?php else: ?>
                                                <i class="fa fa-sort"></i>
                                            <?php endif; ?>
                                        </span>
                                    </button>
                                </th>
                                <th scope="col"
                                    class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    <button wire:click="sortBy('applicationDate')"
                                        class="flex items-center hover:text-gray-700">
                                        Application Date
                                        <span class="ml-1 sort-icon">
                                            <?php if($sortField === 'applicationDate'): ?>
                                                <?php if($sortDirection === 'asc'): ?>
                                                    <i class="fa fa-sort-up"></i>
                                                <?php else: ?>
                                                    <i class="fa fa-sort-down"></i>
                                                <?php endif; ?>
                                            <?php else: ?>
                                                <i class="fa fa-sort"></i>
                                            <?php endif; ?>
                                        </span>
                                    </button>
                                </th>
                                <th scope="col"
                                    class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    Actions
                                </th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            <?php $__empty_1 = true; $__currentLoopData = $applications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $application): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr
                                    class="hover:bg-gray-50 <?php echo e(($isAcademicAdvisor && $application->academicAdvisorStatus === null) || ($isCoordinator && $application->status === 'pending' && $application->academicAdvisorStatus === 'approved') ? 'bg-yellow-50' : ''); ?>">
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <?php if($isAcademicAdvisor): ?>
                                            <?php if($application->academicAdvisorStatus === null): ?>
                                                <input type="checkbox"
                                                    wire:model.live="selectedApplications"
                                                    value="<?php echo e($application->courseVerificationID); ?>"
                                                    class="rounded border-gray-300 text-blue-600 focus:ring-blue-500 cursor-pointer">
                                            <?php else: ?>
                                                <span class="text-gray-400" title="Already <?php echo e($application->academicAdvisorStatus); ?>">
                                                    <i class="fa <?php echo e($application->academicAdvisorStatus === 'approved' ? 'fa-check' : 'fa-times'); ?>"></i>
                                                </span>
                                            <?php endif; ?>
                                        <?php else: ?>
                                            <?php if($application->status === 'pending' && $application->academicAdvisorStatus === 'approved'): ?>
                                                <input type="checkbox"
                                                    wire:model.live="selectedApplications"
                                                    value="<?php echo e($application->courseVerificationID); ?>"
                                                    class="rounded border-gray-300 text-blue-600 focus:ring-blue-500 cursor-pointer">
                                            <?php else: ?>
                                                <span class="text-gray-400" title="Already <?php echo e($application->status); ?>">
                                                    <i class="fa <?php echo e($application->status === 'approved' ? 'fa-check' : 'fa-times'); ?>"></i>
                                                </span>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">
                                        <?php echo e($application->courseVerificationID); ?>

                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                        <?php echo e($application->studentID); ?>

                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                        <?php echo e($application->student->user->name ?? 'N/A'); ?>

                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                        <?php echo e($application->currentCredit); ?> / 130
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <?php if($isAcademicAdvisor): ?>
                                            <?php
                                                $statusClasses = [
                                                    'pending' => 'bg-yellow-100 text-yellow-800',
                                                    'approved' => 'bg-green-100 text-green-800',
                                                    'rejected' => 'bg-red-100 text-red-800',
                                                ];
                                                $displayStatus = $application->academicAdvisorStatus ?? 'pending';
                                                $statusLabels = [
                                                    'pending' => 'Pending Review',
                                                    'approved' => 'Marked as Eligible',
                                                    'rejected' => 'Marked as Ineligible',
                                                ];
                                            ?>
                                            <span
                                                class="inline-flex px-2 py-1 text-xs font-semibold rounded-full <?php echo e($statusClasses[$displayStatus] ?? 'bg-gray-100 text-gray-800'); ?>">
                                                <?php echo e($statusLabels[$displayStatus] ?? 'Unknown'); ?>

                                            </span>
                                        <?php else: ?>
                                            <?php
                                                $statusClasses = [
                                                    'pending' => 'bg-yellow-100 text-yellow-800',
                                                    'approved' => 'bg-green-100 text-green-800',
                                                    'rejected' => 'bg-red-100 text-red-800',
                                                ];
                                            ?>
                                            <span
                                                class="inline-flex px-2 py-1 text-xs font-semibold rounded-full <?php echo e($statusClasses[$application->status] ?? 'bg-gray-100 text-gray-800'); ?>">
                                                <?php echo e(ucfirst($application->status)); ?>

                                            </span>
                                            <?php if($application->academicAdvisorStatus === 'approved'): ?>
                                                <span class="ml-2 inline-flex px-2 py-1 text-xs font-semibold rounded-full bg-blue-100 text-blue-800" title="Approved by Academic Advisor">
                                                    AA ✓
                                                </span>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                        <?php echo e($application->applicationDate->format('M d, Y')); ?>

                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                                        <div class="flex items-center space-x-2">
                                            <button wire:click="viewApplication(<?php echo e($application->courseVerificationID); ?>)"
                                                class="inline-flex items-center gap-1.5 px-2.5 py-1.5 text-sm font-medium text-blue-700 bg-blue-50 hover:bg-blue-100 dark:bg-blue-900/20 dark:text-blue-400 dark:hover:bg-blue-900/30 rounded-lg transition-colors"
                                                title="View details">
                                                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-4 h-4">
                                                    <path stroke-linecap="round" stroke-linejoin="round" d="M2.036 12.322a1.012 1.012 0 0 1 0-.639C3.423 7.51 7.36 4.5 12 4.5c4.638 0 8.573 3.007 9.963 7.178.07.207.07.431 0 .639C20.577 16.49 16.64 19.5 12 19.5c-4.638 0-8.573-3.007-9.963-7.178Z" />
                                                    <path stroke-linecap="round" stroke-linejoin="round" d="M15 12a3 3 0 1 1-6 0 3 3 0 0 1 6 0Z" />
                                                </svg>
                                                <span>View</span>
                                            </button>
                                            <?php if($application->files->count() > 0): ?>
                                                <button wire:click="downloadFile(<?php echo e($application->files->first()->id); ?>)"
                                                    wire:loading.attr="disabled"
                                                    wire:target="downloadFile(<?php echo e($application->files->first()->id); ?>)"
                                                    class="inline-flex items-center gap-1.5 px-2.5 py-1.5 text-sm font-medium text-green-700 bg-green-50 hover:bg-green-100 dark:bg-green-900/20 dark:text-green-400 dark:hover:bg-green-900/30 rounded-lg transition-colors disabled:opacity-50 disabled:cursor-not-allowed"
                                                    title="Download file">
                                                    <span wire:loading.remove wire:target="downloadFile(<?php echo e($application->files->first()->id); ?>)" class="flex items-center gap-1.5">
                                                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-4 h-4">
                                                            <path stroke-linecap="round" stroke-linejoin="round" d="M3 16.5v2.25A2.25 2.25 0 0 0 5.25 21h13.5A2.25 2.25 0 0 0 21 18.75V16.5M16.5 12 12 16.5m0 0L7.5 12m4.5 4.5V3" />
                                                        </svg>
                                                        <span>Download</span>
                                                    </span>
                                                    <span wire:loading wire:target="downloadFile(<?php echo e($application->files->first()->id); ?>)" class="flex items-center gap-1.5">
                                                        <?php if (isset($component)) { $__componentOriginal5c29929acf227acd7c5fa56a39e71fcc = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal5c29929acf227acd7c5fa56a39e71fcc = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.loading-spinner','data' => ['size' => 'h-4 w-4','color' => 'text-green-600 dark:text-green-400']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('loading-spinner'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['size' => 'h-4 w-4','color' => 'text-green-600 dark:text-green-400']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal5c29929acf227acd7c5fa56a39e71fcc)): ?>
<?php $attributes = $__attributesOriginal5c29929acf227acd7c5fa56a39e71fcc; ?>
<?php unset($__attributesOriginal5c29929acf227acd7c5fa56a39e71fcc); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal5c29929acf227acd7c5fa56a39e71fcc)): ?>
<?php $component = $__componentOriginal5c29929acf227acd7c5fa56a39e71fcc; ?>
<?php unset($__componentOriginal5c29929acf227acd7c5fa56a39e71fcc); ?>
<?php endif; ?>
                                                    </span>
                                                </button>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="8" class="px-6 py-8 text-center text-gray-500">
                                        <div class="flex flex-col items-center">
                                            <i class="fa fa-file text-4xl text-gray-300 mb-4"></i>
                                            <p class="text-lg font-medium mb-2">No applications found</p>
                                            <p class="text-sm">Applications will appear here when students submit them.
                                            </p>
                                        </div>
                                    </td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>

                <!-- Pagination -->
                <div class="bg-white dark:bg-gray-800 px-4 py-4 border-t border-gray-200 dark:border-gray-700 sm:px-6">
                    <?php echo e($applications->links()); ?>

                </div>
            </div>
        </div>
    </div>

    <!-- Application Detail Modal -->
    <?php if($showDetailModal && $selectedApplication): ?>
        <div class="modal-overlay">
            <div class="modal-content bg-white rounded-lg shadow-xl max-w-2xl w-full mx-4">
                <div class="px-6 py-4 border-b border-gray-200">
                    <div class="flex items-center justify-between">
                        <h3 class="text-lg font-medium text-gray-900">
                            Application Details - ID: <?php echo e($selectedApplication->courseVerificationID); ?>

                        </h3>
                        <button type="button" wire:click="closeDetailModal"
                            class="text-gray-400 hover:text-gray-600">
                            <i class="fa fa-times text-xl"></i>
                        </button>
                    </div>
                </div>

                <div class="px-6 py-4 space-y-6">
                    <!-- Student Information -->
                    <div class="bg-gray-50 rounded-lg p-4">
                        <h4 class="text-md font-semibold text-gray-900 mb-3">Student Information</h4>
                        <div class="grid grid-cols-2 gap-4">
                            <div>
                                <p class="text-sm font-medium text-gray-600">Student ID</p>
                                <p class="text-sm text-gray-900"><?php echo e($selectedApplication->studentID); ?></p>
                            </div>
                            <div>
                                <p class="text-sm font-medium text-gray-600">Name</p>
                                <p class="text-sm text-gray-900">
                                    <?php echo e($selectedApplication->student->user->name ?? 'N/A'); ?></p>
                            </div>
                            <div>
                                <p class="text-sm font-medium text-gray-600">Email</p>
                                <p class="text-sm text-gray-900">
                                    <?php echo e($selectedApplication->student->user->email ?? 'N/A'); ?></p>
                            </div>
                            <div>
                                <p class="text-sm font-medium text-gray-600">Program</p>
                                <p class="text-sm text-gray-900"><?php echo e($selectedApplication->student->program ?? 'N/A'); ?>

                                </p>
                            </div>
                        </div>
                    </div>

                    <!-- Application Information -->
                    <div class="bg-blue-50 rounded-lg p-4">
                        <h4 class="text-md font-semibold text-gray-900 mb-3">Application Information</h4>
                        <div class="grid grid-cols-2 gap-4">
                            <div>
                                <p class="text-sm font-medium text-gray-600">Current Credit</p>
                                <p class="text-sm text-gray-900"><?php echo e($selectedApplication->currentCredit); ?> / 130</p>
                            </div>
                            <div>
                                <p class="text-sm font-medium text-gray-600">Status</p>
                                <?php
                                    $statusClasses = [
                                        'pending' => 'bg-yellow-100 text-yellow-800',
                                        'approved' => 'bg-green-100 text-green-800',
                                        'rejected' => 'bg-red-100 text-red-800',
                                    ];
                                ?>
                                <span
                                    class="inline-flex px-2 py-1 text-xs font-semibold rounded-full <?php echo e($statusClasses[$selectedApplication->status] ?? 'bg-gray-100 text-gray-800'); ?>">
                                    <?php echo e(ucfirst($selectedApplication->status)); ?>

                                </span>
                                <?php if($selectedApplication->academicAdvisorStatus): ?>
                                    <span class="ml-2 inline-flex px-2 py-1 text-xs font-semibold rounded-full <?php echo e($statusClasses[$selectedApplication->academicAdvisorStatus] ?? 'bg-gray-100 text-gray-800'); ?>" title="Academic Advisor Status">
                                        AA: <?php echo e(ucfirst($selectedApplication->academicAdvisorStatus)); ?>

                                    </span>
                                <?php endif; ?>
                            </div>
                            <div>
                                <p class="text-sm font-medium text-gray-600">Application Date</p>
                                <p class="text-sm text-gray-900">
                                    <?php echo e($selectedApplication->applicationDate->format('F d, Y')); ?></p>
                            </div>
                            <?php if($selectedApplication->academicAdvisorID && $selectedApplication->academicAdvisor): ?>
                                <div>
                                    <p class="text-sm font-medium text-gray-600">Academic Advisor</p>
                                    <p class="text-sm text-gray-900"><?php echo e($selectedApplication->academicAdvisor->user->name ?? $selectedApplication->academicAdvisorID); ?></p>
                                </div>
                            <?php endif; ?>
                            <?php if($selectedApplication->lecturerID && $selectedApplication->lecturer): ?>
                                <div>
                                    <p class="text-sm font-medium text-gray-600">Reviewed By Coordinator</p>
                                    <p class="text-sm text-gray-900"><?php echo e($selectedApplication->lecturer->user->name ?? $selectedApplication->lecturerID); ?></p>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>

                    <!-- Submitted File -->
                    <?php if($selectedApplication->files->count() > 0): ?>
                        <div class="bg-green-50 rounded-lg p-4">
                            <h4 class="text-md font-semibold text-gray-900 mb-3">Submitted Document</h4>
                            <div class="flex items-center justify-between">
                                <div class="flex items-center">
                                    <i class="fa fa-file text-green-600 text-xl mr-3"></i>
                                    <div>
                                        <p class="text-sm font-medium text-gray-900"><?php echo e($selectedApplication->files->first()->original_name ?? 'Course Documentation'); ?></p>
                                        <p class="text-xs text-gray-600"><?php echo e($selectedApplication->files->first()->mime_type); ?> - <?php echo e(number_format($selectedApplication->files->first()->file_size / 1024, 1)); ?> KB</p>
                                    </div>
                                </div>
                                <button wire:click="downloadFile(<?php echo e($selectedApplication->files->first()->id); ?>)"
                                    wire:loading.attr="disabled"
                                    wire:target="downloadFile(<?php echo e($selectedApplication->files->first()->id); ?>)"
                                    class="inline-flex items-center gap-2 px-4 py-2 border border-transparent rounded-lg text-sm font-medium text-white bg-green-600 hover:bg-green-700 dark:bg-green-600 dark:hover:bg-green-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-green-500 transition-colors disabled:opacity-50 disabled:cursor-not-allowed shadow-sm hover:shadow-md">
                                    <span wire:loading.remove wire:target="downloadFile(<?php echo e($selectedApplication->files->first()->id); ?>)" class="flex items-center gap-2">
                                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-4 h-4">
                                            <path stroke-linecap="round" stroke-linejoin="round" d="M3 16.5v2.25A2.25 2.25 0 0 0 5.25 21h13.5A2.25 2.25 0 0 0 21 18.75V16.5M16.5 12 12 16.5m0 0L7.5 12m4.5 4.5V3" />
                                        </svg>
                                        <span>Download File</span>
                                    </span>
                                    <span wire:loading wire:target="downloadFile(<?php echo e($selectedApplication->files->first()->id); ?>)" class="flex items-center gap-2">
                                        <?php if (isset($component)) { $__componentOriginal5c29929acf227acd7c5fa56a39e71fcc = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal5c29929acf227acd7c5fa56a39e71fcc = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.loading-spinner','data' => ['size' => 'h-4 w-4','color' => 'text-white']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('loading-spinner'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['size' => 'h-4 w-4','color' => 'text-white']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal5c29929acf227acd7c5fa56a39e71fcc)): ?>
<?php $attributes = $__attributesOriginal5c29929acf227acd7c5fa56a39e71fcc; ?>
<?php unset($__attributesOriginal5c29929acf227acd7c5fa56a39e71fcc); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal5c29929acf227acd7c5fa56a39e71fcc)): ?>
<?php $component = $__componentOriginal5c29929acf227acd7c5fa56a39e71fcc; ?>
<?php unset($__componentOriginal5c29929acf227acd7c5fa56a39e71fcc); ?>
<?php endif; ?>
                                        <span>Downloading...</span>
                                    </span>
                                </button>
                            </div>
                        </div>
                    <?php endif; ?>

                    <!-- Academic Advisor Review Section -->
                    <?php if($isAcademicAdvisor): ?>
                        <?php if($selectedApplication->academicAdvisorStatus === null): ?>
                            <div class="bg-blue-50 rounded-lg p-4 border-2 border-blue-200">
                                <h4 class="text-md font-semibold text-gray-900 mb-2">Academic Advisor Review</h4>
                                <p class="text-sm text-gray-700 mb-3">Please review this application and determine if it is eligible for coordinator approval.</p>
                            </div>
                        <?php else: ?>
                            <div class="bg-gray-50 rounded-lg p-4 border border-gray-200">
                                <h4 class="text-md font-semibold text-gray-900 mb-2">Your Review History</h4>
                                <div class="space-y-2">
                                    <div class="flex items-center gap-2">
                                        <span class="text-sm font-medium text-gray-700">Review Status:</span>
                                        <?php if($selectedApplication->academicAdvisorStatus === 'approved'): ?>
                                            <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full bg-green-100 text-green-800">
                                                <i class="fa fa-check mr-1"></i>Marked as Eligible
                                            </span>
                                        <?php else: ?>
                                            <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full bg-red-100 text-red-800">
                                                <i class="fa fa-times mr-1"></i>Marked as Ineligible
                                            </span>
                                        <?php endif; ?>
                                    </div>
                                    <?php if($selectedApplication->academicAdvisor): ?>
                                        <div class="flex items-center gap-2">
                                            <span class="text-sm font-medium text-gray-700">Reviewed By:</span>
                                            <span class="text-sm text-gray-900"><?php echo e($selectedApplication->academicAdvisor->user->name ?? $selectedApplication->academicAdvisorID); ?></span>
                                        </div>
                                    <?php endif; ?>
                                    <?php if($selectedApplication->academicAdvisorStatus === 'approved' && $selectedApplication->status): ?>
                                        <div class="flex items-center gap-2">
                                            <span class="text-sm font-medium text-gray-700">Coordinator Status:</span>
                                            <?php if($selectedApplication->status === 'approved'): ?>
                                                <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full bg-green-100 text-green-800">
                                                    Approved
                                                </span>
                                            <?php elseif($selectedApplication->status === 'rejected'): ?>
                                                <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full bg-red-100 text-red-800">
                                                    Rejected
                                                </span>
                                            <?php else: ?>
                                                <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full bg-yellow-100 text-yellow-800">
                                                    Pending Review
                                                </span>
                                            <?php endif; ?>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php endif; ?>
                    <?php endif; ?>

                    <!-- Coordinator Review Section -->
                    <?php if($isCoordinator): ?>
                        <?php if($selectedApplication->status === 'pending' && $selectedApplication->academicAdvisorStatus === 'approved'): ?>
                            <div class="bg-blue-50 rounded-lg p-4 border-2 border-blue-200">
                                <h4 class="text-md font-semibold text-gray-900 mb-2">Coordinator Review</h4>
                                <p class="text-sm text-gray-700 mb-3">This application has been approved by the academic advisor. Please review and make a final decision.</p>
                            </div>
                        <?php elseif($selectedApplication->status !== 'pending' && $selectedApplication->academicAdvisorStatus === 'approved'): ?>
                            <div class="bg-gray-50 rounded-lg p-4 border border-gray-200">
                                <h4 class="text-md font-semibold text-gray-900 mb-2">Your Review History</h4>
                                <div class="space-y-2">
                                    <div class="flex items-center gap-2">
                                        <span class="text-sm font-medium text-gray-700">Review Status:</span>
                                        <?php if($selectedApplication->status === 'approved'): ?>
                                            <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full bg-green-100 text-green-800">
                                                <i class="fa fa-check mr-1"></i>Approved
                                            </span>
                                        <?php else: ?>
                                            <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full bg-red-100 text-red-800">
                                                <i class="fa fa-times mr-1"></i>Rejected
                                            </span>
                                        <?php endif; ?>
                                    </div>
                                    <?php if($selectedApplication->lecturer): ?>
                                        <div class="flex items-center gap-2">
                                            <span class="text-sm font-medium text-gray-700">Reviewed By:</span>
                                            <span class="text-sm text-gray-900"><?php echo e($selectedApplication->lecturer->user->name ?? $selectedApplication->lecturerID); ?></span>
                                        </div>
                                    <?php endif; ?>
                                    <?php if($selectedApplication->academicAdvisor): ?>
                                        <div class="flex items-center gap-2">
                                            <span class="text-sm font-medium text-gray-700">Academic Advisor:</span>
                                            <span class="text-sm text-gray-900"><?php echo e($selectedApplication->academicAdvisor->user->name ?? $selectedApplication->academicAdvisorID); ?></span>
                                            <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full bg-green-100 text-green-800 ml-2">
                                                Approved
                                            </span>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php endif; ?>
                    <?php endif; ?>

                    <!-- Remarks Section -->
                    <?php if(($isAcademicAdvisor && $selectedApplication->academicAdvisorStatus === null) || ($isCoordinator && $selectedApplication->status === 'pending' && $selectedApplication->academicAdvisorStatus === 'approved')): ?>
                        <div class="bg-yellow-50 rounded-lg p-4">
                            <h4 class="text-md font-semibold text-gray-900 mb-3">Review Remarks</h4>
                            <div>
                                <label for="remarks" class="block text-sm font-medium text-gray-700 mb-2">
                                    <?php if($isAcademicAdvisor): ?>
                                        Add remarks for eligibility review <?php echo e($selectedApplication->academicAdvisorStatus === null ? '(required for rejection)' : '(optional)'); ?>:
                                    <?php else: ?>
                                        Add remarks for this application <?php echo e($selectedApplication->status === 'pending' ? '(required for rejection)' : '(optional)'); ?>:
                                    <?php endif; ?>
                                </label>
                                <textarea wire:model="remarks" id="remarks" rows="4"
                                    class="block w-full border border-gray-300 rounded-md px-3 py-2 focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500"
                                    placeholder="Enter your comments, feedback, or reasons for your decision..."></textarea>
                                <p class="text-xs text-gray-500 mt-1">
                                    <?php if($isAcademicAdvisor): ?>
                                        These remarks will be visible to the coordinator and student.
                                    <?php else: ?>
                                        These remarks will be visible to the student after you approve or reject their application.
                                    <?php endif; ?>
                                </p>
                            </div>
                        </div>
                    <?php elseif($selectedApplication->remarks): ?>
                        <div class="bg-gray-50 rounded-lg p-4">
                            <h4 class="text-md font-semibold text-gray-900 mb-3">
                                <?php if($isAcademicAdvisor && $selectedApplication->academicAdvisorStatus): ?>
                                    Your Remarks
                                <?php elseif($isCoordinator && $selectedApplication->status !== 'pending'): ?>
                                    Your Remarks
                                <?php else: ?>
                                    Lecturer Remarks
                                <?php endif; ?>
                            </h4>
                            <div class="bg-white border rounded-md p-3">
                                <p class="text-sm text-gray-900 whitespace-pre-wrap"><?php echo e($selectedApplication->remarks); ?></p>
                            </div>
                            <p class="text-xs text-gray-500 mt-1">
                                <?php if($isAcademicAdvisor && $selectedApplication->academicAdvisorStatus): ?>
                                    Reviewed by: <?php echo e($selectedApplication->academicAdvisor->user->name ?? $selectedApplication->academicAdvisorID); ?>

                                <?php elseif($isCoordinator && $selectedApplication->status !== 'pending'): ?>
                                    Reviewed by: <?php echo e($selectedApplication->lecturer->user->name ?? $selectedApplication->lecturerID); ?>

                                <?php else: ?>
                                    Reviewed by: <?php echo e($selectedApplication->lecturer->user->name ?? $selectedApplication->lecturerID); ?>

                                <?php endif; ?>
                            </p>
                        </div>
                    <?php endif; ?>
                </div>

                <!-- Action Buttons -->
                <?php if(($isAcademicAdvisor && $selectedApplication->academicAdvisorStatus === null) || ($isCoordinator && $selectedApplication->status === 'pending' && $selectedApplication->academicAdvisorStatus === 'approved')): ?>
                    <div class="px-6 py-4 border-t border-gray-200 dark:border-gray-700 flex justify-end space-x-3">
                        <button type="button" wire:click="closeDetailModal"
                            class="inline-flex items-center gap-2 px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-lg text-sm font-medium text-gray-700 dark:text-gray-300 bg-white dark:bg-gray-800 hover:bg-gray-50 dark:hover:bg-gray-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-purple-500 transition-colors">
                            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-4 h-4">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M6 18 18 6M6 6l12 12" />
                            </svg>
                            <span>Cancel</span>
                        </button>
                        <button type="button"
                            wire:click="rejectApplication(<?php echo e($selectedApplication->courseVerificationID); ?>)"
                            wire:confirm="Are you sure you want to reject this application?"
                            wire:loading.attr="disabled"
                            wire:target="rejectApplication(<?php echo e($selectedApplication->courseVerificationID); ?>)"
                            class="inline-flex items-center gap-2 px-4 py-2 border border-transparent rounded-lg text-sm font-medium text-white bg-red-600 hover:bg-red-700 dark:bg-red-600 dark:hover:bg-red-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-500 disabled:opacity-50 disabled:cursor-not-allowed transition-colors">
                            <span wire:loading.remove wire:target="rejectApplication(<?php echo e($selectedApplication->courseVerificationID); ?>)" class="flex items-center gap-2">
                                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-4 h-4">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M6 18 18 6M6 6l12 12" />
                                </svg>
                                <span>
                                    <?php if($isAcademicAdvisor): ?>
                                        Mark as Ineligible
                                    <?php else: ?>
                                        Reject
                                    <?php endif; ?>
                                </span>
                            </span>
                            <span wire:loading wire:target="rejectApplication(<?php echo e($selectedApplication->courseVerificationID); ?>)" class="flex items-center gap-2">
                                <?php if (isset($component)) { $__componentOriginal5c29929acf227acd7c5fa56a39e71fcc = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal5c29929acf227acd7c5fa56a39e71fcc = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.loading-spinner','data' => ['size' => 'h-4 w-4','color' => 'text-white']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('loading-spinner'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['size' => 'h-4 w-4','color' => 'text-white']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal5c29929acf227acd7c5fa56a39e71fcc)): ?>
<?php $attributes = $__attributesOriginal5c29929acf227acd7c5fa56a39e71fcc; ?>
<?php unset($__attributesOriginal5c29929acf227acd7c5fa56a39e71fcc); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal5c29929acf227acd7c5fa56a39e71fcc)): ?>
<?php $component = $__componentOriginal5c29929acf227acd7c5fa56a39e71fcc; ?>
<?php unset($__componentOriginal5c29929acf227acd7c5fa56a39e71fcc); ?>
<?php endif; ?>
                                <span>
                                    <?php if($isAcademicAdvisor): ?>
                                        Marking as Ineligible...
                                    <?php else: ?>
                                        Rejecting...
                                    <?php endif; ?>
                                </span>
                            </span>
                        </button>
                        <button type="button"
                            wire:click="approveApplication(<?php echo e($selectedApplication->courseVerificationID); ?>)"
                            wire:confirm="Are you sure you want to approve this application?"
                            wire:loading.attr="disabled"
                            wire:target="approveApplication(<?php echo e($selectedApplication->courseVerificationID); ?>)"
                            class="inline-flex items-center gap-2 px-4 py-2 border border-transparent rounded-lg text-sm font-medium text-white bg-green-600 hover:bg-green-700 dark:bg-green-600 dark:hover:bg-green-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-green-500 disabled:opacity-50 disabled:cursor-not-allowed transition-colors">
                            <span wire:loading.remove wire:target="approveApplication(<?php echo e($selectedApplication->courseVerificationID); ?>)" class="flex items-center gap-2">
                                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-4 h-4">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M4.5 12.75l6 6 9-13.5" />
                                </svg>
                                <span>
                                    <?php if($isAcademicAdvisor): ?>
                                        Mark as Eligible
                                    <?php else: ?>
                                        Approve
                                    <?php endif; ?>
                                </span>
                            </span>
                            <span wire:loading wire:target="approveApplication(<?php echo e($selectedApplication->courseVerificationID); ?>)" class="flex items-center gap-2">
                                <?php if (isset($component)) { $__componentOriginal5c29929acf227acd7c5fa56a39e71fcc = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal5c29929acf227acd7c5fa56a39e71fcc = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.loading-spinner','data' => ['size' => 'h-4 w-4','color' => 'text-white']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('loading-spinner'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['size' => 'h-4 w-4','color' => 'text-white']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal5c29929acf227acd7c5fa56a39e71fcc)): ?>
<?php $attributes = $__attributesOriginal5c29929acf227acd7c5fa56a39e71fcc; ?>
<?php unset($__attributesOriginal5c29929acf227acd7c5fa56a39e71fcc); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal5c29929acf227acd7c5fa56a39e71fcc)): ?>
<?php $component = $__componentOriginal5c29929acf227acd7c5fa56a39e71fcc; ?>
<?php unset($__componentOriginal5c29929acf227acd7c5fa56a39e71fcc); ?>
<?php endif; ?>
                                <span>
                                    <?php if($isAcademicAdvisor): ?>
                                        Marking as Eligible...
                                    <?php else: ?>
                                        Approving...
                                    <?php endif; ?>
                                </span>
                            </span>
                        </button>
                    </div>
                <?php else: ?>
                    <div class="px-6 py-4 border-t border-gray-200 flex justify-end">
                        <button type="button" wire:click="closeDetailModal"
                            class="px-4 py-2 border border-gray-300 rounded-md text-sm font-medium text-gray-700 bg-white hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                            Close
                        </button>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    <?php endif; ?>
</div><?php /**PATH C:\Users\User\Desktop\Laravel\Internlink\resources\views\livewire\lecturer-course-verification-table.blade.php ENDPATH**/ ?>