<div>
    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">

            <!-- Statistics Cards -->
            <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-8">
                <div class="bg-white rounded-lg shadow p-6">
                    <div class="flex items-center">
                        <div class="p-3 rounded-full bg-blue-100">
                            <span class="text-blue-600 text-xl">👥</span>
                        </div>
                        <div class="ml-4">
                            <p class="text-sm font-medium text-gray-600">Total Eligible</p>
                            <p class="text-2xl font-bold text-gray-900"><?php echo e($stats['total_eligible']); ?></p>
                        </div>
                    </div>
                </div>

                <div class="bg-white rounded-lg shadow p-6">
                    <div class="flex items-center">
                        <div class="p-3 rounded-full bg-green-100">
                            <span class="text-green-600 text-xl">✅</span>
                        </div>
                        <div class="ml-4">
                            <p class="text-sm font-medium text-gray-600">Assigned</p>
                            <p class="text-2xl font-bold text-gray-900"><?php echo e($stats['assigned']); ?></p>
                        </div>
                    </div>
                </div>

                <div class="bg-white rounded-lg shadow p-6">
                    <div class="flex items-center">
                        <div class="p-3 rounded-full bg-yellow-100">
                            <span class="text-yellow-600 text-xl">⏳</span>
                        </div>
                        <div class="ml-4">
                            <p class="text-sm font-medium text-gray-600">Unassigned</p>
                            <p class="text-2xl font-bold text-gray-900"><?php echo e($stats['unassigned']); ?></p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Flash Messages -->
            <?php if(session()->has('success')): ?>
                <div class="bg-green-50 border border-green-200 rounded-lg p-4 mb-6">
                    <p class="text-green-700"><?php echo e(session('success')); ?></p>
                </div>
            <?php endif; ?>

            <?php if(session()->has('error')): ?>
                <div class="bg-red-50 border border-red-200 rounded-lg p-4 mb-6">
                    <p class="text-red-700"><?php echo e(session('error')); ?></p>
                </div>
            <?php endif; ?>

            <!-- Main Content Card -->
            <div class="bg-white shadow rounded-lg">
                <!-- Header -->
                <div class="px-6 py-4 border-b border-gray-200">
                    <h2 class="text-lg font-medium text-gray-900">Students Requiring Supervisor Assignment</h2>
                </div>

                <!-- Bulk Actions Bar -->
                <?php if(count($selectedStudents) > 0 || $isBulkAssigning): ?>
                    <div class="px-6 py-3 border-b border-gray-200 bg-blue-50">
                        <div class="flex items-center justify-between">
                            <div class="flex items-center space-x-4">
                                <span class="text-sm font-medium text-gray-700">
                                    <?php echo e(count($selectedStudents)); ?> student(s) selected
                                </span>
                                <?php if($isBulkAssigning): ?>
                                    <div class="flex items-center space-x-2">
                                        <div class="w-48 bg-gray-200 rounded-full h-2">
                                            <div class="bg-blue-600 h-2 rounded-full transition-all duration-300"
                                                 style="width: <?php echo e($bulkAssignTotal > 0 ? ($bulkAssignProgress / $bulkAssignTotal * 100) : 0); ?>%"></div>
                                        </div>
                                        <span class="text-xs text-gray-600">
                                            <?php echo e($bulkAssignProgress); ?> / <?php echo e($bulkAssignTotal); ?>

                                        </span>
                                    </div>
                                <?php endif; ?>
                            </div>
                            <div class="flex items-center space-x-2">
                                <button wire:click="clearSelection"
                                        class="px-3 py-1 text-sm text-gray-700 hover:text-gray-900">
                                    Clear Selection
                                </button>
                                <button wire:click="bulkAutoAssign"
                                        wire:loading.attr="disabled"
                                        wire:target="bulkAutoAssign"
                                        <?php if($isBulkAssigning): ?> disabled <?php endif; ?>
                                        class="px-4 py-2 bg-green-600 text-white text-sm font-medium rounded-md hover:bg-green-700 disabled:bg-gray-400 disabled:cursor-not-allowed">
                                    <span wire:loading.remove wire:target="bulkAutoAssign">Bulk Auto Assign</span>
                                    <span wire:loading wire:target="bulkAutoAssign">Assigning...</span>
                                </button>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>

                <!-- Advanced Filters -->
                <div class="px-6 py-4 border-b border-gray-200 bg-gray-50">
                    <div class="grid grid-cols-1 md:grid-cols-7 gap-4">
                        <!-- Search -->
                        <div class="md:col-span-2">
                            <input type="text" wire:model.live.debounce.300ms="search"
                                class="w-full border border-gray-300 rounded-md px-3 py-2 text-sm"
                                placeholder="Search by student ID, name, email, or company...">
                        </div>

                        <!-- Assignment Type Filter -->
                        <div>
                            <select wire:model.live="assignmentTypeFilter"
                                class="w-full border border-gray-300 rounded-md px-3 py-2 text-sm">
                                <option value="unassigned">Unassigned Only</option>
                                <option value="assigned">Assigned Only</option>
                                <option value="all">All Students</option>
                            </select>
                        </div>

                        <!-- Program Filter -->
                        <div>
                            <select wire:model.live="program"
                                class="w-full border border-gray-300 rounded-md px-3 py-2 text-sm">
                                <option value="">All Programs</option>
                                <option value="BCS">Bachelor of Computer Science (Software Engineering) with Honours</option>
                                <option value="BCN">Bachelor of Computer Science (Computer Systems & Networking) with Honours</option>
                                <option value="BCM">Bachelor of Computer Science (Multimedia Software) with Honours</option>
                                <option value="BCY">Bachelor of Computer Science (Cyber Security) with Honours</option>
                                <option value="DRC">Diploma in Computer Science</option>
                            </select>
                        </div>

                        <!-- Semester Filter -->
                        <div>
                            <select wire:model.live="semesterFilter"
                                class="w-full border border-gray-300 rounded-md px-3 py-2 text-sm">
                                <option value="">All Semesters</option>
                                <?php $__currentLoopData = $availableSemesters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $semester): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($semester); ?>">Semester <?php echo e($semester); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <!-- Year Filter -->
                        <div>
                            <select wire:model.live="yearFilter"
                                class="w-full border border-gray-300 rounded-md px-3 py-2 text-sm">
                                <option value="">All Years</option>
                                <?php $__currentLoopData = $availableYears; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $year): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($year); ?>"><?php echo e($year); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <!-- Per Page -->
                        <div>
                            <select wire:model.live="perPage"
                                class="w-full border border-gray-300 rounded-md px-3 py-2 text-sm">
                                <option value="10">10 per page</option>
                                <option value="25">25 per page</option>
                                <option value="50">50 per page</option>
                            </select>
                        </div>
                    </div>
                </div>

                <!-- Students Table -->
                <div class="overflow-x-auto">
                    <table class="min-w-full divide-y divide-gray-200">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    <label class="flex items-center cursor-pointer">
                                        <?php
                                            // Only count unassigned students for select all
                                            $unassignedStudentIDs = $students->filter(function ($student) {
                                                return !$student->supervisorAssignment ||
                                                       $student->supervisorAssignment->status !== \App\Models\SupervisorAssignment::STATUS_ASSIGNED;
                                            })->pluck('studentID')->toArray();
                                            $selectedUnassigned = array_intersect($selectedStudents, $unassignedStudentIDs);
                                            $allUnassignedSelected = !empty($unassignedStudentIDs) &&
                                                count($selectedUnassigned) === count($unassignedStudentIDs);
                                        ?>
                                        <input type="checkbox"
                                               <?php if($allUnassignedSelected): ?> checked <?php endif; ?>
                                               wire:click="toggleSelectAll"
                                               class="rounded border-gray-300 text-indigo-600 focus:ring-indigo-500">
                                        <span class="ml-2">Select</span>
                                    </label>
                                </th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider cursor-pointer"
                                    wire:click="sortBy('studentID')">
                                    Student ID
                                    <?php if($sortField === 'studentID'): ?>
                                        <?php if($sortDirection === 'asc'): ?> ↑ <?php else: ?> ↓ <?php endif; ?>
                                    <?php endif; ?>
                                </th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    Student Name
                                </th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    Company
                                </th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    Supervisor
                                </th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider cursor-pointer"
                                    wire:click="sortBy('assigned_at')">
                                    Assigned Date
                                    <?php if($sortField === 'assigned_at'): ?>
                                        <?php if($sortDirection === 'asc'): ?> ↑ <?php else: ?> ↓ <?php endif; ?>
                                    <?php endif; ?>
                                </th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    Actions
                                </th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            <?php $__empty_1 = true; $__currentLoopData = $students; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <?php
                                    $hasAssignment = $student->supervisorAssignment &&
                                                     $student->supervisorAssignment->status === \App\Models\SupervisorAssignment::STATUS_ASSIGNED;
                                    $canSelect = !$hasAssignment;
                                ?>
                                <tr class="hover:bg-gray-50 <?php echo e($this->isStudentSelected($student->studentID) ? 'bg-blue-50' : ''); ?> <?php echo e(!$canSelect ? 'opacity-60' : ''); ?>">
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <input type="checkbox"
                                               <?php if($this->isStudentSelected($student->studentID)): ?> checked <?php endif; ?>
                                               <?php if(!$canSelect): ?> disabled <?php endif; ?>
                                               wire:click="toggleStudentSelection('<?php echo e($student->studentID); ?>')"
                                               class="rounded border-gray-300 text-indigo-600 focus:ring-indigo-500 disabled:opacity-50 disabled:cursor-not-allowed"
                                               title="<?php echo e($canSelect ? 'Select for bulk auto-assignment' : 'Student already has a supervisor assigned'); ?>">
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">
                                        <?php echo e($student->studentID); ?>

                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <div class="text-sm font-medium text-gray-900"><?php echo e($student->user->name); ?></div>
                                        <div class="text-sm text-gray-500"><?php echo e($student->user->email); ?></div>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <?php if($student->acceptedPlacementApplication): ?>
                                            <div class="text-sm text-gray-900"><?php echo e($student->acceptedPlacementApplication->companyName); ?></div>
                                            <div class="text-sm text-gray-500"><?php echo e($student->acceptedPlacementApplication->companyCity); ?>, <?php echo e($student->acceptedPlacementApplication->companyState); ?></div>
                                        <?php else: ?>
                                            <span class="text-sm text-gray-400">N/A</span>
                                        <?php endif; ?>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <?php if($student->supervisorAssignment && $student->supervisorAssignment->supervisor): ?>
                                            <div class="flex items-center">
                                                <div>
                                                    <div class="text-sm font-medium text-gray-900"><?php echo e($student->supervisorAssignment->supervisor->user->name); ?></div>
                                                    <div class="text-sm text-gray-500"><?php echo e($student->supervisorAssignment->supervisor->lecturerID); ?></div>
                                                    <?php if($student->supervisorAssignment->distance_km): ?>
                                                        <div class="text-xs text-gray-400">Distance: <?php echo e(number_format($student->supervisorAssignment->distance_km, 2)); ?> km</div>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        <?php else: ?>
                                            <span class="text-sm text-yellow-600 font-medium">Unassigned</span>
                                        <?php endif; ?>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                        <?php if($student->supervisorAssignment): ?>
                                            <?php echo e($student->supervisorAssignment->assigned_at->format('Y-m-d')); ?>

                                        <?php else: ?>
                                            <span class="text-gray-400">-</span>
                                        <?php endif; ?>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                                        <div class="flex items-center space-x-2">
                                            <?php if(!$student->supervisorAssignment): ?>
                                                <button wire:click="openAssignModal('<?php echo e($student->studentID); ?>')"
                                                    class="inline-flex items-center gap-1.5 px-2.5 py-1.5 text-sm font-medium text-blue-700 bg-blue-50 hover:bg-blue-100 dark:bg-blue-900/20 dark:text-blue-400 dark:hover:bg-blue-900/30 rounded-lg transition-colors">
                                                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-4 h-4">
                                                        <path stroke-linecap="round" stroke-linejoin="round" d="M18 7.5v3m0 0v3m0-3h3m-3 0h-3m-2.25-4.125a3.375 3.375 0 1 1 6.75 0 3.375 3.375 0 0 1-6.75 0ZM3 19.235v-.11a6.375 6.375 0 0 1 12.75 0v.109A12.318 12.318 0 0 1 9.374 21c-2.331 0-4.512-.645-6.374-1.766Z" />
                                                    </svg>
                                                    <span>Assign</span>
                                                </button>
                                                <button wire:click="autoAssignSupervisor('<?php echo e($student->studentID); ?>')"
                                                    wire:loading.attr="disabled"
                                                    wire:target="autoAssignSupervisor('<?php echo e($student->studentID); ?>')"
                                                    class="inline-flex items-center gap-1.5 px-2.5 py-1.5 text-sm font-medium text-white bg-green-600 hover:bg-green-700 dark:bg-green-600 dark:hover:bg-green-700 rounded-lg transition-colors disabled:opacity-50 disabled:cursor-not-allowed">
                                                    <span wire:loading.remove wire:target="autoAssignSupervisor('<?php echo e($student->studentID); ?>')" class="flex items-center gap-1.5">
                                                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-4 h-4">
                                                            <path stroke-linecap="round" stroke-linejoin="round" d="M9 12.75 11.25 15 15 9.75M21 12a9 9 0 1 1-18 0 9 9 0 0 1 18 0Z" />
                                                        </svg>
                                                        <span>Auto Assign</span>
                                                    </span>
                                                    <span wire:loading wire:target="autoAssignSupervisor('<?php echo e($student->studentID); ?>')" class="flex items-center gap-1.5">
                                                        <?php if (isset($component)) { $__componentOriginal5c29929acf227acd7c5fa56a39e71fcc = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal5c29929acf227acd7c5fa56a39e71fcc = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.loading-spinner','data' => ['size' => 'h-4 w-4','color' => 'text-white']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('loading-spinner'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['size' => 'h-4 w-4','color' => 'text-white']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal5c29929acf227acd7c5fa56a39e71fcc)): ?>
<?php $attributes = $__attributesOriginal5c29929acf227acd7c5fa56a39e71fcc; ?>
<?php unset($__attributesOriginal5c29929acf227acd7c5fa56a39e71fcc); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal5c29929acf227acd7c5fa56a39e71fcc)): ?>
<?php $component = $__componentOriginal5c29929acf227acd7c5fa56a39e71fcc; ?>
<?php unset($__componentOriginal5c29929acf227acd7c5fa56a39e71fcc); ?>
<?php endif; ?>
                                                        <span>Assigning...</span>
                                                    </span>
                                                </button>
                                            <?php else: ?>
                                                <button wire:click="viewAssignment(<?php echo e($student->supervisorAssignment->id); ?>)"
                                                    wire:loading.attr="disabled"
                                                    wire:target="viewAssignment"
                                                    class="inline-flex items-center gap-1.5 px-2.5 py-1.5 text-sm font-medium text-indigo-700 bg-indigo-50 hover:bg-indigo-100 dark:bg-indigo-900/20 dark:text-indigo-400 dark:hover:bg-indigo-900/30 rounded-lg transition-colors disabled:opacity-50 disabled:cursor-not-allowed">
                                                    <span wire:loading.remove wire:target="viewAssignment" class="flex items-center gap-1.5">
                                                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-4 h-4">
                                                            <path stroke-linecap="round" stroke-linejoin="round" d="M2.036 12.322a1.012 1.012 0 0 1 0-.639C3.423 7.51 7.36 4.5 12 4.5c4.638 0 8.573 3.007 9.963 7.178.07.207.07.431 0 .639C20.577 16.49 16.64 19.5 12 19.5c-4.638 0-8.573-3.007-9.963-7.178Z" />
                                                            <path stroke-linecap="round" stroke-linejoin="round" d="M15 12a3 3 0 1 1-6 0 3 3 0 0 1 6 0Z" />
                                                        </svg>
                                                        <span>View</span>
                                                    </span>
                                                    <span wire:loading wire:target="viewAssignment" class="flex items-center gap-1.5">
                                                        <?php if (isset($component)) { $__componentOriginal5c29929acf227acd7c5fa56a39e71fcc = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal5c29929acf227acd7c5fa56a39e71fcc = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.loading-spinner','data' => ['size' => 'h-4 w-4','color' => 'text-indigo-600 dark:text-indigo-400']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('loading-spinner'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['size' => 'h-4 w-4','color' => 'text-indigo-600 dark:text-indigo-400']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal5c29929acf227acd7c5fa56a39e71fcc)): ?>
<?php $attributes = $__attributesOriginal5c29929acf227acd7c5fa56a39e71fcc; ?>
<?php unset($__attributesOriginal5c29929acf227acd7c5fa56a39e71fcc); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal5c29929acf227acd7c5fa56a39e71fcc)): ?>
<?php $component = $__componentOriginal5c29929acf227acd7c5fa56a39e71fcc; ?>
<?php unset($__componentOriginal5c29929acf227acd7c5fa56a39e71fcc); ?>
<?php endif; ?>
                                                    </span>
                                                </button>
                                                <button wire:click="openEditModal(<?php echo e($student->supervisorAssignment->id); ?>)"
                                                    class="inline-flex items-center gap-1.5 px-2.5 py-1.5 text-sm font-medium text-yellow-700 bg-yellow-50 hover:bg-yellow-100 dark:bg-yellow-900/20 dark:text-yellow-400 dark:hover:bg-yellow-900/30 rounded-lg transition-colors">
                                                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-4 h-4">
                                                        <path stroke-linecap="round" stroke-linejoin="round" d="m16.862 4.487 1.687-1.688a1.875 1.875 0 1 1 2.652 2.652L10.582 16.07a4.5 4.5 0 0 1-1.897 1.13L6 18l.8-2.685a4.5 4.5 0 0 1 1.13-1.897l8.932-8.931Zm0 0L19.5 7.125M18 14v4.75A2.25 2.25 0 0 1 15.75 21H5.25A2.25 2.25 0 0 1 3 18.75V8.25A2.25 2.25 0 0 1 5.25 6H10" />
                                                    </svg>
                                                    <span>Edit</span>
                                                </button>
                                                <button wire:click="removeAssignment(<?php echo e($student->supervisorAssignment->id); ?>)"
                                                    wire:confirm="Are you sure you want to remove this supervisor assignment?"
                                                    wire:loading.attr="disabled"
                                                    wire:target="removeAssignment(<?php echo e($student->supervisorAssignment->id); ?>)"
                                                    class="inline-flex items-center gap-1.5 px-2.5 py-1.5 text-sm font-medium text-red-700 bg-red-50 hover:bg-red-100 dark:bg-red-900/20 dark:text-red-400 dark:hover:bg-red-900/30 rounded-lg transition-colors disabled:opacity-50 disabled:cursor-not-allowed">
                                                    <span wire:loading.remove wire:target="removeAssignment(<?php echo e($student->supervisorAssignment->id); ?>)" class="flex items-center gap-1.5">
                                                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-4 h-4">
                                                            <path stroke-linecap="round" stroke-linejoin="round" d="m14.74 9-.346 9m-4.788 0L9.26 9m9.968-3.21c.342.052.682.107 1.022.166m-1.022-.165L18.16 19.673a2.25 2.25 0 0 1-2.244 2.077H8.084a2.25 2.25 0 0 1-2.244-2.077L4.772 5.79m14.456 0a48.108 48.108 0 0 0-3.478-.397m-12 .562c.34-.059.68-.114 1.022-.165m0 0a48.11 48.11 0 0 1 3.478-.397m7.5 0v-.916c0-1.18-.91-2.164-2.09-2.201a51.964 51.964 0 0 0-3.32 0c-1.18.037-2.09 1.022-2.09 2.201v.916m7.5 0a48.667 48.667 0 0 0-7.5 0" />
                                                        </svg>
                                                        <span>Remove</span>
                                                    </span>
                                                    <span wire:loading wire:target="removeAssignment(<?php echo e($student->supervisorAssignment->id); ?>)" class="flex items-center gap-1.5">
                                                        <?php if (isset($component)) { $__componentOriginal5c29929acf227acd7c5fa56a39e71fcc = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal5c29929acf227acd7c5fa56a39e71fcc = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.loading-spinner','data' => ['size' => 'h-4 w-4','color' => 'text-red-600 dark:text-red-400']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('loading-spinner'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['size' => 'h-4 w-4','color' => 'text-red-600 dark:text-red-400']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal5c29929acf227acd7c5fa56a39e71fcc)): ?>
<?php $attributes = $__attributesOriginal5c29929acf227acd7c5fa56a39e71fcc; ?>
<?php unset($__attributesOriginal5c29929acf227acd7c5fa56a39e71fcc); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal5c29929acf227acd7c5fa56a39e71fcc)): ?>
<?php $component = $__componentOriginal5c29929acf227acd7c5fa56a39e71fcc; ?>
<?php unset($__componentOriginal5c29929acf227acd7c5fa56a39e71fcc); ?>
<?php endif; ?>
                                                    </span>
                                                </button>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="7" class="px-6 py-4 text-center text-sm text-gray-500">
                                        No students found.
                                    </td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>

                <!-- Pagination -->
                <div class="px-6 py-4 border-t border-gray-200 dark:border-gray-700 bg-white dark:bg-gray-800">
                    <?php echo e($students->links()); ?>

                </div>
            </div>
        </div>
    </div>

    <!-- Assign Supervisor Modal -->
    <?php if($showAssignModal && $selectedStudent): ?>
        <div class="fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full z-50" wire:click="closeAssignModal">
            <div class="relative top-20 mx-auto p-5 border w-11/12 md:w-3/4 lg:w-1/2 shadow-lg rounded-md bg-white" wire:click.stop>
                <div class="mt-3">
                    <!-- Header -->
                    <div class="flex justify-between items-center mb-4">
                        <h3 class="text-lg font-medium text-gray-900">Assign Supervisor</h3>
                        <button wire:click="closeAssignModal" class="text-gray-400 hover:text-gray-500">
                            <span class="text-2xl">&times;</span>
                        </button>
                    </div>

                    <!-- Student Info -->
                    <div class="mb-4 p-4 bg-gray-50 rounded-lg">
                        <h4 class="font-medium text-gray-900 mb-2">Student Information</h4>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-2 text-sm">
                            <p><strong>Name:</strong> <?php echo e($selectedStudent->user->name); ?></p>
                            <p><strong>ID:</strong> <?php echo e($selectedStudent->studentID); ?></p>
                            <?php if($selectedStudent->program): ?>
                                <p><strong>Program:</strong> <?php echo e($selectedStudent->program); ?></p>
                            <?php endif; ?>
                            <?php if($selectedStudent->acceptedPlacementApplication): ?>
                                <p><strong>Company:</strong> <?php echo e($selectedStudent->acceptedPlacementApplication->companyName); ?></p>
                                <p class="md:col-span-2"><strong>Location:</strong> <?php echo e($selectedStudent->acceptedPlacementApplication->companyFullAddress); ?></p>
                            <?php endif; ?>
                        </div>
                    </div>

                    <!-- Recommended Supervisors -->
                    <div class="mb-4">
                        <h4 class="font-medium text-gray-900 mb-2">Recommended Supervisors (Nearest First)</h4>

                        <div class="mb-3">
                            <label class="flex items-center">
                                <input type="checkbox" wire:model="quotaOverride" wire:change="toggleQuotaOverride"
                                    class="rounded border-gray-300 text-indigo-600 focus:ring-indigo-500">
                                <span class="ml-2 text-sm text-gray-700">Include supervisors with full quota (Override)</span>
                            </label>
                        </div>

                        <?php if(!empty($recommendedSupervisors)): ?>
                            <div class="max-h-96 overflow-y-auto border border-gray-200 rounded-lg space-y-2 p-2">
                                <?php $__currentLoopData = $recommendedSupervisors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $supervisor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $lecturer = $supervisor['lecturer'] ?? $supervisor;
                                        $score = $supervisor['score'] ?? 0;
                                        $breakdown = $supervisor['breakdown'] ?? [];
                                        $distance = $supervisor['distance_km'] ?? $supervisor['distance'] ?? null;
                                        $availableQuota = $supervisor['available_quota'] ?? 0;

                                        // Score color based on value
                                        $scorePercent = $score * 100;
                                        if ($scorePercent >= 80) $scoreColor = 'text-green-600';
                                        elseif ($scorePercent >= 60) $scoreColor = 'text-blue-600';
                                        elseif ($scorePercent >= 40) $scoreColor = 'text-yellow-600';
                                        else $scoreColor = 'text-gray-600';
                                    ?>

                                    <label class="flex items-start p-4 hover:bg-gray-50 cursor-pointer border border-gray-200 rounded-lg transition-colors <?php echo e($selectedSupervisorID == $lecturer->lecturerID ? 'bg-indigo-50 border-indigo-300' : ''); ?>">
                                        <input type="radio" name="supervisor" value="<?php echo e($lecturer->lecturerID); ?>"
                                            wire:model="selectedSupervisorID"
                                            class="mt-1 rounded border-gray-300 text-indigo-600 focus:ring-indigo-500">

                                        <div class="ml-3 flex-1">
                                            <!-- Header with name and total score -->
                                            <div class="flex justify-between items-start mb-3">
                                                <div class="flex-1">
                                                    <div class="flex items-center gap-2 mb-1">
                                                        <p class="text-sm font-semibold text-gray-900"><?php echo e($lecturer->user->name); ?></p>
                                                        <?php if($index === 0): ?>
                                                            <span class="px-2 py-0.5 text-xs font-medium bg-yellow-500 text-white rounded">Best Match</span>
                                                        <?php endif; ?>
                                                    </div>
                                                    <p class="text-xs text-gray-500">
                                                        <?php echo e($lecturer->lecturerID); ?> | <?php echo e($lecturer->department ?? 'N/A'); ?> | <?php echo e($lecturer->researchGroup ?? 'N/A'); ?>

                                                        <?php if($lecturer->program): ?>
                                                            <?php
                                                                $programCodes = [
                                                                    'Bachelor of Computer Science (Software Engineering) with Honours' => 'BCS',
                                                                    'Bachelor of Computer Science (Computer Systems & Networking) with Honours' => 'BCN',
                                                                    'Bachelor of Computer Science (Multimedia Software) with Honours' => 'BCM',
                                                                    'Bachelor of Computer Science (Cyber Security) with Honours' => 'BCY',
                                                                    'Diploma in Computer Science' => 'DRC',
                                                                ];
                                                                $programCode = $programCodes[$lecturer->program] ?? null;
                                                            ?>
                                                            <?php if($programCode): ?>
                                                                | <?php echo e($programCode); ?>

                                                            <?php endif; ?>
                                                        <?php endif; ?>
                                                    </p>
                                                </div>
                                                <div class="text-right ml-4">
                                                    <div class="text-2xl font-bold <?php echo e($scoreColor); ?>"><?php echo e(number_format($score * 100, 1)); ?>%</div>
                                                    <div class="text-xs text-gray-500">Total Score</div>
                                                </div>
                                            </div>

                                            <!-- Score Breakdown -->
                                            <?php if(!empty($breakdown)): ?>
                                                <div class="grid grid-cols-4 gap-2 mb-3">
                                                    <div class="bg-blue-50 rounded p-2 border border-blue-100">
                                                        <div class="text-xs text-gray-600 mb-0.5">Course Match</div>
                                                        <div class="text-sm font-bold text-blue-600"><?php echo e(number_format(($breakdown['course_match']['raw'] ?? 0) * 100)); ?>%</div>
                                                        <div class="text-xs text-gray-500">(<?php echo e($breakdown['course_match']['weight'] ?? '0%'); ?>)</div>
                                                    </div>
                                                    <div class="bg-green-50 rounded p-2 border border-green-100">
                                                        <div class="text-xs text-gray-600 mb-0.5">Travel Prefer</div>
                                                        <div class="text-sm font-bold text-green-600"><?php echo e(number_format(($breakdown['preference_match']['raw'] ?? 0) * 100)); ?>%</div>
                                                        <div class="text-xs text-gray-500">(<?php echo e($breakdown['preference_match']['weight'] ?? '0%'); ?>)</div>
                                                    </div>
                                                    <div class="bg-purple-50 rounded p-2 border border-purple-100">
                                                        <div class="text-xs text-gray-600 mb-0.5">Distance</div>
                                                        <div class="text-sm font-bold text-purple-600"><?php echo e(number_format(($breakdown['distance_score']['raw'] ?? 0) * 100, 1)); ?>%</div>
                                                        <div class="text-xs text-gray-500">(<?php echo e($breakdown['distance_score']['weight'] ?? '0%'); ?>)</div>
                                                    </div>
                                                    <div class="bg-orange-50 rounded p-2 border border-orange-100">
                                                        <div class="text-xs text-gray-600 mb-0.5">Workload</div>
                                                        <div class="text-sm font-bold text-orange-600"><?php echo e(number_format(($breakdown['workload_score']['raw'] ?? 0) * 100)); ?>%</div>
                                                        <div class="text-xs text-gray-500">(<?php echo e($breakdown['workload_score']['weight'] ?? '0%'); ?>)</div>
                                                    </div>
                                                </div>
                                            <?php endif; ?>

                                            <!-- Additional Info -->
                                            <div class="flex flex-wrap gap-3 text-xs text-gray-600">
                                                <?php if($distance !== null): ?>
                                                    <div class="flex items-center">
                                                        <svg class="w-3.5 h-3.5 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"></path>
                                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                                        </svg>
                                                        <strong>Distance:</strong> <?php echo e(number_format($distance, 2)); ?> km
                                                    </div>
                                                <?php endif; ?>
                                                <div class="flex items-center">
                                                    <svg class="w-3.5 h-3.5 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"></path>
                                                    </svg>
                                                    <strong>Quota:</strong> <?php echo e($lecturer->current_assignments); ?>/<?php echo e($lecturer->supervisor_quota); ?>

                                                    <?php if($availableQuota > 0): ?>
                                                        <span class="text-green-600 ml-1">(<?php echo e($availableQuota); ?> available)</span>
                                                    <?php else: ?>
                                                        <span class="text-red-600 ml-1">(Full)</span>
                                                    <?php endif; ?>
                                                </div>
                                                <div class="flex items-center">
                                                    <svg class="w-3.5 h-3.5 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                                    </svg>
                                                    <strong>Travel:</strong> <?php echo e(ucfirst($lecturer->travel_preference ?? 'N/A')); ?>

                                                </div>
                                            </div>
                                        </div>
                                    </label>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        <?php else: ?>
                            <div class="p-4 bg-yellow-50 border border-yellow-200 rounded-lg">
                                <p class="text-sm text-yellow-800">No available supervisors found. Please check quota settings or enable override.</p>
                            </div>
                        <?php endif; ?>
                    </div>

                    <!-- Override Reason -->
                    <?php if($quotaOverride): ?>
                        <div class="mb-4">
                            <label class="block text-sm font-medium text-gray-700 mb-1">
                                Override Reason <span class="text-red-500">*</span>
                            </label>
                            <textarea wire:model="overrideReason" rows="3"
                                class="w-full border border-gray-300 rounded-md px-3 py-2 text-sm"
                                placeholder="Explain why you need to override the quota limit..."></textarea>
                            <?php $__errorArgs = ['overrideReason'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500 text-xs"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    <?php endif; ?>

                    <!-- Assignment Notes -->
                    <div class="mb-4">
                        <label class="block text-sm font-medium text-gray-700 mb-1">
                            Assignment Notes (Optional)
                        </label>
                        <textarea wire:model="assignmentNotes" rows="3"
                            class="w-full border border-gray-300 rounded-md px-3 py-2 text-sm"
                            placeholder="Add any notes about this assignment..."></textarea>
                    </div>

                    <!-- Validation Errors -->
                    <?php $__errorArgs = ['selectedSupervisorID'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="mb-4 p-3 bg-red-50 border border-red-200 rounded-lg">
                            <p class="text-sm text-red-800"><?php echo e($message); ?></p>
                        </div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                    <!-- Actions -->
                    <div class="flex justify-end space-x-3">
                        <button wire:click="closeAssignModal"
                            class="inline-flex items-center gap-2 px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-lg text-sm font-medium text-gray-700 dark:text-gray-300 bg-white dark:bg-gray-800 hover:bg-gray-50 dark:hover:bg-gray-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-purple-500 transition-colors">
                            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-4 h-4">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M6 18 18 6M6 6l12 12" />
                            </svg>
                            <span>Cancel</span>
                        </button>
                        <button wire:click="assignSupervisor"
                            wire:loading.attr="disabled"
                            wire:target="assignSupervisor"
                            class="inline-flex items-center gap-2 px-4 py-2 border border-transparent rounded-lg text-sm font-medium text-white bg-indigo-600 hover:bg-indigo-700 dark:bg-indigo-600 dark:hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500 disabled:opacity-50 disabled:cursor-not-allowed transition-colors shadow-sm hover:shadow-md">
                            <span wire:loading.remove wire:target="assignSupervisor" class="flex items-center gap-2">
                                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-4 h-4">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M18 7.5v3m0 0v3m0-3h3m-3 0h-3m-2.25-4.125a3.375 3.375 0 1 1 6.75 0 3.375 3.375 0 0 1-6.75 0ZM3 19.235v-.11a6.375 6.375 0 0 1 12.75 0v.109A12.318 12.318 0 0 1 9.374 21c-2.331 0-4.512-.645-6.374-1.766Z" />
                                </svg>
                                <span>Assign Supervisor</span>
                            </span>
                            <span wire:loading wire:target="assignSupervisor" class="flex items-center gap-2">
                                <?php if (isset($component)) { $__componentOriginal5c29929acf227acd7c5fa56a39e71fcc = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal5c29929acf227acd7c5fa56a39e71fcc = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.loading-spinner','data' => ['size' => 'h-4 w-4','color' => 'text-white']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('loading-spinner'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['size' => 'h-4 w-4','color' => 'text-white']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal5c29929acf227acd7c5fa56a39e71fcc)): ?>
<?php $attributes = $__attributesOriginal5c29929acf227acd7c5fa56a39e71fcc; ?>
<?php unset($__attributesOriginal5c29929acf227acd7c5fa56a39e71fcc); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal5c29929acf227acd7c5fa56a39e71fcc)): ?>
<?php $component = $__componentOriginal5c29929acf227acd7c5fa56a39e71fcc; ?>
<?php unset($__componentOriginal5c29929acf227acd7c5fa56a39e71fcc); ?>
<?php endif; ?>
                                <span>Assigning...</span>
                            </span>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <!-- Edit Assignment Modal -->
    <?php if($showEditModal && $editAssignmentID): ?>
        <div class="fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full z-50" wire:click="closeEditModal">
            <div class="relative top-20 mx-auto p-5 border w-11/12 md:w-3/4 lg:w-1/2 shadow-lg rounded-md bg-white" wire:click.stop>
                <div class="mt-3">
                    <!-- Header -->
                    <div class="flex justify-between items-center mb-4">
                        <h3 class="text-lg font-medium text-gray-900">Edit Supervisor Assignment</h3>
                        <button wire:click="closeEditModal" class="text-gray-400 hover:text-gray-500">
                            <span class="text-2xl">&times;</span>
                        </button>
                    </div>

                    <!-- Instructions -->
                    <div class="mb-4 p-4 bg-blue-50 border border-blue-200 rounded-lg">
                        <p class="text-sm text-blue-800">
                            <strong>Note:</strong> Select a new supervisor to replace the current assignment. This will update the quota counts accordingly.
                        </p>
                    </div>

                    <!-- Available Supervisors -->
                    <div class="mb-4">
                        <h4 class="font-medium text-gray-900 mb-2">Select New Supervisor (Nearest First)</h4>

                        <?php if(!empty($recommendedSupervisors)): ?>
                            <div class="max-h-64 overflow-y-auto border border-gray-200 rounded-lg">
                                <?php $__currentLoopData = $recommendedSupervisors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $supervisor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <label class="flex items-start p-3 hover:bg-gray-50 cursor-pointer border-b border-gray-100">
                                        <input type="radio" name="new_supervisor" value="<?php echo e($supervisor->lecturerID); ?>"
                                            wire:model="newSupervisorID"
                                            class="mt-1 rounded border-gray-300 text-indigo-600 focus:ring-indigo-500">
                                        <div class="ml-3 flex-1">
                                            <div class="flex justify-between">
                                                <div>
                                                    <p class="text-sm font-medium text-gray-900"><?php echo e($supervisor->user->name); ?></p>
                                                    <p class="text-xs text-gray-500">
                                                        <?php echo e($supervisor->lecturerID); ?> |
                                                        <?php echo e($supervisor->department ?? 'N/A'); ?> |
                                                        <?php echo e($supervisor->researchGroup ?? 'N/A'); ?>

                                                        <?php if($supervisor->program): ?>
                                                            <?php
                                                                $programCodes = [
                                                                    'Bachelor of Computer Science (Software Engineering) with Honours' => 'BCS',
                                                                    'Bachelor of Computer Science (Computer Systems & Networking) with Honours' => 'BCN',
                                                                    'Bachelor of Computer Science (Multimedia Software) with Honours' => 'BCM',
                                                                    'Bachelor of Computer Science (Cyber Security) with Honours' => 'BCY',
                                                                    'Diploma in Computer Science' => 'DRC',
                                                                ];
                                                                $programCode = $programCodes[$supervisor->program] ?? null;
                                                            ?>
                                                            <?php if($programCode): ?>
                                                                | <?php echo e($programCode); ?>

                                                            <?php endif; ?>
                                                        <?php endif; ?>
                                                    </p>
                                                </div>
                                                <div class="text-right">
                                                    <?php if(isset($supervisor->distance)): ?>
                                                        <p class="text-sm font-medium text-gray-900"><?php echo e(number_format($supervisor->distance, 2)); ?> km</p>
                                                    <?php endif; ?>
                                                    <p class="text-xs text-gray-500">
                                                        Quota: <?php echo e($supervisor->current_assignments); ?>/<?php echo e($supervisor->supervisor_quota); ?>

                                                        <?php if(isset($supervisor->available_quota) && $supervisor->available_quota > 0): ?>
                                                            <span class="text-green-600">(<?php echo e($supervisor->available_quota); ?> available)</span>
                                                        <?php else: ?>
                                                            <span class="text-red-600">(Full)</span>
                                                        <?php endif; ?>
                                                    </p>
                                                </div>
                                            </div>
                                        </div>
                                    </label>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        <?php else: ?>
                            <div class="p-4 bg-yellow-50 border border-yellow-200 rounded-lg">
                                <p class="text-sm text-yellow-800">No supervisors available.</p>
                            </div>
                        <?php endif; ?>
                    </div>

                    <!-- Assignment Notes -->
                    <div class="mb-4">
                        <label class="block text-sm font-medium text-gray-700 mb-1">
                            Assignment Notes (Optional)
                        </label>
                        <textarea wire:model="assignmentNotes" rows="3"
                            class="w-full border border-gray-300 rounded-md px-3 py-2 text-sm"
                            placeholder="Add any notes about this assignment change..."></textarea>
                    </div>

                    <!-- Validation Errors -->
                    <?php $__errorArgs = ['newSupervisorID'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="mb-4 p-3 bg-red-50 border border-red-200 rounded-lg">
                            <p class="text-sm text-red-800"><?php echo e($message); ?></p>
                        </div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                    <!-- Actions -->
                    <div class="flex justify-end space-x-3">
                        <button wire:click="closeEditModal"
                            class="inline-flex items-center gap-2 px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-lg text-sm font-medium text-gray-700 dark:text-gray-300 bg-white dark:bg-gray-800 hover:bg-gray-50 dark:hover:bg-gray-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-purple-500 transition-colors">
                            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-4 h-4">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M6 18 18 6M6 6l12 12" />
                            </svg>
                            <span>Cancel</span>
                        </button>
                        <button wire:click="updateAssignment"
                            wire:loading.attr="disabled"
                            wire:target="updateAssignment"
                            class="inline-flex items-center gap-2 px-4 py-2 border border-transparent rounded-lg text-sm font-medium text-white bg-yellow-600 hover:bg-yellow-700 dark:bg-yellow-600 dark:hover:bg-yellow-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-yellow-500 disabled:opacity-50 disabled:cursor-not-allowed transition-colors shadow-sm hover:shadow-md">
                            <span wire:loading.remove wire:target="updateAssignment" class="flex items-center gap-2">
                                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-4 h-4">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M16.862 4.487l1.687-1.688a1.875 1.875 0 112.652 2.652L10.582 16.07a4.5 4.5 0 01-1.897 1.13L6 18l.8-2.685a4.5 4.5 0 011.13-1.897l8.932-8.931zm0 0L19.5 7.125M18 14v4.75A2.25 2.25 0 0115.75 21H5.25A2.25 2.25 0 013 18.75V8.25A2.25 2.25 0 015.25 6H10" />
                                </svg>
                                <span>Update Assignment</span>
                            </span>
                            <span wire:loading wire:target="updateAssignment" class="flex items-center gap-2">
                                <?php if (isset($component)) { $__componentOriginal5c29929acf227acd7c5fa56a39e71fcc = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal5c29929acf227acd7c5fa56a39e71fcc = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.loading-spinner','data' => ['size' => 'h-4 w-4','color' => 'text-white']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('loading-spinner'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['size' => 'h-4 w-4','color' => 'text-white']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal5c29929acf227acd7c5fa56a39e71fcc)): ?>
<?php $attributes = $__attributesOriginal5c29929acf227acd7c5fa56a39e71fcc; ?>
<?php unset($__attributesOriginal5c29929acf227acd7c5fa56a39e71fcc); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal5c29929acf227acd7c5fa56a39e71fcc)): ?>
<?php $component = $__componentOriginal5c29929acf227acd7c5fa56a39e71fcc; ?>
<?php unset($__componentOriginal5c29929acf227acd7c5fa56a39e71fcc); ?>
<?php endif; ?>
                                <span>Updating...</span>
                            </span>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <!-- Assignment Detail Modal -->
    <?php if($showDetailModal && $selectedAssignment): ?>
        <div class="fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full z-50" wire:click="closeDetailModal">
            <div class="relative top-20 mx-auto p-5 border w-11/12 md:w-3/4 lg:w-1/2 shadow-lg rounded-md bg-white" wire:click.stop>
                <div class="mt-3">
                    <!-- Header -->
                    <div class="flex justify-between items-center mb-4">
                        <h3 class="text-lg font-medium text-gray-900">Assignment Details</h3>
                        <button wire:click="closeDetailModal" class="text-gray-400 hover:text-gray-500">
                            <span class="text-2xl">&times;</span>
                        </button>
                    </div>

                    <!-- Student Info -->
                    <div class="mb-4 p-4 bg-gray-50 rounded-lg">
                        <h4 class="font-medium text-gray-900 mb-2">Student</h4>
                        <p><strong>Name:</strong> <?php echo e($selectedAssignment['student_name']); ?></p>
                        <p><strong>ID:</strong> <?php echo e($selectedAssignment['student_id']); ?></p>
                        <p><strong>Program:</strong> <?php echo e($selectedAssignment['student_program'] ?? 'N/A'); ?></p>
                        <?php if($selectedAssignment['company_name']): ?>
                            <p><strong>Company:</strong> <?php echo e($selectedAssignment['company_name']); ?></p>
                            <p><strong>Location:</strong>
                                <?php echo e($selectedAssignment['company_city']); ?>,
                                <?php echo e($selectedAssignment['company_state']); ?>

                            </p>
                        <?php endif; ?>
                    </div>

                    <!-- Supervisor Info -->
                    <div class="mb-4 p-4 bg-gray-50 rounded-lg">
                        <h4 class="font-medium text-gray-900 mb-2">Supervisor</h4>
                        <p><strong>Name:</strong> <?php echo e($selectedAssignment['supervisor_name']); ?></p>
                        <p><strong>ID:</strong> <?php echo e($selectedAssignment['supervisor_id']); ?></p>
                        <p><strong>Department:</strong> <?php echo e($selectedAssignment['supervisor_department'] ?? 'N/A'); ?></p>
                        <p><strong>Research Group:</strong> <?php echo e($selectedAssignment['supervisor_research_group'] ?? 'N/A'); ?></p>
                        <p><strong>Position:</strong> <?php echo e($selectedAssignment['supervisor_position'] ?? 'N/A'); ?></p>
                        <?php if($selectedAssignment['distance_km']): ?>
                            <p><strong>Distance:</strong> <?php echo e(number_format($selectedAssignment['distance_km'], 2)); ?> km</p>
                        <?php endif; ?>
                        <?php if($selectedAssignment['quota_override']): ?>
                            <p class="text-yellow-600"><strong>⚠️ Quota Override Applied</strong></p>
                            <?php if($selectedAssignment['override_reason']): ?>
                                <p class="text-sm text-gray-600"><strong>Reason:</strong> <?php echo e($selectedAssignment['override_reason']); ?></p>
                            <?php endif; ?>
                        <?php endif; ?>
                    </div>

                    <!-- Assignment Info -->
                    <div class="mb-4 p-4 bg-gray-50 rounded-lg">
                        <h4 class="font-medium text-gray-900 mb-2">Assignment Details</h4>
                        <p><strong>Status:</strong>
                            <span class="px-2 py-1 text-xs rounded-full <?php echo e($selectedAssignment['status'] === 'assigned' ? 'bg-green-100 text-green-800' : 'bg-gray-100 text-gray-800'); ?>">
                                <?php echo e($selectedAssignment['status_display']); ?>

                            </span>
                        </p>
                        <p><strong>Assigned By:</strong>
                            <?php echo e($selectedAssignment['assigned_by_name']); ?>

                            <?php if($selectedAssignment['assigned_by_id']): ?>
                                (<?php echo e($selectedAssignment['assigned_by_id']); ?>)
                            <?php endif; ?>
                        </p>
                        <p><strong>Assigned At:</strong> <?php echo e($selectedAssignment['assigned_at']); ?></p>
                        <?php if($selectedAssignment['assignment_notes']): ?>
                            <p><strong>Notes:</strong> <?php echo e($selectedAssignment['assignment_notes']); ?></p>
                        <?php endif; ?>
                    </div>

                    <!-- Actions -->
                    <div class="flex justify-end">
                        <button wire:click="closeDetailModal"
                            class="px-4 py-2 bg-gray-600 text-white rounded-md text-sm font-medium hover:bg-gray-700">
                            Close
                        </button>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>
</div><?php /**PATH C:\Users\User\Desktop\Laravel\Internlink\resources\views\livewire\supervisor-assignment-table.blade.php ENDPATH**/ ?>