<div>
    <!-- Custom Styles for Better Icon Visibility -->
    <style>
        .sort-icon {
            display: inline-block;
            width: 12px;
            text-align: center;
        }

        .sort-icon:before {
            font-weight: 900;
        }

        /* Fallback for missing FontAwesome */
        .fa-sort:before {
            content: "↕";
        }

        .fa-sort-up:before {
            content: "↑";
        }

        .fa-sort-down:before {
            content: "↓";
        }

        .fa-search:before {
            content: "🔍";
        }

        .fa-plus:before {
            content: "➕";
        }

        .fa-edit:before {
            content: "✏️";
        }

        .fa-trash:before {
            content: "🗑️";
        }

        .fa-file:before {
            content: "📄";
        }

        .fa-times:before {
            content: "✖";
        }

        .modal-overlay {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: rgba(0, 0, 0, 0.5);
            z-index: 50;
        }

        .modal-content {
            position: fixed;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            z-index: 51;
        }
    </style>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <!-- Course Verification Guide -->
            <div class="bg-blue-50 border border-blue-200 rounded-lg p-4 mb-6">
                <div class="flex items-center justify-between">
                    <div class="flex items-center">
                        <div class="flex-shrink-0">
                            <i class="fa fa-info-circle text-blue-500 text-xl"></i>
                        </div>
                        <div class="ml-3">
                            <h3 class="text-lg font-medium text-blue-900">Course Verification Guide</h3>
                            <p class="text-sm text-blue-600 mt-1">
                                <?php if(!$showGuide): ?>
                                    Fill in verification form → Prepare Documents → Merge files → Submit → Academic Advisor Review → Coordinator Approval
                                <?php else: ?>
                                    Follow these steps to complete your course verification submission and understand the approval process.
                                <?php endif; ?>
                            </p>
                        </div>
                    </div>
                    <button wire:click="$set('showGuide', <?php echo e($showGuide ? 'false' : 'true'); ?>)"
                        class="ml-4 inline-flex items-center px-3 py-2 border border-blue-400 rounded-md text-sm font-medium text-blue-700 bg-white hover:bg-blue-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 transition-colors">
                        <i class="fa <?php echo e($showGuide ? 'fa-chevron-up' : 'fa-chevron-down'); ?> mr-2"></i>
                        <?php echo e($showGuide ? 'Hide Guide' : 'Show Full Guide'); ?>

                    </button>
                </div>

                <?php if($showGuide): ?>
                <div class="mt-4 space-y-4">
                    <!-- Step 1 -->
                    <div class="bg-white rounded-lg p-4 border border-blue-200">
                        <div class="flex items-start">
                            <div class="flex-shrink-0 bg-blue-100 rounded-full w-8 h-8 flex items-center justify-center mr-3">
                                <span class="text-blue-600 font-semibold text-sm">1</span>
                            </div>
                            <div class="flex-1">
                                <p class="text-sm font-medium text-gray-900 mb-2">
                                    Fill in the course verification form with your current credit information.
                                </p>
                                <div class="flex flex-wrap gap-2 mt-2">
                                    <a href="<?php echo e(asset('documents/Course-Verification-Form-Eng.docx')); ?>"
                                       target="_blank"
                                       download
                                       class="inline-flex items-center px-3 py-1.5 border border-blue-400 rounded-md text-xs font-medium text-blue-700 bg-white hover:bg-blue-50">
                                        <i class="fa fa-download mr-1.5"></i>
                                        English Version
                                    </a>
                                    <a href="<?php echo e(asset('documents/Course-Verification-Form-Malay.docx')); ?>"
                                       target="_blank"
                                       download
                                       class="inline-flex items-center px-3 py-1.5 border border-blue-400 rounded-md text-xs font-medium text-blue-700 bg-white hover:bg-blue-50">
                                        <i class="fa fa-download mr-1.5"></i>
                                        Malay Version
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Step 2 -->
                    <div class="bg-white rounded-lg p-4 border border-blue-200">
                        <div class="flex items-start">
                            <div class="flex-shrink-0 bg-blue-100 rounded-full w-8 h-8 flex items-center justify-center mr-3">
                                <span class="text-blue-600 font-semibold text-sm">2</span>
                            </div>
                            <div class="flex-1">
                                <p class="text-sm font-medium text-gray-900">
                                    Please ask your academic advisor for the <strong>List of Taken / Untaken Courses</strong>.
                                </p>
                            </div>
                        </div>
                    </div>

                    <!-- Step 3 -->
                    <div class="bg-white rounded-lg p-4 border border-blue-200">
                        <div class="flex items-start">
                            <div class="flex-shrink-0 bg-blue-100 rounded-full w-8 h-8 flex items-center justify-center mr-3">
                                <span class="text-blue-600 font-semibold text-sm">3</span>
                            </div>
                            <div class="flex-1">
                                <p class="text-sm font-medium text-gray-900 mb-2">
                                    Screenshot the <strong>Registered Courses</strong> in E-COMMUNITY (My Course Results → Course Structure).
                                </p>
                                <div class="mt-2">
                                    <a href="<?php echo e(asset('documents/Registered-Course-Guide.pdf')); ?>"
                                       target="_blank"
                                       download
                                       class="inline-flex items-center px-3 py-1.5 border border-blue-400 rounded-md text-xs font-medium text-blue-700 bg-white hover:bg-blue-50">
                                        <i class="fa fa-download mr-1.5"></i>
                                        Screenshot Guide
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Step 4 -->
                    <div class="bg-white rounded-lg p-4 border border-blue-200">
                        <div class="flex items-start">
                            <div class="flex-shrink-0 bg-blue-100 rounded-full w-8 h-8 flex items-center justify-center mr-3">
                                <span class="text-blue-600 font-semibold text-sm">4</span>
                            </div>
                            <div class="flex-1">
                                <p class="text-sm font-medium text-gray-900 mb-2">
                                    Once approved, please merge the <strong>List of Taken / Untaken Courses</strong> and <strong>Registered Courses</strong> together with verification form and save the file as PDF or ZIP file.
                                </p>
                                <p class="text-sm text-gray-700 mt-2">
                                    <strong>File naming convention:</strong><br>
                                    For PDF: <code class="bg-gray-100 px-2 py-1 rounded text-xs"><?php echo e(Auth::user()->student->studentID ?? 'matricID'); ?>_CClist.pdf</code><br>
                                    For ZIP: <code class="bg-gray-100 px-2 py-1 rounded text-xs"><?php echo e(Auth::user()->student->studentID ?? 'matricID'); ?>_CClist.zip</code>
                                </p>
                            </div>
                        </div>
                    </div>

                    <!-- Step 5 -->
                    <div class="bg-white rounded-lg p-4 border border-blue-200">
                        <div class="flex items-start">
                            <div class="flex-shrink-0 bg-blue-100 rounded-full w-8 h-8 flex items-center justify-center mr-3">
                                <span class="text-blue-600 font-semibold text-sm">5</span>
                            </div>
                            <div class="flex-1">
                                <p class="text-sm font-medium text-gray-900">
                                    Submit the merged verification form at the course verification form below.
                                </p>
                            </div>
                        </div>
                    </div>

                    <!-- Step 6 - Approval Process -->
                    <div class="bg-white rounded-lg p-4 border-2 border-green-200 bg-green-50">
                        <div class="flex items-start">
                            <div class="flex-shrink-0 bg-green-100 rounded-full w-8 h-8 flex items-center justify-center mr-3">
                                <span class="text-green-600 font-semibold text-sm">6</span>
                            </div>
                            <div class="flex-1">
                                <p class="text-sm font-medium text-gray-900 mb-2">
                                    <strong>Approval Process (Two-Step Review):</strong>
                                </p>
                                <div class="space-y-2 mt-2">
                                    <div class="flex items-start">
                                        <span class="inline-flex items-center justify-center w-5 h-5 rounded-full bg-blue-100 text-blue-600 text-xs font-semibold mr-2 mt-0.5">A</span>
                                        <div>
                                            <p class="text-sm font-medium text-gray-900">Academic Advisor Review</p>
                                            <p class="text-xs text-gray-600 mt-1">
                                                Your academic advisor will review your application to determine if it is <strong>eligible</strong> for coordinator approval.
                                                You will be notified once the review is complete.
                                            </p>
                                        </div>
                                    </div>
                                    <div class="flex items-start">
                                        <span class="inline-flex items-center justify-center w-5 h-5 rounded-full bg-purple-100 text-purple-600 text-xs font-semibold mr-2 mt-0.5">B</span>
                                        <div>
                                            <p class="text-sm font-medium text-gray-900">Coordinator Review</p>
                                            <p class="text-xs text-gray-600 mt-1">
                                                If approved by your academic advisor, the application will be forwarded to the coordinator for <strong>final approval</strong>.
                                                You will receive a final notification once the coordinator makes a decision.
                                            </p>
                                        </div>
                                    </div>
                                </div>
                                <div class="mt-3 p-2 bg-yellow-50 border border-yellow-200 rounded-md">
                                    <p class="text-xs text-yellow-800">
                                        <i class="fa fa-info-circle mr-1"></i>
                                        <strong>Note:</strong> You can track the status of your application in the table below.
                                        The status will show both Academic Advisor and Coordinator review stages.
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Credit Requirements Info -->
                <div class="mt-4 pt-4 border-t border-blue-200">
                    <p class="text-sm text-blue-700">
                        <strong>Total Credits Required:</strong> <?php echo e($totalCreditRequired); ?> credits
                    </p>
                </div>
                <?php endif; ?>
            </div>

            <!-- Current Application Status -->
            <?php if($currentApplication): ?>
                <div class="mb-6">
                    <?php
                        $statusClasses = [
                            'pending' => 'bg-yellow-50 border-yellow-200 text-yellow-800',
                            'approved' => 'bg-green-50 border-green-200 text-green-800',
                            'rejected' => 'bg-red-50 border-red-200 text-red-800',
                        ];
                        $statusIcons = [
                            'pending' => 'fa-clock',
                            'approved' => 'fa-check-circle',
                            'rejected' => 'fa-times-circle',
                        ];
                    ?>
                    <div
                        class="border rounded-lg p-4 <?php echo e($statusClasses[$currentApplication->status] ?? 'bg-gray-50 border-gray-200 text-gray-800'); ?>">
                        <div class="flex items-center">
                            <div class="flex-shrink-0">
                                <i class="fa <?php echo e($statusIcons[$currentApplication->status] ?? 'fa-file'); ?> text-xl"></i>
                            </div>
                            <div class="ml-3 flex-1">
                                <h3 class="text-lg font-medium">Current Application Status</h3>
                                <p class="text-sm mt-1">
                                    Application ID: <?php echo e($currentApplication->courseVerificationID); ?> |
                                    Submitted: <?php echo e($currentApplication->applicationDate->format('M d, Y')); ?> |
                                    Credits: <?php echo e($currentApplication->currentCredit); ?>/<?php echo e($totalCreditRequired); ?>

                                </p>

                                <!-- Status Breakdown -->
                                <div class="mt-3 space-y-2">
                                    <!-- Academic Advisor Status -->
                                    <div class="flex items-center gap-2">
                                        <span class="text-sm font-medium text-gray-700">Academic Advisor Review:</span>
                                        <?php if($currentApplication->academicAdvisorStatus === 'approved'): ?>
                                            <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full bg-green-100 text-green-800">
                                                <i class="fa fa-check mr-1"></i>Approved (Eligible)
                                            </span>
                                        <?php elseif($currentApplication->academicAdvisorStatus === 'rejected'): ?>
                                            <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full bg-red-100 text-red-800">
                                                <i class="fa fa-times mr-1"></i>Rejected (Ineligible)
                                            </span>
                                        <?php else: ?>
                                            <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full bg-yellow-100 text-yellow-800">
                                                <i class="fa fa-clock mr-1"></i>Pending Review
                                            </span>
                                        <?php endif; ?>
                                    </div>

                                    <!-- Coordinator Status -->
                                    <div class="flex items-center gap-2">
                                        <span class="text-sm font-medium text-gray-700">Coordinator Review:</span>
                                        <?php if($currentApplication->academicAdvisorStatus === 'rejected'): ?>
                                            <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full bg-gray-100 text-gray-800">
                                                Not Applicable
                                            </span>
                                        <?php elseif($currentApplication->academicAdvisorStatus === 'approved'): ?>
                                            <?php if($currentApplication->status === 'approved'): ?>
                                                <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full bg-green-100 text-green-800">
                                                    <i class="fa fa-check mr-1"></i>Approved
                                                </span>
                                            <?php elseif($currentApplication->status === 'rejected'): ?>
                                                <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full bg-red-100 text-red-800">
                                                    <i class="fa fa-times mr-1"></i>Rejected
                                                </span>
                                            <?php else: ?>
                                                <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full bg-yellow-100 text-yellow-800">
                                                    <i class="fa fa-clock mr-1"></i>Pending Review
                                                </span>
                                            <?php endif; ?>
                                        <?php else: ?>
                                            <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full bg-gray-100 text-gray-800">
                                                Awaiting Academic Advisor Approval
                                            </span>
                                        <?php endif; ?>
                                    </div>
                                </div>

                                <!-- Status Messages -->
                                <?php if($currentApplication->status === 'pending'): ?>
                                    <?php if($currentApplication->academicAdvisorStatus === null): ?>
                                        <p class="text-sm mt-3 text-yellow-700">
                                            <strong>Your application is awaiting academic advisor review.</strong> You cannot submit a new application while this one is pending.
                                        </p>
                                    <?php elseif($currentApplication->academicAdvisorStatus === 'approved'): ?>
                                        <p class="text-sm mt-3 text-yellow-700">
                                            <strong>Your application has been approved by your academic advisor and is now awaiting coordinator review.</strong> You cannot submit a new application while this one is pending.
                                        </p>
                                    <?php endif; ?>
                                <?php elseif($currentApplication->status === 'approved'): ?>
                                    <p class="text-sm mt-3 text-green-700">
                                        <strong>Congratulations!</strong> Your course verification has been fully approved. No further action is needed.
                                    </p>
                                <?php elseif($currentApplication->status === 'rejected'): ?>
                                    <?php if($hasApprovedApplication): ?>
                                        <p class="text-sm mt-3 text-red-700">
                                            <strong>This application was rejected.</strong> However, you have a previously approved verification and cannot submit new applications.
                                        </p>
                                    <?php else: ?>
                                        <p class="text-sm mt-3 text-red-700">
                                            <strong>Your application was rejected.</strong> You can submit a new application with updated information.
                                        </p>
                                    <?php endif; ?>
                                <?php endif; ?>

                                <!-- Remarks -->
                                <?php if($currentApplication->remarks): ?>
                                    <div class="mt-3 p-3 bg-gray-50 rounded-md">
                                        <p class="text-xs font-medium text-gray-700 mb-1">Remarks:</p>
                                        <p class="text-sm text-gray-900"><?php echo e($currentApplication->remarks); ?></p>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <!-- Flash Messages -->
            <?php if(session()->has('message')): ?>
                <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4" role="alert">
                    <span class="block sm:inline"><?php echo e(session('message')); ?></span>
                </div>
            <?php endif; ?>

            <?php if(session()->has('error')): ?>
                <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4" role="alert">
                    <span class="block sm:inline"><?php echo e(session('error')); ?></span>
                </div>
            <?php endif; ?>

            <!-- Controls Section -->
            <div class="bg-white rounded-lg shadow-md p-6 mb-6">
                <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between gap-4">
                    <!-- Search -->
                    <div class="flex-1 lg:max-w-md">
                        <div class="relative">
                            <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                <i class="fa fa-search text-gray-400"></i>
                            </div>
                            <input type="text" wire:model.live.debounce.300ms="search"
                                class="block w-full pl-10 pr-3 py-2 border border-gray-300 rounded-md leading-5 bg-white placeholder-gray-500 focus:outline-none focus:placeholder-gray-400 focus:ring-1 focus:ring-blue-500 focus:border-blue-500 sm:text-sm"
                                placeholder="Search applications...">
                        </div>
                    </div>

                    <!-- Apply Button -->
                    <div class="flex items-center gap-2">
                        <?php if($canApply): ?>
                            <button wire:click="openForm"
                                class="inline-flex items-center px-4 py-2 border border-transparent text-sm font-medium rounded-md text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                                <i class="fa fa-plus mr-2"></i>
                                <?php if($currentApplication && $currentApplication->status === 'rejected'): ?>
                                    Apply Again
                                <?php else: ?>
                                    Apply for Verification
                                <?php endif; ?>
                            </button>
                        <?php else: ?>
                            <?php if($hasApprovedApplication): ?>
                                <div
                                    class="inline-flex items-center px-4 py-2 border border-green-300 text-sm font-medium rounded-md text-green-700 bg-green-100">
                                    <i class="fa fa-check-circle mr-2"></i>
                                    Verification Approved
                                </div>
                            <?php elseif($currentApplication): ?>
                                <?php if($currentApplication->status === 'pending'): ?>
                                    <div
                                        class="inline-flex items-center px-4 py-2 border border-yellow-300 text-sm font-medium rounded-md text-yellow-700 bg-yellow-100">
                                        <i class="fa fa-clock mr-2"></i>
                                        Application Under Review
                                    </div>
                                <?php endif; ?>
                            <?php else: ?>
                                <div
                                    class="inline-flex items-center px-4 py-2 border border-gray-300 text-sm font-medium rounded-md text-gray-500 bg-gray-100">
                                    <i class="fa fa-ban mr-2"></i>
                                    Cannot Apply
                                </div>
                            <?php endif; ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <!-- Table Section -->
            <div class="bg-white rounded-lg shadow-md overflow-hidden">
                <div class="overflow-x-auto">
                    <table class="min-w-full divide-y divide-gray-200">
                        <thead class="bg-gray-50">
                            <tr>
                                <th scope="col"
                                    class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    <button wire:click="sortBy('courseVerificationID')"
                                        class="flex items-center hover:text-gray-700">
                                        ID
                                        <span class="ml-1 sort-icon">
                                            <?php if($sortField === 'courseVerificationID'): ?>
                                                <?php if($sortDirection === 'asc'): ?>
                                                    <i class="fa fa-sort-up"></i>
                                                <?php else: ?>
                                                    <i class="fa fa-sort-down"></i>
                                                <?php endif; ?>
                                            <?php else: ?>
                                                <i class="fa fa-sort"></i>
                                            <?php endif; ?>
                                        </span>
                                    </button>
                                </th>
                                <th scope="col"
                                    class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    <button wire:click="sortBy('currentCredit')"
                                        class="flex items-center hover:text-gray-700">
                                        Current Credit
                                        <span class="ml-1 sort-icon">
                                            <?php if($sortField === 'currentCredit'): ?>
                                                <?php if($sortDirection === 'asc'): ?>
                                                    <i class="fa fa-sort-up"></i>
                                                <?php else: ?>
                                                    <i class="fa fa-sort-down"></i>
                                                <?php endif; ?>
                                            <?php else: ?>
                                                <i class="fa fa-sort"></i>
                                            <?php endif; ?>
                                        </span>
                                    </button>
                                </th>
                                <th scope="col"
                                    class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    <button wire:click="sortBy('status')" class="flex items-center hover:text-gray-700">
                                        Status
                                        <span class="ml-1 sort-icon">
                                            <?php if($sortField === 'status'): ?>
                                                <?php if($sortDirection === 'asc'): ?>
                                                    <i class="fa fa-sort-up"></i>
                                                <?php else: ?>
                                                    <i class="fa fa-sort-down"></i>
                                                <?php endif; ?>
                                            <?php else: ?>
                                                <i class="fa fa-sort"></i>
                                            <?php endif; ?>
                                        </span>
                                    </button>
                                </th>
                                <th scope="col"
                                    class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    <button wire:click="sortBy('applicationDate')"
                                        class="flex items-center hover:text-gray-700">
                                        Application Date
                                        <span class="ml-1 sort-icon">
                                            <?php if($sortField === 'applicationDate'): ?>
                                                <?php if($sortDirection === 'asc'): ?>
                                                    <i class="fa fa-sort-up"></i>
                                                <?php else: ?>
                                                    <i class="fa fa-sort-down"></i>
                                                <?php endif; ?>
                                            <?php else: ?>
                                                <i class="fa fa-sort"></i>
                                            <?php endif; ?>
                                        </span>
                                    </button>
                                </th>
                                <th scope="col"
                                    class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    Remarks
                                </th>
                                <th scope="col"
                                    class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    Actions
                                </th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                             <?php $__empty_1 = true; $__currentLoopData = $verifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $verification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                 <tr class="hover:bg-gray-50 <?php echo e($verification->status === 'approved' ? 'bg-green-50 border-l-4 border-green-400' : ''); ?>">
                                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">
                                        <div class="flex items-center">
                                            <?php if($verification->status === 'approved'): ?>
                                                <i class="fa fa-check-circle text-green-500 mr-2" title="Approved"></i>
                                            <?php endif; ?>
                                            <?php echo e($verification->courseVerificationID); ?>

                                        </div>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                        <?php echo e($verification->currentCredit); ?> / <?php echo e($totalCreditRequired); ?>

                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <?php
                                            $statusClasses = [
                                                'pending' => 'bg-yellow-100 text-yellow-800',
                                                'approved' => 'bg-green-100 text-green-800',
                                                'rejected' => 'bg-red-100 text-red-800',
                                            ];
                                        ?>
                                        <div class="flex flex-col gap-1">
                                            <!-- Academic Advisor Status -->
                                            <?php if($verification->academicAdvisorStatus): ?>
                                                <span
                                                    class="inline-flex px-2 py-1 text-xs font-semibold rounded-full <?php echo e($statusClasses[$verification->academicAdvisorStatus] ?? 'bg-gray-100 text-gray-800'); ?>"
                                                    title="Academic Advisor Review">
                                                    AA: <?php echo e(ucfirst($verification->academicAdvisorStatus)); ?>

                                                </span>
                                            <?php else: ?>
                                                <span
                                                    class="inline-flex px-2 py-1 text-xs font-semibold rounded-full bg-gray-100 text-gray-800"
                                                    title="Awaiting Academic Advisor Review">
                                                    AA: Pending
                                                </span>
                                            <?php endif; ?>

                                            <!-- Coordinator Status -->
                                            <?php if($verification->academicAdvisorStatus === 'approved'): ?>
                                                <span
                                                    class="inline-flex px-2 py-1 text-xs font-semibold rounded-full <?php echo e($statusClasses[$verification->status] ?? 'bg-gray-100 text-gray-800'); ?>"
                                                    title="Coordinator Review">
                                                    Coordinator: <?php echo e(ucfirst($verification->status)); ?>

                                                </span>
                                            <?php elseif($verification->academicAdvisorStatus === 'rejected'): ?>
                                                <span
                                                    class="inline-flex px-2 py-1 text-xs font-semibold rounded-full bg-red-100 text-red-800"
                                                    title="Rejected by Academic Advisor">
                                                    Coordinator: Not Applicable
                                                </span>
                                            <?php else: ?>
                                                <span
                                                    class="inline-flex px-2 py-1 text-xs font-semibold rounded-full bg-gray-100 text-gray-800"
                                                    title="Awaiting Academic Advisor Approval">
                                                    Coordinator: Pending
                                                </span>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                        <?php echo e($verification->applicationDate->format('M d, Y')); ?>

                                    </td>
                                    <td class="px-6 py-4 text-sm text-gray-900 max-w-xs">
                                        <?php if(in_array($verification->status, ['approved', 'rejected']) && $verification->remarks): ?>
                                            <div class="truncate" title="<?php echo e($verification->remarks); ?>">
                                                <?php echo e(Str::limit($verification->remarks, 50)); ?>

                                            </div>
                                        <?php else: ?>
                                            <span class="text-gray-400">-</span>
                                        <?php endif; ?>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                                        <div class="flex items-center space-x-2">
                                            <!-- View File -->
                                            <?php if($verification->files->count() > 0): ?>
                                                <a href="<?php echo e($verification->files->first()->url); ?>"
                                                    target="_blank" class="text-blue-600 hover:text-blue-900 title"
                                                    title="View submitted file">
                                                    <i class="fa fa-file"></i>
                                                </a>
                                            <?php endif; ?>

                                            <!-- Edit/Delete (only for current application and appropriate status) -->
                                            <?php if($currentApplication && $currentApplication->courseVerificationID === $verification->courseVerificationID && !$hasApprovedApplication): ?>
                                                <?php if(in_array($verification->status, ['pending', 'rejected'])): ?>
                                                    <button
                                                        wire:click="edit(<?php echo e($verification->courseVerificationID); ?>)"
                                                        class="inline-flex items-center gap-1.5 px-2.5 py-1.5 text-sm font-medium text-indigo-700 bg-indigo-50 hover:bg-indigo-100 dark:bg-indigo-900/20 dark:text-indigo-400 dark:hover:bg-indigo-900/30 rounded-lg transition-colors"
                                                        title="Edit application">
                                                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-4 h-4">
                                                            <path stroke-linecap="round" stroke-linejoin="round" d="m16.862 4.487 1.687-1.688a1.875 1.875 0 1 1 2.652 2.652L10.582 16.07a4.5 4.5 0 0 1-1.897 1.13L6 18l.8-2.685a4.5 4.5 0 0 1 1.13-1.897l8.932-8.931Zm0 0L19.5 7.125M18 14v4.75A2.25 2.25 0 0 1 15.75 21H5.25A2.25 2.25 0 0 1 3 18.75V8.25A2.25 2.25 0 0 1 5.25 6H10" />
                                                        </svg>
                                                        <span>Edit</span>
                                                    </button>

                                                    <!-- Delete (only for current application) -->
                                                    <button
                                                        wire:click="deleteApplication(<?php echo e($verification->courseVerificationID); ?>)"
                                                        wire:confirm="Are you sure you want to delete this application?"
                                                        wire:loading.attr="disabled"
                                                        wire:target="deleteApplication(<?php echo e($verification->courseVerificationID); ?>)"
                                                        class="inline-flex items-center gap-1.5 px-2.5 py-1.5 text-sm font-medium text-red-700 bg-red-50 hover:bg-red-100 dark:bg-red-900/20 dark:text-red-400 dark:hover:bg-red-900/30 rounded-lg transition-colors disabled:opacity-50 disabled:cursor-not-allowed"
                                                        title="Delete application">
                                                        <span wire:loading.remove wire:target="deleteApplication(<?php echo e($verification->courseVerificationID); ?>)" class="flex items-center gap-1.5">
                                                            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-4 h-4">
                                                                <path stroke-linecap="round" stroke-linejoin="round" d="m14.74 9-.346 9m-4.788 0L9.26 9m9.968-3.21c.342.052.682.107 1.022.166m-1.022-.165L18.16 19.673a2.25 2.25 0 0 1-2.244 2.077H8.084a2.25 2.25 0 0 1-2.244-2.077L4.772 5.79m14.456 0a48.108 48.108 0 0 0-3.478-.397m-12 .562c.34-.059.68-.114 1.022-.165m0 0a48.11 48.11 0 0 1 3.478-.397m7.5 0v-.916c0-1.18-.91-2.164-2.09-2.201a51.964 51.964 0 0 0-3.32 0c-1.18.037-2.09 1.022-2.09 2.201v.916m7.5 0a48.667 48.667 0 0 0-7.5 0" />
                                                            </svg>
                                                            <span>Delete</span>
                                                        </span>
                                                        <span wire:loading wire:target="deleteApplication(<?php echo e($verification->courseVerificationID); ?>)">
                                                            <?php if (isset($component)) { $__componentOriginal5c29929acf227acd7c5fa56a39e71fcc = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal5c29929acf227acd7c5fa56a39e71fcc = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.loading-spinner','data' => ['size' => 'h-4 w-4','color' => 'text-red-600']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('loading-spinner'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['size' => 'h-4 w-4','color' => 'text-red-600']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal5c29929acf227acd7c5fa56a39e71fcc)): ?>
<?php $attributes = $__attributesOriginal5c29929acf227acd7c5fa56a39e71fcc; ?>
<?php unset($__attributesOriginal5c29929acf227acd7c5fa56a39e71fcc); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal5c29929acf227acd7c5fa56a39e71fcc)): ?>
<?php $component = $__componentOriginal5c29929acf227acd7c5fa56a39e71fcc; ?>
<?php unset($__componentOriginal5c29929acf227acd7c5fa56a39e71fcc); ?>
<?php endif; ?>
                                                        </span>
                                                    </button>
                                                <?php endif; ?>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="6" class="px-6 py-8 text-center text-gray-500">
                                        <div class="flex flex-col items-center">
                                            <i class="fa fa-file text-4xl text-gray-300 mb-4"></i>
                                            <p class="text-lg font-medium mb-2">No applications found</p>
                                            <?php if($canApply): ?>
                                                <p class="text-sm">Click "Apply for Verification" to submit your
                                                    application.</p>
                                            <?php else: ?>
                                                <p class="text-sm">You cannot apply for course verification at this
                                                    time.</p>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>

                <!-- Pagination -->
                <div class="bg-white dark:bg-gray-800 px-4 py-4 border-t border-gray-200 dark:border-gray-700 sm:px-6">
                    <?php echo e($verifications->links()); ?>

                </div>
            </div>
        </div>
    </div>

    <!-- Application Form Modal -->
    <?php if($showForm): ?>
        <div class="modal-overlay">
            <div class="modal-content bg-white rounded-lg shadow-xl max-w-lg w-full mx-4">
                <form wire:submit="submit">
                    <div class="px-6 py-4 border-b border-gray-200">
                        <div class="flex items-center justify-between">
                            <h3 class="text-lg font-medium text-gray-900">
                                <?php echo e($editingId ? 'Edit' : 'Apply for'); ?> Course Verification
                            </h3>
                            <button type="button" wire:click="closeForm" class="text-gray-400 hover:text-gray-600">
                                <i class="fa fa-times text-xl"></i>
                            </button>
                        </div>
                    </div>

                    <div class="px-6 py-4 space-y-4">
                        <!-- Total Credit Info -->
                        <div class="bg-blue-50 border border-blue-200 rounded-lg p-3">
                            <p class="text-sm text-blue-700">
                                <strong>Total Credits Required:</strong> <?php echo e($totalCreditRequired); ?> credits
                            </p>
                        </div>

                        <!-- Current Credit -->
                        <div>
                            <label for="currentCredit" class="block text-sm font-medium text-gray-700 mb-1">
                                Total Taken Current Credit <span class="text-red-500">*</span>
                            </label>
                            <input type="number" wire:model="currentCredit" id="currentCredit" min="0"
                                max="118"
                                class="block w-full border border-gray-300 rounded-md px-3 py-2 focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500"
                                placeholder="Enter your current credit count">
                            <?php $__errorArgs = ['currentCredit'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <!-- File Upload -->
                        <div>
                            <label for="submittedFile" class="block text-sm font-medium text-gray-700 mb-1">
                                Course File <span class="text-red-500">*</span>
                            </label>
                            <input type="file" wire:model="submittedFile" id="submittedFile"
                                accept=".pdf,.doc,.docx,.jpg,.jpeg,.png"
                                class="block w-full border border-gray-300 rounded-md px-3 py-2 focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                            <p class="mt-1 text-sm text-gray-500">
                                Accepted formats: PDF, DOC, DOCX, JPG, JPEG, PNG (Max: 10MB)
                            </p>
                            <?php $__errorArgs = ['submittedFile'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>

                    <div class="px-6 py-4 border-t border-gray-200 flex justify-end space-x-3">
                        <button type="button" wire:click="closeForm"
                            class="px-4 py-2 border border-gray-300 rounded-md text-sm font-medium text-gray-700 bg-white hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                            Cancel
                        </button>
                        <button type="submit" wire:loading.attr="disabled"
                            class="px-4 py-2 border border-transparent rounded-md text-sm font-medium text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 disabled:opacity-50">
                            <span wire:loading.remove>
                                <?php echo e($editingId ? 'Update' : 'Submit'); ?> Application
                            </span>
                            <span wire:loading>
                                Processing...
                            </span>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    <?php endif; ?>
</div><?php /**PATH C:\Users\User\Desktop\Laravel\Internlink\resources\views\livewire\course-verification-table.blade.php ENDPATH**/ ?>