<?php if($paginator->hasPages()): ?>
    <nav role="navigation" aria-label="<?php echo __('Pagination Navigation'); ?>" class="flex items-center justify-between gap-3">
        
        <?php if($paginator->onFirstPage()): ?>
            <span class="relative inline-flex items-center gap-1.5 px-3 py-2 text-sm font-medium text-gray-400 dark:text-gray-600 bg-gray-100 dark:bg-gray-800 border border-gray-300 dark:border-gray-600 cursor-default rounded-lg">
                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-4 h-4">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M15.75 19.5 8.25 12l7.5-7.5" />
                </svg>
                <span><?php echo __('pagination.previous'); ?></span>
            </span>
        <?php else: ?>
            <a href="<?php echo e($paginator->previousPageUrl()); ?>" rel="prev" class="relative inline-flex items-center gap-1.5 px-3 py-2 text-sm font-medium text-gray-700 dark:text-gray-300 bg-white dark:bg-gray-800 border border-gray-300 dark:border-gray-600 rounded-lg hover:bg-gray-50 dark:hover:bg-gray-700 focus:outline-none focus:ring-2 focus:ring-purple-500 focus:border-purple-500 transition-colors shadow-sm hover:shadow">
                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-4 h-4">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M15.75 19.5 8.25 12l7.5-7.5" />
                </svg>
                <span><?php echo __('pagination.previous'); ?></span>
            </a>
        <?php endif; ?>

        
        <div class="text-xs sm:text-sm text-gray-600 dark:text-gray-400">
            <?php echo __('Showing'); ?>

            <span class="font-medium text-gray-900 dark:text-gray-100"><?php echo e($paginator->firstItem() ?? $paginator->count()); ?></span>
            <?php echo __('to'); ?>

            <span class="font-medium text-gray-900 dark:text-gray-100"><?php echo e($paginator->lastItem() ?? $paginator->count()); ?></span>
            <?php echo __('of'); ?>

            <span class="font-medium text-gray-900 dark:text-gray-100"><?php echo e($paginator->total()); ?></span>
            <?php echo __('results'); ?>

        </div>

        
        <?php if($paginator->hasMorePages()): ?>
            <a href="<?php echo e($paginator->nextPageUrl()); ?>" rel="next" class="relative inline-flex items-center gap-1.5 px-3 py-2 text-sm font-medium text-gray-700 dark:text-gray-300 bg-white dark:bg-gray-800 border border-gray-300 dark:border-gray-600 rounded-lg hover:bg-gray-50 dark:hover:bg-gray-700 focus:outline-none focus:ring-2 focus:ring-purple-500 focus:border-purple-500 transition-colors shadow-sm hover:shadow">
                <span><?php echo __('pagination.next'); ?></span>
                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-4 h-4">
                    <path stroke-linecap="round" stroke-linejoin="round" d="m8.25 4.5 7.5 7.5-7.5 7.5" />
                </svg>
            </a>
        <?php else: ?>
            <span class="relative inline-flex items-center gap-1.5 px-3 py-2 text-sm font-medium text-gray-400 dark:text-gray-600 bg-gray-100 dark:bg-gray-800 border border-gray-300 dark:border-gray-600 cursor-default rounded-lg">
                <span><?php echo __('pagination.next'); ?></span>
                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-4 h-4">
                    <path stroke-linecap="round" stroke-linejoin="round" d="m8.25 4.5 7.5 7.5-7.5 7.5" />
                </svg>
            </span>
        <?php endif; ?>
    </nav>
<?php endif; ?>
<?php /**PATH C:\Users\User\Desktop\Laravel\Internlink\resources\views\vendor\pagination\simple-tailwind.blade.php ENDPATH**/ ?>