import { FormDataConvertible, Method, Progress, VisitOptions } from '@inertiajs/core';
type setDataByObject<TForm> = (data: TForm) => void;
type setDataByMethod<TForm> = (data: (previousData: TForm) => TForm) => void;
type setDataByKeyValuePair<TForm> = <K extends keyof TForm>(key: K, value: TForm[K]) => void;
type FormDataType = Record<string, FormDataConvertible>;
type FormOptions = Omit<VisitOptions, 'data'>;
export interface InertiaFormProps<TForm extends FormDataType> {
    data: TForm;
    isDirty: boolean;
    errors: Partial<Record<keyof TForm, string>>;
    hasErrors: boolean;
    processing: boolean;
    progress: Progress | null;
    wasSuccessful: boolean;
    recentlySuccessful: boolean;
    setData: setDataByObject<TForm> & setDataByMethod<TForm> & setDataByKeyValuePair<TForm>;
    transform: (callback: (data: TForm) => object) => void;
    setDefaults(): void;
    setDefaults(field: keyof TForm, value: FormDataConvertible): void;
    setDefaults(fields: Partial<TForm>): void;
    reset: (...fields: (keyof TForm)[]) => void;
    clearErrors: (...fields: (keyof TForm)[]) => void;
    setError(field: keyof TForm, value: string): void;
    setError(errors: Record<keyof TForm, string>): void;
    submit: (method: Method, url: string, options?: FormOptions) => void;
    get: (url: string, options?: FormOptions) => void;
    patch: (url: string, options?: FormOptions) => void;
    post: (url: string, options?: FormOptions) => void;
    put: (url: string, options?: FormOptions) => void;
    delete: (url: string, options?: FormOptions) => void;
    cancel: () => void;
}
export default function useForm<TForm extends FormDataType>(initialValues?: TForm): InertiaFormProps<TForm>;
export default function useForm<TForm extends FormDataType>(rememberKey: string, initialValues?: TForm): InertiaFormProps<TForm>;
export {};
