

<?php $__env->startSection('content'); ?>
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">

                        <li class="breadcrumb-item"><a href="<?php echo e(route('sales.index')); ?>">Hasil Jualan</a></li>
                        <li class="breadcrumb-item active">Tambah Jualan</li>
                    </ol>
                </div>
                <h4 class="page-title">Pengurusan Jualan</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->


    <div class="row">
        <div class="col-xl-12">
            <div class="card">
                <div class="card-body">
                    <?php if($errors->any()): ?>
                        <div class="alert alert-danger">
                            <ul>
                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><?php echo e($error); ?></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    <?php endif; ?>
                    <h4 class="header-title mb-3"> Maklumat Jualan</h4>

                    <form role="form" method="POST" action="<?php echo e(route('sales.store')); ?>" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div id="basicwizard">
                            <ul class="nav nav-pills nav-justified form-wizard-header mb-4">
                                <li class="nav-item">
                                    <a href="#basictab1" data-toggle="tab" class="nav-link rounded-0 pt-2 pb-2">
                                        <i class="mdi mdi-checkerboard-plus mr-1"></i>
                                        <span class="d-none d-sm-inline">Kebun</span>
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a href="#basictab2" data-toggle="tab" class="nav-link rounded-0 pt-2 pb-2">
                                        <i class="mdi mdi-barley mr-1"></i>
                                        <span class="d-none d-sm-inline">Hasil</span>
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a href="#basictab3" data-toggle="tab" class="nav-link rounded-0 pt-2 pb-2">
                                        <i class="mdi mdi-bottle-tonic-plus-outline mr-1"></i>
                                        <span class="d-none d-sm-inline">Pembeli</span>
                                    </a>
                                </li>
                            </ul>

                            <div class="tab-content b-0 mb-0">
                                <div class="tab-pane" id="basictab1">
                                    <div class="row">
                                        <div class="col-12">
                                            
                                            <div class="form-row">
                                                <div class="form-group col-md-6">
                                                    <label for="inputKebun" class="col-form-label">Nama Kebun</label>
                                                    <select id="inputKebun" name="harvest_id" class="form-control" onchange="updatePlantationDetails()">
                                                        <option selected>Sila Pilih</option>
                                                        <?php $__currentLoopData = $harvests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $harvest): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($harvest->id); ?>" 
                                                                data-plant-type="<?php echo e($harvest->plantation->plantDetail->plant_type); ?>"
                                                                data-quantity-plant="<?php echo e($harvest->plantation->quantity_plant); ?>"
                                                                data-quantity-weight="<?php echo e($harvest->total_weight); ?>"
                                                                data-available-quantiti-a="<?php echo e($harvest->grade_a_available); ?>"
                                                                data-available-quantiti-b="<?php echo e($harvest->grade_b_available); ?>"
                                                                data-available-quantiti-c="<?php echo e($harvest->grade_c_available); ?>">
                                                                <?php echo e($harvest->plantation->farm->name); ?>

                                                            </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                </div>
                                                <div class="form-group col-md-6 ">
                                                    <label for="inputNamaPokok" class="col-form-label">Nama Pokok</label>
                                                    <input type="text" class="form-control" id="inputNamaPokok"
                                                        name="plant_type">
                                                </div>
                                            </div>

                                            <div class="form-row">
                                                <div class="form-group col-md-6">
                                                    <label for="InputBilanganTuaian" class="col-form-label">Bilangan
                                                        Pokok (Tandan)</label>
                                                    <input type="number" class="form-control" id="InputBilanganTuaian"
                                                        name="quantity_plant">
                                                </div>
                                                <div class="form-group col-md-6">
                                                    <label for="InputJumlahTuaian" class="col-form-label">Jumlah
                                                        Tuaian (Kg)</label>
                                                    <input type="number" class="form-control" id="InputJumlahTuaian"
                                                        name="total_weight">
                                                </div>
                                            </div>
                                        </div> <!-- end col -->
                                    </div> <!-- end row -->
                                    <ul class="list-inline wizard mb-0">
                                        <li class="previous list-inline-item">
                                            <button type="button" onclick="history.back()"
                                                class="btn btn-light mr-3">Kembali</button>
                                        </li>
                                        <li class="next list-inline-item float-right">
                                            <a href="#" class="btn btn-primary">Seterusnya</a>
                                        </li>
                                    </ul>
                                </div>
                                
                                <div class="tab-pane" id="basictab2">
                                    <div class="row">
                                        
                                        <div class="col-12">
                                            <div class="form-row">
                                                
                                                <input type="hidden" name="price_id" value="<?php echo e($price->id); ?>">
                                                <div class="form-group col-md-2">
                                                    <label for="InputAvailableQuantitiA" class="col-form-label">Gred
                                                        A:</label>
                                                    <input type="number" class="form-control" name="grade_a_available"
                                                        id="InputAvailableQuantitiA" readonly>
                                                </div>
                                                <div class="form-group col-md-3">
                                                    <label for="InputGredASale" class="col-form-label">Bil Jual</label>
                                                    <input type="number" class="form-control" id="InputGredASale"
                                                        name="grade_a_sale" placeholder="Eg:50 Kg">
                                                </div>
                                                <div class="form-group col-md-3">
                                                    <label for="InputPriceA" class="col-form-label">Harga (RM)</label>
                                                    <input type="number" class="form-control" id="InputPriceA"
                                                        name="grade_a_price" value="<?php echo e($price->grade_a_price); ?>">
                                                </div>
                                                <div class="form-group col-md-4">
                                                    <label for="InputTotalSaleA" class="col-form-label">Jumlah Gred
                                                        A</label>
                                                    <input type="number" class="form-control" name="total_sale_grade_a"
                                                        id="InputTotalSaleA" readonly>
                                                </div>

                                                
                                                <div class="form-group col-md-2">
                                                    <label for="InputAvailableQuantitiB" class="col-form-label">
                                                        Gred B</label>
                                                    <input type="number" class="form-control" name="grade_b_available"
                                                        id="InputAvailableQuantitiB" readonly>
                                                </div>
                                                <div class="form-group col-md-3">
                                                    <label for="InputGredBSale" class="col-form-label">Bil Jual</label>
                                                    <input type="number" class="form-control" id="InputGredBSale"
                                                        name="grade_b_sale" placeholder="Eg:50 Kg">
                                                </div>
                                                <div class="form-group col-md-3">
                                                    <label for="InputPriceB" class="col-form-label">Harga (RM)</label>
                                                    <input type="number" class="form-control" id="InputPriceB"
                                                        name="grade_b_price" value="<?php echo e($price->grade_b_price); ?>">
                                                </div>
                                                <div class="form-group col-md-4">
                                                    <label for="InputTotalSaleB" class="col-form-label">Jumlah
                                                        Gred B</label>
                                                    <input type="number" class="form-control" name="total_sale_grade_b"
                                                        id="InputTotalSaleB" readonly>
                                                </div>

                                                
                                                <div class="form-group col-md-2">
                                                    <label for="InputAvailableQuantitiC" class="col-form-label">
                                                        Gred C</label>
                                                    <input type="number" class="form-control" name="grade_c_available"
                                                        id="InputAvailableQuantitiC" readonly>
                                                </div>
                                                <div class="form-group col-md-3">
                                                    <label for="InputGredCSale" class="col-form-label">Bil Jual</label>
                                                    <input type="number" class="form-control" id="InputGredCSale"
                                                        name="grade_c_sale" placeholder="Eg:50 Kg">
                                                </div>
                                                <div class="form-group col-md-3">
                                                    <label for="InputPriceC" class="col-form-label">Harga (RM)</label>
                                                    <input type="number" class="form-control" id="InputPriceC"
                                                        name="grade_c_price" value="<?php echo e($price->grade_c_price); ?>">
                                                </div>
                                                <div class="form-group col-md-4">
                                                    <label for="InputTotalSaleC" class="col-form-label">Jumlah
                                                        Gred C</label>
                                                    <input type="number" class="form-control" name="total_sale_grade_c"
                                                        id="InputTotalSaleC" readonly>
                                                </div>
                                                <div class="form-group col-md-8">
                                                    <h5 class="text-dark" style="text-align: right;">Jumlah Keseluruhan:
                                                    </h5>
                                                </div>
                                                <div class="form-group col-md-4">
                                                    <input type="number" class="form-control" id="InputTotalSale"
                                                        placeholder="RM" name="total_sale" readonly>
                                                </div>
                                            </div>
                                        </div> <!-- end col -->
                                    </div> <!-- end row -->
                                    <ul class="list-inline wizard mb-0">
                                        <li class="previous list-inline-item">
                                            <a href="#" class="btn btn-light">Sebelum</a>
                                        </li>
                                        <li class="next list-inline-item float-right">
                                            <a href="#" class="btn btn-primary">Seterusnya</a>
                                        </li>
                                    </ul>
                                </div>
                                
                                <div class="tab-pane" id="basictab3">
                                    <div class="row">
                                        <div class="col-12">
                                            <div class="form-row">
                                                <div class="form-group col-md-12">
                                                    <label for="inputNamaSyarikat" class="col-form-label">Nama
                                                        Syarikat</label>
                                                    <select id="inputNamaSyarikat" name="customer_id"
                                                        class="form-control" onchange="updateBuyerDetails()">
                                                        <option selected>Sila Pilih</option>
                                                        <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($customer->id); ?>"
                                                                data-customer="<?php echo e($customer->customer_name); ?>"
                                                                data-phone="<?php echo e($customer->phone_number); ?>"
                                                                data-address="<?php echo e($customer->address); ?>">
                                                                <?php echo e($customer->company_name); ?>

                                                            </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                </div>
                                                <div class="form-group col-md-6">
                                                    <label for="InputNamaPembeli" class="col-form-label">Nama
                                                        Pembeli</label>
                                                    <input type="text" class="form-control" id="InputNamaPembeli"
                                                        value="Eg:Hairil Bin Anuar" name="customer_name">
                                                </div>
                                                <div class="form-group col-md-6">
                                                    <label for="InputNoTelefon" class="col-form-label">No
                                                        Telefon</label>
                                                    <input type="text" class="form-control" id="InputNoTelefon"
                                                        value="Eg: 0123456789" name="phone_number">
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <label for="InputAlamat">Alamat</label>
                                                <textarea class="form-control" name="address" id="InputAlamat" rows="5"></textarea>
                                            </div>


                                            <ul class="list-inline wizard mb-0">
                                                <li class="previous list-inline-item">
                                                    <a href="#" class="btn btn-light">Sebelum</a>
                                                </li>
                                                <li class="next list-inline-item float-right">
                                                    <button type="submit" class="btn btn-primary mr-3">Simpan</button>
                                                </li>
                                            </ul>
                                        </div> <!-- end row -->

                                    </div>



                                </div> <!-- tab-content -->
                            </div> <!-- end #basicwizard-->
                    </form>
                </div> <!-- end card-body -->
            </div> <!-- end card-->
        </div> <!-- end col -->
    </div>

    <Script>
        function updatePlantationDetails() {
            const farmSelect = document.getElementById('inputKebun');
            const selectedOption = farmSelect.options[farmSelect.selectedIndex];
    
    
            const plantType = selectedOption.getAttribute('data-plant-type');
            const quantityPlant = selectedOption.getAttribute('data-quantity-plant');
            const quantityWeight = selectedOption.getAttribute('data-quantity-weight');
            const AvailableA = selectedOption.getAttribute('data-available-quantiti-a');
            const AvailableB = selectedOption.getAttribute('data-available-quantiti-b');
            const AvailableC = selectedOption.getAttribute('data-available-quantiti-c');
    
            // Update the category and size input fields
            document.getElementById('inputNamaPokok').value = plantType || '';
            document.getElementById('InputBilanganTuaian').value = quantityPlant || '';
            document.getElementById('InputJumlahTuaian').value = quantityWeight || '';
            document.getElementById('InputAvailableQuantitiA').value = AvailableA || '';
            document.getElementById('InputAvailableQuantitiB').value = AvailableB || '';
            document.getElementById('InputAvailableQuantitiC').value = AvailableC || '';
    
    
        }
    </Script>
    
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Function to calculate total quantity
            function calculateTotalQuantity() {
                const gradeA = parseInt(document.getElementById('InputGredASale').value) || 0;
                const gradeB = parseInt(document.getElementById('InputGredBSale').value) || 0;
                const gradeC = parseInt(document.getElementById('InputGredCSale').value) || 0;
                const priceA = parseFloat(document.getElementById('InputPriceA').value) || 0;
                const priceB = parseFloat(document.getElementById('InputPriceB').value) || 0;
                const priceC = parseFloat(document.getElementById('InputPriceC').value) || 0;
    
                const totalGradeA = gradeA * priceA;
                const totalGradeB = gradeB * priceB;
                const totalGradeC = gradeC * priceC;
    
                // Update the total sale fields
                document.getElementById('InputTotalSaleA').value = totalGradeA.toFixed(
                    2); // Format to 2 decimal places
                document.getElementById('InputTotalSaleB').value = totalGradeB.toFixed(
                    2); // Format to 2 decimal places
                document.getElementById('InputTotalSaleC').value = totalGradeC.toFixed(
                    2); // Format to 2 decimal places
    
                // Optionally, calculate the overall total
                const overallTotal = totalGradeA + totalGradeB + totalGradeC;
                document.getElementById('InputTotalSale').value = overallTotal.toFixed(2); // Update overall total
            }
    
            // Attach event listeners to grade input fields
            document.getElementById('InputGredASale').addEventListener('input', calculateTotalQuantity);
            document.getElementById('InputGredBSale').addEventListener('input', calculateTotalQuantity);
            document.getElementById('InputGredCSale').addEventListener('input', calculateTotalQuantity);
            document.getElementById('InputPriceA').addEventListener('input', calculateTotalQuantity);
            document.getElementById('InputPriceB').addEventListener('input', calculateTotalQuantity);
            document.getElementById('InputPriceC').addEventListener('input', calculateTotalQuantity);
        });
    </script>
    
    
    
    <Script>
        function updateBuyerDetails() {
            const companySelect = document.getElementById('inputNamaSyarikat');
            const selectedOption = companySelect.options[companySelect.selectedIndex];
    
    
            const customer = selectedOption.getAttribute('data-customer');
            const phone = selectedOption.getAttribute('data-phone');
            const address = selectedOption.getAttribute('data-address');
    
    
            // Update the category and size input fields
            document.getElementById('InputNamaPembeli').value = customer || '';
            document.getElementById('InputNoTelefon').value = phone || '';
            document.getElementById('InputAlamat').value = address || '';
    
    
        }
    </Script>
    
<?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\desa-grow-farm\resources\views/sales/create.blade.php ENDPATH**/ ?>