@extends('layouts.base')

@section('content')
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('sales.index') }}">Hasil Jualan</a></li>
                        <li class="breadcrumb-item active">Papar Jualan</li>
                    </ol>
                </div>
                <h4 class="page-title">Pengurusan Jualan</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->

    <div class="row">
        <div class="col-sm-12">
            <div class="card">
                <div class="card-body">
                    <h4 class="header-title"> Hasil Jual (Kuantiti)</h4>
                    <!-- HTML -->
                    <div id="chartdiv"></div>

                </div> <!-- end card body-->
            </div> <!-- end card -->
        </div><!-- end col-->


    </div>
    <!-- end row-->

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="card text-white bg-info overflow-hidden" style="padding-left:2%;">
                        <div class="row">
                            <div class="col-6">
                                <!-- assignee -->
                                <p class="mt-2 mb-1 text-white font-weight-bold font-12 text-uppercase">Syarikat
                                </p>
                                <div class="media">
                                    <i class="dripicons-user text-white"></i> &nbsp;
                                    <div class="media-body">
                                        <h5 class="mt-1 font-14">
                                            {{ $sale->customer->company_name }}
                                        </h5>
                                    </div>
                                </div>
                                <!-- end assignee -->
                            </div> <!-- end col -->

                            <div class="col-6">
                                <!-- start due date -->
                                <p class="mt-2 mb-1 text-white font-weight-bold font-12 text-uppercase">Tarikh Jual</p>
                                <div class="media">
                                    <i class="uil uil-schedule font-18 text-white mr-1"></i>
                                    <div class="media-body">
                                        <h5 class="mt-1 font-14">
                                            {{ $sale->created_at->format('d-m-Y') }}
                                        </h5>
                                    </div>
                                </div>
                                <!-- end due date -->
                            </div> <!-- end col -->
                        </div> <!-- end row -->


                    </div>
                    <br>
                    <h6 class="text-dark">MAKLUMAT PEMBELI:</h6>
                    <div class="form-row">
                        <div class="form-group col-md-6">
                            <label for="inputEmail4" class="col-form-label">Nama Pembeli</label>
                            <input type="text" class="form-control" id="inputEmail4"
                                value="{{ $sale->customer->customer_name }}">
                        </div>
                        <div class="form-group col-md-6 ">
                            <label for="inputEmail4" class="col-form-label">Telefon Bimbit</label>
                            <input type="email" class="form-control" id="inputEmail4"
                                value="{{ $sale->customer->phone_number }}">
                        </div>
                    </div>

                    <div class="form-row">
                        <div class="form-group col-md-6">
                            <label for="inputState" class="col-form-label">Kategori Pokok</label>
                            <input type="email" class="form-control" id="inputEmail4"
                                value="{{ $sale->harvest->plantation->farm->category->name }}">
                        </div>

                        <div class="form-group col-md-6">
                            <label for="inputState" class="col-form-label">Jenis Pokok</label>
                            <input type="email" class="form-control" id="inputEmail4"
                                value="{{ $sale->harvest->plantation->plantDetail->plant_type }}">
                        </div>
                    </div>

                    <div class="table-responsive mt-4">
                        <h6 class="text-dark">MAKLUMAT HASIL:</h6>

                        <table class="table table-bordered table-centered mb-0">
                            <thead class="thead-light">
                                <tr>
                                    <th>Gred</th>
                                    <th>Harga (Seunit)</th>
                                    <th>Kuantiti</th>
                                    <th>Jumlah (RM)</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>Gred A</td>
                                    <td>{{ $sale->price->grade_a_price ?? 'Tiada Data' }}</td>
                                    <td>{{ $sale->grade_a_sale ?? 'Tiada Data' }}</td>
                                    <td>{{ $sale->total_sale_grade_a ?? 'Tiada Data' }}</td>
                                </tr>
                                <tr>
                                    <td>Gred B</td>
                                    <td>{{ $sale->price->grade_b_price ?? 'Tiada Data' }}</td>
                                    <td>{{ $sale->grade_b_sale ?? 'Tiada Data' }}</td>
                                    <td>{{ $sale->total_sale_grade_b ?? 'Tiada Data' }}</td>
                                </tr>
                                <tr>
                                    <td>Gred C</td>
                                    <td>{{ $sale->price->grade_c_price ?? 'Tiada Data' }}</td>
                                    <td>{{ $sale->grade_c_sale ?? 'Tiada Data' }}</td>
                                    <td>{{ $sale->total_sale_grade_c ?? 'Tiada Data' }}</td>
                                </tr>

                                <tr class="text-dark">
                                    <th></th>
                                    <th style="text-align: right;"></th>
                                    <th style="text-align: right;">Keseluruhan (RM)</th>
                                    <th>{{ $sale->total_sale ?? 'Tiada Data' }}</th>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                    <br>
                    <div class="text-center mt-2">
                        <button type="button" onclick="history.back()" class="btn btn-info">Kembali</button>
                    </div>
                </div>
            </div> <!-- end card body-->
        </div> <!-- end card -->
    </div><!-- end col-->
    </div><!-- end row-->



    <!-- Styles -->
    <style>
        #chartdiv {
            width: 100%;
            height: 290px;
        }
    </style>

    <!-- Resources -->
    <script src="https://cdn.amcharts.com/lib/5/index.js"></script>
    <script src="https://cdn.amcharts.com/lib/5/xy.js"></script>
    <script src="https://cdn.amcharts.com/lib/5/themes/Animated.js"></script>

   
    <script>
        am5.ready(function() {
    
            // Create root element
            var root = am5.Root.new("chartdiv");
    
            // Set themes
            root.setThemes([
                am5themes_Animated.new(root)
            ]);
    
            // Create chart
            var chart = root.container.children.push(am5xy.XYChart.new(root, {
                panX: true,
                panY: true,
                wheelX: "panX",
                wheelY: "zoomX",
                pinchZoomX: true,
                paddingLeft: 0,
                paddingRight: 1
            }));
    
            // Add cursor
            var cursor = chart.set("cursor", am5xy.XYCursor.new(root, {}));
            cursor.lineY.set("visible", false);
    
            // Create axes
            var xRenderer = am5xy.AxisRendererX.new(root, {
                minGridDistance: 30,
                minorGridEnabled: true
            });
    
            xRenderer.labels.template.setAll({
                rotation: -90,
                centerY: am5.p50,
                centerX: am5.p100,
                paddingRight: 15
            });
    
            xRenderer.grid.template.setAll({
                location: 1
            });
    
            var xAxis = chart.xAxes.push(am5xy.CategoryAxis.new(root, {
                maxDeviation: 0.3,
                categoryField: "grade", // Use 'grade' for the x-axis
                renderer: xRenderer,
                tooltip: am5.Tooltip.new(root, {})
            }));
    
            var yRenderer = am5xy.AxisRendererY.new(root, {
                strokeOpacity: 0.1
            });
    
            var yAxis = chart.yAxes.push(am5xy.ValueAxis.new(root, {
                maxDeviation: 0.3,
                renderer: yRenderer
            }));
    
            // Create series
            var series = chart.series.push(am5xy.ColumnSeries.new(root, {
                name: "Sales",
                xAxis: xAxis,
                yAxis: yAxis,
                valueYField: "value", // Use 'value' for the y-axis
                sequencedInterpolation: true,
                categoryXField: "grade", // Use 'grade' for the x-axis
                tooltip: am5.Tooltip.new(root, {
                    labelText: "{categoryX}: {valueY}"
                })
            }));
    
            series.columns.template.setAll({
                cornerRadiusTL: 5,
                cornerRadiusTR: 5,
                strokeOpacity: 0
            });
    
            series.columns.template.adapters.add("fill", function(fill, target) {
                return chart.get("colors").getIndex(series.columns.indexOf(target));
            });
    
            series.columns.template.adapters.add("stroke", function(stroke, target) {
                return chart.get("colors").getIndex(series.columns.indexOf(target));
            });
    
            // Set data
            var data = @json($chartData); // Use the chart data from PHP
            xAxis.data.setAll(data);
            series.data.setAll(data);
    
            // Make stuff animate on load
            series.appear(1000);
            chart.appear(1000, 100);
    
        }); // end am5.ready()
    </script>
@endsection
