@extends('layouts.base')

@section('content')
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('damage.index') }}">Aduan</a></li>
                        <li class="breadcrumb-item active">Papar Aduan</li>
                    </ol>
                </div>
                <h4 class="page-title">Pengurusan Aduan</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <h4 class="header-title">Maklumat Aduan</h4>
                    <div class="row">
                        <div class="col-lg-5">
                            <!-- Product image -->
                            <a href="javascript: void(0);" class="text-center d-block mb-4">
                                <img src="{{ Storage::url($damage->image) }}" class="img-fluid img-thumbnail"
                                    alt="aduan-img" style="width: 100%; height:350px;" />
                            </a>
                        </div> <!-- end col -->

                        <div class="col-lg-7">
                            <form class="pl-lg-4">
                                <!--  title -->
                                <h3 class="mt-0">{{ $damage->damage_category }}</h3>
                                <p class="mb-1">Tarikh Hantar: {{ $damage->created_at->format('d F Y') }}</p>

                                <!-- status-->
                                <div class="mt-3">
                                    @if ($damage->status == 'Baru')
                                        <h4> <span class="badge badge-danger-lighten">Aduan Baru</span></h4>
                                    @elseif ($damage->status == 'Serah Tugas')
                                        <h4> <span class="badge badge-warning-lighten">Serah Tugas</span></h4>
                                    @elseif ($damage->status == 'Dalam Kerja')
                                        <h4> <span class="badge badge-info-lighten">Dalam Kerja</span></h4>
                                    @elseif ($damage->status == 'Selesai')
                                        <h4> <span class="badge badge-success-lighten">Selesai</span></h4>
                                    @endif

                                </div>

                                <!-- Product description -->
                                <div class="mt-4">
                                    <h6 class="font-14">Penerangan:</h6>
                                    <p>{{ $damage->damage_description }}</p>
                                </div>

                                <!-- Product information -->
                                <div class="mt-4">
                                    <div class="row">
                                        <div class="col-md-4">
                                            <h6 class="font-14">Lokasi:</h6>
                                            <p class="text-sm lh-150">{{ $damage->plantation->farm->name }}</p>
                                        </div>
                                        <div class="col-md-4">
                                            <h6 class="font-14">Jenis Kebun:</h6>
                                            <p class="text-sm lh-150">{{ $damage->plantation->farm->category->name }}
                                                {{ $damage->plantation->plantDetail->plant_type }}</p>
                                        </div>

                                        <div class="col-md-4">
                                            <h6 class="font-14">Pengadu:</h6>
                                            <p class="text-sm lh-150">{{ $damage->worker->name }}</p>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div> <!-- end col -->
                    </div> <!-- end row-->
                    @if ($damage->status == 'Serah Tugas' || $damage->status == 'Dalam Kerja' ||$damage->status == 'Selesai'  )
                        <div class="table-responsive mt-4">
                            <h4 class="header-title">Maklumat Tugas</h4>
                            <table class="table table-bordered table-centered mb-0">
                                <thead class="thead-light">
                                    <tr>
                                        <th>Penyelesaian</th>
                                        @if ($damage->solution_category == 'Jumpa Tuan Kebun')
                                            <th>Keterangan Penyelesaian</th>
                                        @endif
                                        <th>Tarikh Tugasan</th>
                                        @if ($damage->solution_category == 'Meracun' && $damage->status == 'Selesai')
                                            <th>Bukti Penyelesaian</th>
                                        @endif
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>
                                            @if ($damage->solution_category == 'Meracun')
                                                <div class="media">
                                                    <i class="dripicons-pill text-danger"></i>&nbsp;
                                                    <div class="media-body">
                                                        <h5 class="mt-1 font-14">
                                                            {{ $damage->solution_category }}
                                                        </h5>
                                                    </div>
                                                </div>
                                            @elseif ($damage->solution_category == 'Jumpa Tuan Kebun')
                                                <div class="media">
                                                    <i class=" dripicons-user text-danger"></i>&nbsp;
                                                    <div class="media-body">
                                                        <h5 class="mt-1 font-14">
                                                            {{ $damage->solution_category }}
                                                        </h5>
                                                    </div>
                                                </div>
                                            @endif
                                        </td>
                                        @if ($damage->solution_category == 'Jumpa Tuan Kebun')
                                            <td>{{ $damage->solution_description ?? 'Tiada Rekod' }}</td>
                                        @endif
                                        <td>
                                            <div class="media">
                                                <i class="uil uil-schedule font-18 text-success mr-1"></i>
                                                <div class="media-body">
                                                    <h5 class="mt-1 font-14">
                                                        {{ \Carbon\Carbon::parse($damage->assign_date)->format('d F Y') }}
                                                    </h5>
                                                </div>
                                        </td>
                                        @if ($damage->solution_category == 'Meracun' && $damage->status == 'Selesai')
                                            <td>
                                                <p class="form-control-plaintext">
                                                    <button type="button" class="btn btn-sm btn-secondary"
                                                        data-toggle="modal" data-target="#bs-example-modal-sm"
                                                        onclick="showImage('{{ Storage::url($damage->image_work) }}')">Papar</button>
                                                </p>
                                            </td>

                                            <!-- Small modal -->
                                            <div class="modal fade" id="bs-example-modal-sm" tabindex="-1" role="dialog"
                                                aria-labelledby="mySmallModalLabel" aria-hidden="true">
                                                <div class="modal-dialog modal-sm">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h4 class="modal-title" id="mySmallModalLabel"> Gambar
                                                                Penyelesaian
                                                            </h4>
                                                            <button type="button" class="close" data-dismiss="modal"
                                                                aria-hidden="true">×</button>
                                                        </div>
                                                        <div class="modal-body text-center">
                                                            <img id="workImage" src="" class="img-fluid"
                                                                style="max-width: 150px;" alt="Penyelesaian Image" />
                                                        </div>
                                                    </div><!-- /.modal-content -->
                                                </div><!-- /.modal-dialog -->
                                            </div><!-- /.modal -->
                                        @endif
                                    </tr>
                                </tbody>
                            </table>
                            <br>
                            @if ($damage->solution_category == 'Meracun')
                                <h4 class="header-title">Maklumat Racun</h4>
                                <table class="table table-bordered table-centered mb-0">
                                    <thead class="thead-light">
                                        <tr>
                                            <th>Nama </th>
                                            <th>Quantiti</th>
                                            <th>Keterangan</th>
                                            <th>Gambar Baja</th>

                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td>{{ $damage->pestControl->pestControlDetail->pest_name ?? 'Tiada Racun Terpilih' }}
                                            </td>
                                            <td>{{ $damage->pestControl->amount }} {{ $damage->pestControl->amount_type }}
                                            </td>
                                            <td>{{ $damage->pestControl->description }}</td>
                                            <td>
                                                <p class="form-control-plaintext">
                                                    <button type="button" class="btn btn-sm btn-secondary"
                                                        data-toggle="modal" data-target="#bs2-example-modal-sm"
                                                        onclick="showFertilizerImage('{{ Storage::url($damage->pestControl->pestControlDetail->image) }}')">Papar</button>
                                                </p>
                                            </td>

                                            <!-- Small modal -->
                                            <div class="modal fade" id="bs2-example-modal-sm" tabindex="-1" role="dialog"
                                                aria-labelledby="mySmallModalLabel" aria-hidden="true">
                                                <div class="modal-dialog modal-sm">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h4 class="modal-title" id="mySmallModalLabel"> Gambar
                                                                Baja
                                                            </h4>
                                                            <button type="button" class="close" data-dismiss="modal"
                                                                aria-hidden="true">×</button>
                                                        </div>
                                                        <div class="modal-body text-center">
                                                            <img id="fertilizerImage" src="" class="img-fluid"
                                                                style="max-width: 150px;" alt="Baja Image" />
                                                        </div>
                                                    </div><!-- /.modal-content -->
                                                </div><!-- /.modal-dialog -->
                                            </div><!-- /.modal -->
                                        </tr>

                                    </tbody>
                                </table>
                        </div> <!-- end table-responsive-->
                    @endif
                    @endif
                    <div class="text-center mt-2">
                        @if (auth()->user()->role === 'Tuan_Kebun')
                            <button type="button" onclick="history.back()" class="btn btn-info mr-3">Kembali</button>
                        @elseif (auth()->user()->role === 'Pekerja')
                            <button type="button" onclick="history.back()" class="btn btn-primary mr-3">Kembali</button>
                        @endif
                    </div>

                </div><!-- end card-body-->
            </div><!-- end card-->
        </div><!-- end col-->
    </div> <!-- end row-->

    <script>
        function showImage(imageUrl) {
            // Set the image source in the modal
            document.getElementById('workImage').src = imageUrl;
        }

        function showFertilizerImage(imageUrl) {
            // Set the image source in the modal
            document.getElementById('fertilizerImage').src = imageUrl;
        }
    </script>
    <style>
        /* Optional: Add some styles for the modal */
        .modal-body {
            padding: 20px;
            /* Add padding for better spacing */
        }

        /* Ensure the image has a consistent size */
        #fertilizerImage {
            width: 100%;
            /* Full width of the modal */
            height: 300px;
            /* Fixed height */
            object-fit: cover;
            /* Cover the area while maintaining aspect ratio */
            border-radius: 5px;
            /* Rounded corners */
        }

        #workImage {
            width: 100%;
            /* Full width of the modal */
            height: 300px;
            /* Fixed height */
            object-fit: cover;
            /* Cover the area while maintaining aspect ratio */
            border-radius: 5px;
            /* Rounded corners */
        }
    </style>
@endsection
