@extends('layouts.base')

@section('content')
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="javascript: void(0);">Pengurusan</a></li>
                        <li class="breadcrumb-item"><a href="admin-create">Pengguna</a></li>
                        <li class="breadcrumb-item active">Tambah Pengguna</li>
                    </ol>
                </div>
                <h4 class="page-title">Pengurusan Pengguna</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <h4 class="header-title">Tambah Pengguna</h4>
                    <form action="{{ route('admin.users.store') }}" method="POST">
                        @csrf
                        <br>
                        <div class="form-row">
                            <div class="form-group col-md-12">
                                <label for="name" class="col-form-label">Nama Pengguna</label>
                                <input type="text" class="form-control" id="name" name="name" placeholder="Eg: Siman Bin Ali" required>
                            </div>
                            <div class="form-group col-md-6">
                                <label for="email" class="col-form-label">Email</label>
                                <input type="email" class="form-control" id="email" name="email" placeholder="Eg: penanam2@gmail.com" required>
                            </div>
                            <div class="form-group col-md-6">
                                <label for="phone" class="col-form-label">Telefon</label>
                                <input type="text" class="form-control" id="phone" name="phone" placeholder="Nombor Telefon" required>
                            </div>
    
                        </div>

                        <div class="form-row">
                            <div class="form-group col-md-6">
                                <label for="password" class="col-form-label">Kata Laluan</label>
                                <input type="password" class="form-control" id="password" name="password" placeholder="Eg: penanam123" required>
                            </div>
                            <div class="form-group col-md-6">
                                <label for="password_confirmation" class="col-form-label">Sahkan Kata Laluan</label>
                                <input type="password" class="form-control" id="password_confirmation" name="password_confirmation" placeholder="Sahkan Kata Laluan" required>
                            </div>
                        </div>
                        <div class="form-row">
                            <div class="form-group col-md-6">
                                <label for="role" class="col-form-label">Peranan</label>
                                <select id="role" name="role" class="form-control" required>
                                    <option value="">Sila Pilih</option>
                                    <option value="Pekerja">Pekerja</option>
                                    <option value="Tuan_Kebun">Tuan Kebun</option>
                                </select>
                            </div>
                            <div class="form-group col-md-6">
                                <label for="job_type" class="col-form-label">Jenis Pekerjaan</label>
                                <select id="job_type" name="job_type" class="form-control" required>
                                    <option value="">Sila Pilih</option>
                                    <option value="Pengopek">Pengopek</option>
                                    <option value="Pengait">Pengait</option>
                                    <option value="Penanam">Penanam</option>
                                    <option value="Tiada">Tiada</option>
                                </select>
                            </div>

                            <div class="form-group col-md-12">
                                <label for="address" class="col-form-label">Alamat</label>
                                <textarea class="form-control" name="address" id="example-textarea" rows="5" required></textarea>
                            </div>
                        </div>

                      

                       

                        <div class="text-center mt-2">
                            <button type="button" onclick="history.back()" class="btn btn-light mr-3">Batal</button>
                            <button type="submit" class="btn btn-primary">Simpan</button>
                        </div>
                    </form>
                    @if (session('success'))
                        <div class="alert alert-success mt-3">{{ session('success') }}</div>
                    @endif
                </div> <!-- end card body-->
            </div> <!-- end card -->
        </div><!-- end col-->
    </div>
    <!-- end row-->
@endsection