<?php

namespace App\Http\Controllers;

use App\Models\Price;
use Illuminate\Http\Request;

class PriceController extends Controller
{
    public function index()
    {
        $prices = Price::orderBy('created_at', 'asc')->get();
        $latestGradeA = Price::latest('created_at')->value('grade_a_price');
        $latestGradeB = Price::latest('created_at')->value('grade_b_price');
        $latestGradeC = Price::latest('created_at')->value('grade_c_price');

        return view('price.index', [
            'prices' => $prices,
            'latestGradeA' => $latestGradeA,
            'latestGradeB' => $latestGradeB,
            'latestGradeC' => $latestGradeC,
        ])->with('success', session('success'));
    }

    public function create()
    {
        $price = Price::all();
        return view('price.create', compact('price'));
    }


    public function store(Request $request)
    {

        $price = new Price();
        $request->validate([
            'grade_a_price' => 'required|numeric',
            'grade_b_price' => 'required|numeric',
            'grade_c_price' => 'required|numeric',
        ]);

        // Update the price's attributes
        $price->grade_a_price = $request->grade_a_price;
        $price->grade_b_price = $request->grade_b_price;
        $price->grade_c_price = $request->grade_c_price;




        // Save the updated price details
        $price->save();

        // Redirect back to the index page with a success message
        return redirect()->route('price.index')->with('success', 'Gred Harga Berjaya Dikemaskini.');
    }

    public function show($id)
    {
        $price = Price::find($id);
        return view('price.index', compact('price'));
    }

    public function update(Request $request, $id)
    {

        $request->validate([
            'grade_a_price' => 'required|numeric',
            'grade_b_price' => 'required|numeric',
            'grade_c_price' => 'required|numeric',
        ]);

        // Find the price by ID
        $price = Price::findOrFail($id);

        // Update the price's attributes
        $price->grade_a_price = $request->grade_a_price;
        $price->grade_b_price = $request->grade_b_price;
        $price->grade_c_price = $request->grade_c_price;




        // Save the updated price details
        $price->save();

        // Redirect back to the index page with a success message
        return redirect()->route('price.index')->with('success', 'Gred Harga Berjaya Dikemaskini.');
    }
}
