

<?php $__env->startSection('content'); ?>
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="javascript: void(0);"> Racun</a></li>
                        <li class="breadcrumb-item"><a href="<?php echo e(route('pest.index')); ?>">Racun</a></li>
                        <li class="breadcrumb-item active">Tambah Kuantiti Racun</li>
                    </ol>
                </div>
                <h4 class="page-title"> Maklumat Racun</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <h4 class="header-title">Sila Isi Maklumat Dibawah.</h4> <br>
                    <div class="nav nav-pills nav-justified form-wizard-header mb-1 bg-info text-white"
                        style="padding-left:2%; padding-top:1%; padding-bottom:1%;">
                        <div class="row">
                            <!-- header plant detail -->
                            <div class="media">
                                <i class="uil uil-trees text-white font-weight-bold font-12 text-uppercase"></i> &nbsp;
                                <div class="media-body">
                                    <h5 class="mt-1 font-14">
                                        Maklumat Pokok
                                    </h5>
                                </div>
                            </div>
                            <!-- end header plant detail -->
                        </div> <!-- end row -->
                    </div>
                    <?php if($errors->any()): ?>
                        <div class="alert alert-danger">
                            <ul>
                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><?php echo e($error); ?></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    <?php endif; ?>
                    <form role="form" method="POST" action="<?php echo e(route('pest.store')); ?>" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div class="form-row">
                            <div class="form-group col-md-6">
                                <label for="inputState" class="col-form-label">Kategori Pokok</label>
                                <select id="plant_category" name="plant_category" class="form-control"
                                    onchange="updatePlantTypes(); updatePestTypes();">
                                    <option value="">Sila Pilih</option>
                                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($category->id); ?>"><?php echo e($category->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>

                            <div class="form-group col-md-6">
                                <label for="inputNamaPokok" class="col-form-label">Nama Pokok</label>
                                <select id="inputNamaPokok" name="plant_type" class="form-control" required>
                                    <option value="">Sila Pilih</option>
                                    <!-- Options will be populated by JavaScript -->
                                </select>
                            </div>

                        </div>
                        <br>
                        <!-- Initial Maklumat Racun section -->
                        <div class="nav nav-pills nav-justified form-wizard-header mb-1 bg-info text-white"
                            style="padding-left:2%; padding-top:1%; padding-bottom:1%;">
                            <div class="row">
                                <!-- header plant detail -->
                                <div class="media">
                                    <i class="uil uil-trees text-white font-weight-bold font-12 text-uppercase"></i>
                                    &nbsp;
                                    <div class="media-body">
                                        <h5 class="mt-1 font-14 ">
                                            Maklumat Racun
                                        </h5>
                                    </div>
                                </div>
                                <!-- end header plant detail -->
                            </div> <!-- end row -->
                        </div>
                        <div class="form-row">
                            <div class="form-group col-md-6">
                                <label for="inputKategoriRacun" class="col-form-label">Jenis Racun</label>
                                <select id="inputKategoriRacun" name="pest_type" class="form-control">
                                    <option value="">Sila Pilih</option>
                                    <!-- Options will be populated by JavaScript -->
                                </select>
                            </div>
                            <div class="form-group col-md-6">
                                <label for="inputNamaRacun" class="col-form-label">Nama Racun</label>
                                <select id="inputNamaRacun" name="pest_name" class="form-control">
                                    <option value="">Sila Pilih</option>
                                    <!-- Options will be populated by JavaScript -->
                                </select>
                            </div>
                        </div>
                        <div class="form-row">
                            <div class="form-group col-md-6">
                                <label for="inputQuantitiRacun" class="col-form-label">Quantiti Racun</label>
                                <input type ="number" name="amount" class="form-control" id="inputQuantitiRacun" min="1" max="5000"
                                    placeholder="Eg: 200">
                            </div>
                            <div class="form-group col-md-6">
                                <label for="inputJenisKuantiti" class="col-form-label">Jenis Kuantiti</label>
                                <select name="amount_type" class="form-control">
                                    <option selected>Sila Pilih</option>
                                    <option value="l/ha">l/ha</option>
                                    <option value="ml/ha">ml/ha</option>
                                    <option value="kg/ha">kg/ha</option>
                                    <option value="g/ha">g/ha</option>
                                </select>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="example-textarea">Keterangan</label>
                            <textarea class="form-control" name="description" id="example-textarea" rows="5"></textarea>
                        </div>

                        <div class="text-center mt-2">
                            <button type="button" onclick="history.back()" class="btn btn-light mr-3">Batal</button>
                            <button type="submit" class="btn btn-info">Simpan</button>
                        </div>
                    </form>
                </div> <!-- end card body-->
            </div> <!-- end card -->
        </div><!-- end col-->
    </div>

    <script>
        const plantDetails = <?php echo json_encode($plantDetails, 15, 512) ?>;
        const pestControlDetails = <?php echo json_encode($pestControlDetails, 15, 512) ?>;
        const pestCategories = <?php echo json_encode($pestCategories, 15, 512) ?>;

        function updatePlantTypes() {
            const categorySelect = document.getElementById('plant_category');
            const plantTypeSelect = document.getElementById('inputNamaPokok');
            const selectedCategoryId = categorySelect.value;

            // Clear previous options
            plantTypeSelect.innerHTML = '<option value="">Sila Pilih</option>';

            if (selectedCategoryId && plantDetails[selectedCategoryId]) {
                plantDetails[selectedCategoryId].forEach(plant => {
                    const option = document.createElement('option');
                    option.value = plant.id; // Use the plant's id here
                    option.textContent = plant.plant_type; // Display the plant type
                    plantTypeSelect.appendChild(option);
                });
            }

            // Clear maturity options when category changes
            updatePestType();
        }

        // Attach event listener to plant type select
        document.getElementById('inputNamaPokok').addEventListener('change', updatePestType);



        function updatePestType() {
            const categorySelect = document.getElementById('plant_category');
            const pestTypeSelect = document.getElementById('inputKategoriRacun');
            const selectedCategoryId = categorySelect.value;

            // Clear previous options
            pestTypeSelect.innerHTML = '<option value="">Sila Pilih</option>';

            if (selectedCategoryId && pestControlDetails[selectedCategoryId]) {
                const uniquePestCategories = new Set();

                pestControlDetails[selectedCategoryId].forEach(pest => {
                    // Add the pest category ID to the Set
                    uniquePestCategories.add(pest.pest_category.id);
                });

                // Populate the select with unique pest categories
                uniquePestCategories.forEach(categoryId => {
                    const option = document.createElement('option');
                    option.value = categoryId; // Use the category ID
                    option.textContent = pestControlDetails[selectedCategoryId].find(p => p.pest_category.id ==
                        categoryId).pest_category.name; // Display the pest category name
                    pestTypeSelect.appendChild(option);
                });
            }

            // Clear pest name options when category changes
            updatePestNames();
        }

        function updatePestNames() {
            const pestTypeSelect = document.getElementById('inputKategoriRacun');
            const pestNameSelect = document.getElementById('inputNamaRacun');
            const selectedPestTypeId = pestTypeSelect.value;

            // Clear previous name options
            pestNameSelect.innerHTML = '<option value="">Sila Pilih</option>';

            if (selectedPestTypeId) {
                // Loop through the pestControlDetails to find the pests that match the selected pest type ID
                for (const categoryId in pestControlDetails) {
                    const pests = pestControlDetails[categoryId];

                    // Filter pests that match the selected pest type ID
                    const matchingPests = pests.filter(pest => pest.pest_category.id == selectedPestTypeId);

                    // Populate the pest name select with matching pests
                    matchingPests.forEach(pest => {
                        const option = document.createElement('option');
                        option.value = pest.id; // Assuming 'id' holds the pest ID
                        option.textContent = pest.pest_name; // Assuming 'pest_name' holds the pest name
                        pestNameSelect.appendChild(option);
                    });

                    // Exit the loop once we have processed the relevant category
                    break;
                }
            }
        }
        // Attach event listeners
        document.getElementById('plant_category').addEventListener('change', updatePestType);
        document.getElementById('inputKategoriRacun').addEventListener('change', updatePestNames);
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\desa-grow-farm\resources\views/pest/create.blade.php ENDPATH**/ ?>