
    <header>
        <h4 class="text-lg font-medium text-gray-900">
            <?php echo e(__('Kemaskini Kata Laluan')); ?>

        </h4>

        <p class="mt-1 text-sm text-gray-600">
            <?php echo e(__('Pastikan anda menggunakan kata laluan rawak kekal selamat.')); ?>

        </p>
    </header>

    
        <!-- Password Update Form -->
        <form method="post" action="<?php echo e(route('password.update')); ?>" class="mt-6 space-y-6">
            <?php echo csrf_field(); ?>
            <?php echo method_field('put'); ?>
    
            <!-- Current Password Field -->
            <div class="form-group col-md-12">
                <label for="update_password_current_password" class="form-label"><?php echo e(__('Kata Laluan Semasa')); ?></label>
                <input id="update_password_current_password" name="current_password" type="password" class="form-control" autocomplete="current-password" />
                <?php if($errors->updatePassword->has('current_password')): ?>
                    <div class="text-danger mt-2">
                        <?php echo e($errors->updatePassword->first('current_password')); ?>

                    </div>
                <?php endif; ?>
            </div>
    
            <!-- New Password Field -->
            <div class="form-group col-md-12">
                <label for="update_password_password" class="form-label"><?php echo e(__('Kata Laluan Baru')); ?></label>
                <input id="update_password_password" name="password" type="password" class="form-control" autocomplete="new-password" />
                <?php if($errors->updatePassword->has('password')): ?>
                    <div class="text-danger mt-2">
                        <?php echo e($errors->updatePassword->first('password')); ?>

                    </div>
                <?php endif; ?>
            </div>
    
            <!-- Confirm Password Field -->
            <div class="form-group col-md-12">
                <label for="update_password_password_confirmation" class="form-label"><?php echo e(__('Sahkan Kata Laluan')); ?></label>
                <input id="update_password_password_confirmation" name="password_confirmation" type="password" class="form-control" autocomplete="new-password" />
                <?php if($errors->updatePassword->has('password_confirmation')): ?>
                    <div class="text-danger mt-2">
                        <?php echo e($errors->updatePassword->first('password_confirmation')); ?>

                    </div>
                <?php endif; ?>
            </div>
    
            <!-- Save Button -->
            <div class="form-group col-md-12">
                <button type="submit" class="btn btn-primary"><?php echo e(__('Kemaskini Kata Laluan')); ?></button>
    
                <?php if(session('status') === 'password-updated'): ?>
                    <p
                        x-data="{ show: true }"
                        x-show="show"
                        x-transition
                        x-init="setTimeout(() => show = false, 2000)"
                        class="text-sm text-gray-600"
                    ><?php echo e(__('Saved.')); ?></p>
                <?php endif; ?>
            </div>
        </form>
    

<?php /**PATH C:\laragon\www\desa-grow-farm\resources\views/profile/partials/update-password-form.blade.php ENDPATH**/ ?>