@extends('layouts.base')

@section('content')
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <h4 class="page-title">Rekod Jualan</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->


    <div class="row">
        <div class="col-12">
            <div class="card widget-inline">
                <div class="card-body p-0">
                    <div class="row no-gutters">
                        <div class="col">
                            <div class="card shadow-none m-0">
                                <div class="card-body bg-success text-center">
                                    <i class="mdi mdi-cash-multiple text-white" style="font-size: 24px;"></i>
                                    <h3  class="text-white"><span>RM {{ number_format($totalSales, 2) }}</span></h3>
                                    <p class="text-white font-15 mb-0">Jumlah Jualan</p>
                                </div>
                            </div>
                        </div>

                        <div class="col">
                            <div class="card shadow-none m-0 border-left">
                                <div class="card-body bg-info text-center">
                                    <i class="mdi mdi-alpha-a-box-outline text-white" style="font-size: 24px;"></i>
                                    <h3  class="text-white"><span>RM {{ number_format($totalSalesGradeA, 2) }}</span></h3>
                                    <p class="text-white font-15 mb-0">Gred A</p>
                                </div>
                            </div>
                        </div>
                        <div class="col">
                            <div class="card shadow-none m-0 border-left">
                                <div class="card-body bg-primary text-center">
                                    <i class="mdi mdi-alpha-b-box-outline text-white" style="font-size: 24px;"></i>
                                    <h3  class="text-white"><span>RM {{ number_format($totalSalesGradeB, 2) }}</span></h3>
                                    <p class="text-white font-15 mb-0">Gred B</p>
                                </div>
                            </div>
                        </div>
                        <div class="col">
                            <div class="card shadow-none m-0 border-left">
                                <div class="card-body bg-secondary text-center">
                                    <i class="mdi mdi-alpha-c-box-outline text-white" style="font-size: 24px;"></i>
                                    <h3  class="text-white"><span>RM {{ number_format($totalSalesGradeC, 2) }}</span></h3>
                                    <p class="text-white font-15 mb-0">Gred C</p>
                                </div>
                            </div>
                        </div>
                    </div> <!-- end row -->
                </div>
            </div> <!-- end card-box-->
        </div> <!-- end col-->
    </div>

    <!-- end row-->
    <div class="row">
        <div class="col-sm-6">
            <div class="card">
                <div class="card-body">
                    <!-- HTML -->
                    <h4 class="header-title"> Jualan Tahunan</h4>
                    <div id="chartdiv"></div>
                </div> <!-- end card body-->
            </div> <!-- end card -->
        </div><!-- end col-->

        <div class="col-sm-6">
            <div class="card">
                <div class="card-body">
                    <!-- HTML -->
                    <h4 class="header-title">Gred Jualan</h4>
                    <div id="chartdiv2"></div>
                </div> <!-- end card body-->
            </div> <!-- end card -->
        </div><!-- end col-->
    </div><!-- end row-->


    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <h4 class="header-title">Laporan Jualan</h4>
                        <a href="{{ route('sales.create') }}" class="btn btn-info btn-sm"
                            style="position: absolute; right:2%;">+Tambah Jualan</a>
                        <br><br>
                    </div>

                    <table id="basic-datatable" class="table dt-responsive nowrap w-100">
                        <thead>
                            <tr>
                            <tr>
                                <th>Bil.</th>
                                <th>Tarikh Pembelian</th>
                                <th>Jenis Pokok</th>
                                <th>Pembeli</th>
                                <th>Jumlah Jual</th>
                                <th>Tindakan</th>
                            </tr>
                            </tr>
                        </thead>


                        <tbody>
                            @foreach ($sales as $sale)
                                <tr>
                                    <td>{{ $loop->index + 1 }}</td>
                                    <td>{{ $sale->created_at->format('d-m-Y') }}</td>
                                    <td>{{ $sale->harvest->plantation->plantDetail->plant_type }}</td>
                                    <td>{{ $sale->customer->company_name }}</td>
                                    <td>RM {{ $sale->total_sale }}</td>
                                    <td class="table-action">
                                        {{-- <a href="{{ route('sales.edit', $sales->id) }}" class="action-icon"> <i
                                            class="mdi mdi-file-document-edit"></i></a> --}}
                                        <a href="{{ route('sales.show', $sale->id) }}" class="action-icon"> <i
                                                class="mdi mdi-eye-check text-primary"></i></a>
                                        <a href="{{ route('sales.receipt', $sale->id) }}" class="action-icon"> <i
                                                class="mdi mdi-printer text-danger"></i></a>

                                    </td>
                                </tr>
                        </tbody>
                        @endforeach
                    </table>
                </div> <!-- end card body-->
            </div> <!-- end card -->
        </div><!-- end col-->
    </div>
    <!-- end row-->

    <!-- Styles -->
    <style>
        #chartdiv,
        #chartdiv2 {
            width: 100%;
            height: 250px;
        }
    </style>

    <!-- Resources -->
    <script src="https://cdn.amcharts.com/lib/5/index.js"></script>
    <script src="https://cdn.amcharts.com/lib/5/xy.js"></script>
    <script src="https://cdn.amcharts.com/lib/5/themes/Animated.js"></script>
    <script src="https://cdn.amcharts.com/lib/5/percent.js"></script>


    <!-- Chart code -->
    <script>
        am5.ready(function() {

            // Create root element
            var root = am5.Root.new("chartdiv");

            const myTheme = am5.Theme.new(root);

            // Move minor label a bit down
            myTheme.rule("AxisLabel", ["minor"]).setAll({
                dy: 1
            });

            // Tweak minor grid opacity
            myTheme.rule("Grid", ["minor"]).setAll({
                strokeOpacity: 0.08
            });

            // Set themes
            root.setThemes([
                am5themes_Animated.new(root),
                myTheme
            ]);

            // Create chart
            var chart = root.container.children.push(am5xy.XYChart.new(root, {
                panX: false,
                panY: false,
                wheelX: "panX",
                wheelY: "zoomX",
                paddingLeft: 0
            }));

            // Add cursor
            var cursor = chart.set("cursor", am5xy.XYCursor.new(root, {
                behavior: "zoomX"
            }));
            cursor.lineY.set("visible", false);

            // Create axes
            var xAxis = chart.xAxes.push(am5xy.CategoryAxis.new(root, {
                renderer: am5xy.AxisRendererX.new(root, {
                    minGridDistance: 30
                }),
                categoryField: "year" // Use 'year' as the x-axis field
            }));

            var yAxis = chart.yAxes.push(am5xy.ValueAxis.new(root, {
                renderer: am5xy.AxisRendererY.new(root, {})
            }));

            // Add series
            var series = chart.series.push(am5xy.ColumnSeries.new(root, {
                name: "Total Sales",
                xAxis: xAxis,
                yAxis: yAxis,
                valueYField: "value", // Use 'value' for total_sale
                categoryXField: "year", // Use 'year' for the x-axis
                tooltip: am5.Tooltip.new(root, {
                    labelText: "Tahun {categoryX}: RM{valueY}"
                })
            }));

            // Set data
            var data = @json($graphData); // Use the graph data from PHP
            xAxis.data.setAll(data);
            series.data.setAll(data);

            // Make stuff animate on load
            series.appear(1000);
            chart.appear(1000, 100);

        }); // end am5.ready()
    </script>




<script>
    am5.ready(function() {

        // Create root element
        var root = am5.Root.new("chartdiv2");

        // Set themes
        root.setThemes([
            am5themes_Animated.new(root)
        ]);

        // Create chart
        var chart = root.container.children.push(
            am5percent.PieChart.new(root, {
                startAngle: 160,
                endAngle: 380
            })
        );

        // Create series
        var series0 = chart.series.push(
            am5percent.PieSeries.new(root, {
                valueField: "value", // Use 'value' for the sale amount
                categoryField: "grade", // Use 'grade' for the category
                startAngle: 160,
                endAngle: 380,
                radius: am5.percent(70),
                innerRadius: am5.percent(65)
            })
        );

        var colorSet = am5.ColorSet.new(root, {
            colors: [series0.get("colors").getIndex(0)],
            passOptions: {
                lightness: -0.05,
                hue: 0
            }
        });

        series0.set("colors", colorSet);

        series0.ticks.template.set("forceHidden", true);
        series0.labels.template.set("forceHidden", true);

        var series1 = chart.series.push(
            am5percent.PieSeries.new(root, {
                startAngle: 160,
                endAngle: 380,
                valueField: "value", // Use 'value' for the sale amount
                innerRadius: am5.percent(80),
                categoryField: "grade" // Use 'grade' for the category
            })
        );

        series1.ticks.template.set("forceHidden", true);
        series1.labels.template.set("forceHidden", true);

        var label = chart.seriesContainer.children.push(
            am5.Label.new(root, {
                textAlign: "center",
                centerY: am5.p100,
                centerX: am5.p50,
                text: "[fontSize:18px]Total Sales[/]:\n[bold fontSize:30px]{total}[/]"
            })
        );

        // Set data
        var gradeSalesData = @json($gradeSalesData); // Use the grade sales data from PHP
        series0.data.setAll(gradeSalesData);
        series1.data.setAll(gradeSalesData);

        // Calculate total sales for the label
        var totalSales = gradeSalesData.reduce((sum, item) => sum + item.value, 0);
        label.set("text", "[fontSize:18px]Jumlah Jual[/]:\n[bold fontSize:30px]" + totalSales + " Kg[/]");

    }); // end am5.ready()
</script>
@endsection
