
    <header>
        <h4 class="text-lg font-medium text-gray-900">
            {{ __('Maklumat Profil') }}
        </h4>

        <p class="mt-1 text-sm text-gray-600">
            {{ __('Kemaskini maklumat profil dan alamat e-mel akaun anda.') }}
        </p>
    </header>

    <form id="send-verification" method="post" action="{{ route('verification.send') }}">
        @csrf
    </form>

   <form method="post" action="{{ route('profile.update') }}" class="mt-6 space-y-6">
    @csrf
    @method('patch')

    <!-- Name Field -->
    <div class="form-row">
        <div class="form-group col-md-12">
            <label for="name" class="form-label">{{ __('Nama') }}</label>
            <input id="name" name="name" type="text" class="form-control"
                value="{{ old('name', $user->name) }}" required autofocus autocomplete="name" />
            @if ($errors->has('name'))
                <div class="text-danger mt-2">
                    {{ $errors->first('name') }}
                </div>
            @endif
        </div>

        <!-- Email Field -->
        <div class="form-group col-md-6">
            <label for="email" class="form-label">{{ __('Emel') }}</label>
            <input id="email" name="email" type="email" class="form-control"
                value="{{ old('email', $user->email) }}" required autocomplete="username" />
            @if ($errors->has('email'))
                <div class="text-danger mt-2">
                    {{ $errors->first('email') }}
                </div>
            @endif

            <!-- Email Verification Notice -->
            @if ($user instanceof \Illuminate\Contracts\Auth\MustVerifyEmail && !$user->hasVerifiedEmail())
                <div class="mt-2">
                    <p class="text-sm text-gray-800">
                        {{ __('Your email address is unverified.') }}

                        <button form="send-verification"
                            class="btn btn-link p-0 text-sm text-gray-600 hover:text-gray-900">
                            {{ __('Click here to re-send the verification email.') }}
                        </button>
                    </p>

                    @if (session('status') === 'verification-link-sent')
                        <p class="mt-2 text-sm text-success">
                            {{ __('A new verification link has been sent to your email address.') }}
                        </p>
                    @endif
                </div>
            @endif
        </div>

         <!-- Phone Field -->
         <div class="form-group col-md-6">
            <label for="phone" class="form-label">{{ __('Telefon') }}</label>
            <input id="phone" name="phone" type="text" class="form-control"
                value="{{ old('phone', $user->phone) }}" autocomplete="phone" />
            @if ($errors->has('phone'))
                <div class="text-danger mt-2">
                    {{ $errors->first('phone') }}
                </div>
            @endif
        </div>
         <!-- Role Field (Readonly) -->
         <div class="form-group col-md-6">
            <label for="role" class="form-label">{{ __('Peranan') }}</label>
            <input id="role" name="role" type="text" class="form-control"
                value="{{ $user->role }}" readonly />
        </div>

        <!-- Job Type Field (Readonly) -->
        @if ($user->job_type)
            <div class="form-group col-md-6">
                <label for="job_type" class="form-label">{{ __('Jenis Kerja') }}</label>
                <input id="job_type" name="job_type" type="text" class="form-control"
                    value="{{ $user->job_type }}" readonly />
            </div>
        @endif

        <!-- Address Field -->
        <div class="form-group col-md-12">
            <label for="address" class="form-label">{{ __('Alamat') }}</label>
            <textarea class="form-control" name="address" id="example-textarea" rows="5">{{ old('address', $user->address) }}</textarea>
            @if ($errors->has('address'))
                <div class="text-danger mt-2">
                    {{ $errors->first('address') }}
                </div>
            @endif
        </div>

       
        <!-- Save Button -->
        <div class="form-group col-md-12">
            <button type="submit" class="btn btn-primary">{{ __('Simpan') }}</button>
            @if (session('status') === 'profile-updated')
                <p x-data="{ show: true }" x-show="show" x-transition x-init="setTimeout(() => show = false, 2000)"
                    class="text-sm text-gray-600">{{ __('Saved.') }}</p>
            @endif
        </div>
    </div>
</form>

