@extends('layouts.base')

@section('content')
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="javascript: void(0);">Pengurusan</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('pest-detail.index') }}">Racun</a></li>
                        <li class="breadcrumb-item active">Tambah Racun</li>
                    </ol>
                </div>
                <h4 class="page-title">Pengurusan Racun</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <h4 class="header-title">Tambah Racun</h4>
                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                    <form role="form" method="POST" action="{{ route('pest-detail.store') }}"
                        enctype="multipart/form-data">
                        @csrf
                        <div class="form-row">
                            <div class="form-group col-md-12">
                                <label for="inputState" class="col-form-label">Kategori Pokok</label>
                                <select id="plant_category" name="plant_category" class="form-control">
                                    <option value="">Sila Pilih</option>
                                    @foreach ($categories as $category)
                                        <option value="{{ $category->id }}">{{ $category->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="form-group col-md-6">
                                <label for="inputState" class="col-form-label">Jenis Racun</label>
                                <select id="pest_category" name="pest_category" class="form-control">
                                    <option value="">Sila Pilih</option>
                                    @foreach ($pestCategory as $pest)
                                    <option value="{{ $pest->id }}">{{ $pest->name }}</option>
                                @endforeach
                                </select>
                            </div>
                            <div class="form-group col-md-6">
                                <label for="inputEmail4" class="col-form-label">Nama Racun</label>
                                <input type="name" name="pest_name" class="form-control" id="inputEmail4"
                                    placeholder="Eg: Matta Kombat">
                            </div>
                        </div>


                        <div class="form-group">

                            <div class="form-group ">
                                <label for="pdf" class="col-form-label">Upload Dokumen</label>
                                <input type="file" name="image" class="form-control" accept="image/">
                            </div>

                            <div class="text-center mt-2">
                                <button type="button" onclick="history.back()" class="btn btn-light mr-3">Batal</button>
                                <button type="submit" class="btn btn-info">Simpan</button>
                            </div>
                        </div> <!-- end card body-->
                    </form>
                </div> <!-- end card -->
            </div><!-- end col-->
        </div>
        <!-- end row-->
    @endsection
