@extends('layouts.base')

@section('content')
    <!-- Display success message -->
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <h4 class="page-title">Rekod</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->

    <div class="row">

        <!-- Fertilizer Count by Category -->
        @foreach ($fertilizer_categories as $category)
            <div class="col">
                @if ($category->name == 'Tumbesaran')
                    <div class="card widget-flat bg-info text-white ">
                        <div class="card-body">
                            <div class="float-right">
                                <i class=" mdi mdi-keg widget-icon bg-light text-info"></i>
                            </div>
                            <h5 class="text-uppercase mt-0" title="Growth"> {{ $category->name }}</h5>
                            <h3 class="mt-3 mb-3">{{ $fertilizerCountByCategory[$category->id] ?? 0 }} Baja
                            </h3>
                        </div>
                    </div>
                @elseif($category->name == 'Akar Pokok')
                    <div class="card widget-flat bg-secondary text-white">
                        <div class="card-body">
                            <div class="float-right">
                                <i class="mdi mdi-keg widget-icon bg-light text-secondary"></i>
                            </div>
                            <h5 class="text-uppercase mt-0" title="Growth"> {{ $category->name }}</h5>
                            <h3 class="mt-3 mb-3">{{ $fertilizerCountByCategory[$category->id] ?? 0 }} Baja
                            </h3>
                        </div>
                    </div>
                @elseif($category->name == 'Buah')
                    <div class="card widget-flat bg-warning text-white">
                        <div class="card-body">
                            <div class="float-right">
                                <i class="mdi mdi-keg widget-icon bg-light text-warning"></i>
                            </div>
                            <h5 class="text-uppercase mt-0" title="Growth"> {{ $category->name }}</h5>
                            <h3 class="mt-3 mb-3">{{ $fertilizerCountByCategory[$category->id] ?? 0 }} Baja
                            </h3>
                        </div>
                    </div>
                @elseif($category->name == 'Matang')
                    <div class="card widget-flat bg-danger text-white">
                        <div class="card-body">
                            <div class="float-right">
                                <i class="mdi mdi-keg widget-icon bg-light text-danger"></i>
                            </div>
                            <h5 class="text-uppercase mt-0" title="Growth"> {{ $category->name }}</h5>
                            <h3 class="mt-3 mb-3">{{ $fertilizerCountByCategory[$category->id] ?? 0 }} Baja
                            </h3>
                        </div>
                    </div>
                @endif
            </div> <!-- end col-->
        @endforeach

        <!-- Overall Total Fertilizers -->
        <div class="col">
            <div class="card widget-flat bg-success text-white">
                <div class="card-body">
                    <div class="float-right">
                        <i class="mdi mdi-kettlebell widget-icon bg-light text-success"></i>
                    </div>
                    <h5 class="text-uppercase mt-0" title="Growth">Jumlah Baja</h5>
                    <h3 class="mt-3 mb-3">{{ $totalFertilizers }} Baja
                    </h3>
                </div>
            </div>
        </div>
    </div>
    <!-- end row-->

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <h4 class="header-title">Baja</h4>
                        <a href="{{ route('fertilizer-detail.create') }}" class="btn btn-info btn-sm"
                            style="position: absolute; right:2%;">+Tambah Baja</a>
                        <br><br>
                    </div>


                    <table id="basic-datatable" class="table dt-responsive nowrap w-100">
                        <thead>
                            <tr>
                                <th>Bil</th>
                                <th>Nama </th>
                                <th>Jenis Baja</th>
                                <th>Papar Gambar</th>
                                <th>Tindakan</th>
                            </tr>
                        </thead>


                        <tbody>
                            @foreach ($fertilizerDetail as $fertilizer)
                                <tr>
                                    <td>{{ $loop->index + 1 }}.</td>
                                    <td>{{ $fertilizer->fertilizer_name }}</td>
                                    <!-- Default badge for fertilizer categories -->
                                    <td>
                                        @if ($fertilizer->fertilizerCategory->name == 'Tumbesaran')
                                            <span class="badge badge-warning">Tumbesaran</span>
                                        @elseif ($fertilizer->fertilizerCategory->name == 'Akar Pokok')
                                            <span class="badge badge-primary">Akar Pokok</span>
                                        @elseif ($fertilizer->fertilizerCategory->name == 'Matang')
                                            <span class="badge badge-info">Matang</span>
                                        @elseif ($fertilizer->fertilizerCategory->name == 'Buah')
                                            <span class="badge badge-secondary">Buah</span>
                                        @endif
                                    </td>
                                    <td><a href="{{ Storage::url($fertilizer->image) }}" target="_blank">Lihat Baja</a>
                                    </td>
                                    <td class="table-action">
                                        <a href="javascript: void(0);" class="action-icon text-info" data-toggle="modal"
                                            data-target="#edit-modal-{{ $fertilizer->id }}"> <i
                                                class="mdi mdi-file-document-edit"></i></a>
                                        <a href="javascript: void(0);" class="action-icon" data-toggle="modal"
                                            data-target="#delete-modal-{{ $fertilizer->id }}"
                                            data-id="{{ $fertilizer->id }}">
                                            <i class="mdi mdi-delete text-danger"></i>
                                        </a>
                                    </td>
                                </tr>
                                <!-- Edit modal -->
                                <div id="edit-modal-{{ $fertilizer->id }}" class="modal fade" tabindex="-1" role="dialog"
                                    aria-hidden="true">
                                    <div class="modal-dialog ">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h4 class="modal-title" id="editModalLabel">Kemaskini Maklumat Baja
                                                </h4>
                                                <button type="button" class="close" data-dismiss="modal"
                                                    aria-hidden="true">×</button>
                                            </div>
                                            <div class="modal-body">
                                                <form action="{{ route('fertilizer-detail.update', $fertilizer->id) }}"
                                                    method="POST" enctype="multipart/form-data">
                                                    @csrf
                                                    @method('PUT')
                                                    <div class="form-row">
                                                        <div class="form-group col-md-6">
                                                            <label for="inputState" class="col-form-label">Kategori
                                                                Pokok</label>
                                                            <select id="plant_category" name="plant_category"
                                                                class="form-control">
                                                                <option value="">Sila Pilih</option>
                                                                @foreach ($categories as $category)
                                                                    <option value="{{ $category->id }}"
                                                                        {{ $category->id == $fertilizer->category->id ? 'selected' : '' }}>
                                                                        {{ $category->name }}
                                                                    </option>
                                                                @endforeach
                                                            </select>
                                                        </div>

                                                        <div class="form-group col-md-6">
                                                            <label for="fertilizer_type" class="col-form-label">Kegunaan
                                                                Baja</label>
                                                            <select id="fertilizer_category" name="fertilizer_category"
                                                                class="form-control">
                                                                @foreach ($fertilizer_categories as $fertilizer_category)
                                                                    <option value="{{ $fertilizer_category->id }}"
                                                                        {{ $fertilizer_category->id == $fertilizer->fertilizerCategory->id ? 'selected' : '' }}>
                                                                        {{ $fertilizer_category->name }}
                                                                    </option>
                                                                @endforeach
                                                            </select>
                                                        </div>

                                                        <div class="form-group col-md-12">
                                                            <label for="inputEmail4" class="col-form-label">Nama
                                                                Pokok</label>
                                                            <input type="text" name="fertilizer_name"
                                                                class="form-control"
                                                                value="{{ $fertilizer->fertilizer_name }}">
                                                        </div>

                                                        <div class="form-group  col-md-12 ">
                                                            <label for="iamge"> Kemaskini Gambar (Pilihan)</label>
                                                            <input type="file" name="image" class="form-control">
                                                            <small class="form-text text-muted">Biarkan kosong jika anda
                                                                tidak mahu menukar.</small>
                                                        </div>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-light"
                                                            data-dismiss="modal">Batal</button>
                                                        <button type="submit" class="btn btn-info">Kemaskini</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div><!-- /.modal-content -->
                                    </div><!-- /.modal-dialog -->
                                </div><!-- /.modal -->

                                <!-- Delete modal -->
                                <div id="delete-modal-{{ $fertilizer->id }}" class="modal fade" tabindex="-1"
                                    role="dialog" aria-hidden="true">
                                    <div class="modal-dialog ">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h4 class="modal-title" id="deleteModalLabel">Padam Maklumat Baja
                                                </h4>
                                                <button type="button" class="close" data-dismiss="modal"
                                                    aria-hidden="true">×</button>
                                            </div>
                                            <div class="modal-body">
                                                <p>Adakah anda mahu memadam maklumat ini?</p>
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-light btn-sm"
                                                    data-dismiss="modal">Tidak, Batal</button>
                                                <form method="POST"
                                                    action="{{ route('fertilizer-detail.destroy', $fertilizer->id) }}">
                                                    @csrf
                                                    @method('DELETE')
                                                    <input type="hidden" name="fertilizer_detail_id"
                                                        value="{{ $fertilizer->id }}">
                                                    <button type="submit" class="btn btn-danger btn-sm">Betul,
                                                        Padam</button>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div><!-- /.modal -->
                            @endforeach
                        </tbody>
                    </table>
                </div> <!-- end card body-->
            </div> <!-- end card -->
        </div><!-- end col-->
    </div>
    <!-- end row-->
@endsection
