<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('harvests', function (Blueprint $table) {
            $table->id();
            $table->foreignId('plantation_id'); // Foreign key to plantation
            $table->date('harvest_date')->nullable(); // Harvest date
            $table->integer('grade_a_quantity')->default(0); // Quantity for Grade A
            $table->integer('grade_b_quantity')->default(0); // Quantity for Grade B
            $table->integer('grade_c_quantity')->default(0);// Quantity for Grade C
            $table->integer('grade_reject_quantity')->default(0); 
            $table->integer('grade_a_weight')->default(0); // Quantity for Grade A
            $table->integer('grade_b_weight')->default(0); // Quantity for Grade B
            $table->integer('grade_c_weight')->default(0); // Quantity for Grade C
            $table->integer('grade_reject_weight')->default(0);
            $table->integer('total_weight')->default(0); // Total quantity
            $table->integer('grade_a_available')->default(0)->nullable();
            $table->integer('grade_b_available')->default(0);
            $table->integer('grade_c_available')->default(0);
            $table->enum('status', ['Kira Hasil', 'Jual',])->default('Kira Hasil'); // Status of the plantation
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('harvests');
    }
};
