    

    <?php $__env->startSection('content'); ?>
        <!-- start page title -->
        <div class="row">
            <div class="col-12">
                <div class="page-title-box">
                    <h4 class="page-title">Rekod</h4>
                </div>
            </div>
        </div>
        <!-- end page title -->

        <div class="row">
            <div class="col-lg-6 col-xl-4">
                <div class="card widget-flat bg-success text-white">
                    <div class="card-body">
                        <div class="float-right">
                            <i class="dripicons-pamphlet widget-icon bg-white text-info"></i>
                        </div>
                        <h5 class="text-uppercase mt-0" title="Growth">Jumlah Kebun</h5>
                        <h3 class="mt-3 mb-3"><?php echo e($totalFarms); ?> Kebun</h3>
                    </div>
                </div>
            </div> <!-- end col-->
            <div class="col-lg-6 col-xl-4">
                <div class="card widget-flat bg-primary text-white">
                    <div class="card-body">
                        <div class="float-right">
                            <i class="mdi mdi-clipboard-list-outline widget-icon bg-white text-primary"></i>
                        </div>
                        <h5 class="text-uppercase mt-0" title="Growth">Kategori Kebun</h5>
                        <h3 class="mt-3 mb-3"><?php echo e($totalCategories); ?> Kebun</h3>
                    </div>
                </div>
            </div> <!-- end col-->
            <div class="col-lg-6 col-xl-4">
                <div class="card widget-flat bg-secondary text-white">
                    <div class="card-body">
                        <div class="float-right">
                            <i class="mdi mdi-pitchfork widget-icon bg-white text-secondary"></i>
                        </div>
                        <h5 class="text-uppercase mt-0" title="Growth">Tanaman Baru</h5>
                        <h3 class="mt-3 mb-3"><?php echo e($totalFarmsWithPlantations); ?> Kebun</h3>
                    </div>
                </div>
            </div> <!-- end col-->
          
        </div>
        <!-- end row-->

        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="row">
                            <h4 class="header-title">Kebun</h4>
                            <a href="<?php echo e(route('farm.create')); ?>" class="btn btn-primary btn-sm"
                                style="position: absolute; right:2%;">+Tambah Kebun</a>
                            <br><br>
                        </div>


                        <table id="basic-datatable" class="table dt-responsive nowrap w-100">
                            <thead>
                                <tr>
                                    <th>Bil</th>
                                    <th>Nama Kebun</th>
                                    <th>Saiz Kebun</th>
                                    <th>Kategori Kebun</th>
                                    
                                    <th>Dokumen PDF</th>
                                    <th>Tindakan</th>
                                </tr>
                            </thead>


                            <tbody>
                                <?php $__currentLoopData = $farms; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $farm): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($loop->index + 1); ?>.</td>
                                        <td><?php echo e($farm->name); ?></td>
                                        <td><?php echo e($farm->size); ?></td>
                                        <td>
                                            <?php if($farm->category->name == 'Kelapa'): ?>
                                                <span class="badge badge-warning">Kelapa</span>
                                            <?php elseif($farm->category->name == 'Pisang'): ?>
                                                <span class="badge badge-info">Pisang</span>
                                            <?php else: ?>
                                                <span class="badge badge-secondary"><?php echo e($farm->category->name); ?></span>
                                                <!-- Default badge for other categories -->
                                            <?php endif; ?>
                                        </td>
                                        
                                        <td><a href="<?php echo e(Storage::url($farm->pdf)); ?>" target="_blank">Lihat PDF</a></td>
                                        <td class="table-action">

                                            <a href="<?php echo e(route('farm.show', $farm)); ?>" class="action-icon"><i
                                                    class="mdi mdi-eye-check text-primary"></i></a>
                                            <a href="<?php echo e(route('farm.edit', $farm)); ?>" class="action-icon"> <i
                                                    class="mdi mdi-file-document-edit text-info"></i></a>
                                            <a href="javascript: void(0);" class="action-icon" data-toggle="modal"
                                                data-target="#delete-modal" data-id="<?php echo e($farm->id); ?>"> <i
                                                    class="mdi mdi-delete text-danger"></i></a>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                <!-- Delete modal -->
                                <div id="delete-modal" class="modal fade" tabindex="-1" role="dialog" aria-hidden="true">
                                    <div class="modal-dialog ">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h4 class="modal-title" id="deleteModalLabel">Padam Maklumat Kebun
                                                </h4>
                                                <button type="button" class="close" data-dismiss="modal"
                                                    aria-hidden="true">×</button>
                                            </div>
                                            <div class="modal-body">
                                                <p>Adakah anda mahu memadam maklumat ini?</p>
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-light btn-sm" data-dismiss="modal">
                                                    Tidak, Batal
                                                </button>
                                                <form method="POST" action="<?php echo e(route('farm.destroy', $farm->id)); ?>">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                    <button type="submit" class="btn btn-danger btn-sm">Betul,
                                                        Padam</button>
                                                </form>
                                            </div>

                                        </div>
                                    </div>
                                </div><!-- /.modal -->
                                

                            </tbody>
                        </table>
                    </div> <!-- end card body-->
                </div> <!-- end card -->
            </div><!-- end col-->
        </div>
        <!-- end row-->
    <?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\desa-grow-farm\resources\views/farm/index.blade.php ENDPATH**/ ?>