
<?php $__env->startSection('content'); ?>
    <div class="container-fluid">
        <!-- Start page title -->
        <div class="row">
            <div class="col-12">
                <div class="page-title-box">
                    <div class="page-title-right"></div>
                    <h4 class="page-title">Jadual Bertugas</h4>
                </div>
            </div>
        </div>
        <!-- End page title -->

        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-lg-2">
                                <div id="external-events" class="m-t-20">
                                    <br><br><br><br>
                                    <p class="text-muted">Senarai Tugas:</p>
                                    <div class="external-event text-white" style="background-color:#6c757d; ">
                                        <i class="mdi mdi-checkbox-blank-circle mr-2 vertical-middle"></i>Tanam
                                    </div>
                                    <div class="external-event text-white" style="background-color:#28a745; ">
                                        <i class="mdi mdi-checkbox-blank-circle mr-2 vertical-middle"></i>Baja Tumbesaran
                                    </div>
                                    <div class="external-event text-white" style="background-color:#17a2b8; ">
                                        <i class="mdi mdi-checkbox-blank-circle mr-2 vertical-middle"></i>Baja Akar
                                    </div>
                                    <div class="external-event text-white" style="background-color:#ffc107; ">
                                        <i class="mdi mdi-checkbox-blank-circle mr-2 vertical-middle"></i>Baja Buah
                                    </div>
                                    <div class="external-event text-white" style="background-color:#dc3545; ">
                                        <i class="mdi mdi-checkbox-blank-circle mr-2 vertical-middle"></i>Baja Matang
                                    </div>
                                    <div class="external-event text-white" style="background-color:#6610f2; ">
                                        <i class="mdi mdi-checkbox-blank-circle mr-2 vertical-middle"></i>Tuai
                                    </div>
                                   
                                </div>
                            </div> <!-- end col-->

                            <div class="col-lg-10">
                                <div class="mt-4 mt-lg-0">
                                    <div id="calendar"></div>
                                </div>
                            </div> <!-- end col -->
                        </div> <!-- end row -->
                    </div> <!-- end card body-->
                </div> <!-- end card -->
            </div> <!-- end col-12 -->
        </div> <!-- end row -->
    </div> <!-- container -->


    <div class="modal fade" id="eventModal" tabindex="-1" role="dialog" aria-labelledby="eventModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="eventModalLabel">Maklumat Tugasan</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="form-row">
                        <div class="form-group col-6">
                            <label class="col-form-label">Kategori Tugasan</label>
                            <input type="text" name="eventType" class="form-control" id="eventType" readonly>
                        </div>
                        <div class="form-group col-6">
                            <label class="col-form-label">Tarikh</label>
                            <input type="text" name="eventStart" class="form-control" id="eventStart" readonly>
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="form-group col-6">
                            <label class="col-form-label">Nama Kebun</label>
                            <input type="text" name="eventFarm" class="form-control" id="eventFarm" readonly>
                        </div>
                        <div class="form-group col-6">
                            <label class="col-form-label">Jenis Pokok</label>
                            <input type="text" name="eventPlantDetail" class="form-control" id="eventPlantDetail"
                                readonly>
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="form-group col-12">
                            <label class="col-form-label">Pekerja 1</label>
                            <input type="text" name="eventPenanam" class="form-control" id="eventPenanam" readonly>
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="form-group col-12">
                            <label class="col-form-label">Pekerja 2</label>
                            <input type="text" name="eventPengait" class="form-control" id="eventPengait" readonly>
                        </div>
                    </div>
                    <!-- Additional Fields for Fertilization Events -->
                    <div id="fertilizerDetails" style="display: none;">
                        <div class="form-row">
                            <div class="form-group col-12">
                                <label class="col-form-label">Nama Baja</label>
                                <input type="text" name="eventFertilizerName" class="form-control"
                                    id="eventFertilizerName" readonly>
                            </div>
                        </div>
                        <div class="form-row">
                            <div class="form-group col-6">
                                <label class="col-form-label">Kuantiti</label>
                                <input type="text" name="eventAmount" class="form-control" id="eventAmount" readonly>
                            </div>
                            <div class="form-group col-6">
                                <label class="col-form-label">Jenis Kuantiti</label>
                                <input type="text" name="eventAmountType" class="form-control" id="eventAmountType"
                                    readonly>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <!-- Button to View Fertilizer Image -->
                    <button type="button" class="btn btn-primary" id="viewFertilizerImageBtn" style="display: none;">
                        Papar Baja
                    </button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Tutup</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal for Fertilizer Image -->
    <div class="modal fade" id="fertilizerImageModal" tabindex="-1" role="dialog"
        aria-labelledby="fertilizerImageModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-sm" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="fertilizerImageModalLabel">Gambar Baja</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <img id="fertilizerImageDisplay" src="" alt="Fertilizer Image" style="max-width: 150px;">
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Tutup</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Include FullCalendar CSS and JS -->
    <link href="https://cdn.jsdelivr.net/npm/fullcalendar@5.11.3/main.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/fullcalendar@5.11.3/main.min.js"></script>
    <!-- Include Bootstrap JS (required for modal functionality) -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>

    <!-- Initialize the Calendar -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            var calendarEl = document.getElementById('calendar');

            var calendar = new FullCalendar.Calendar(calendarEl, {
                initialView: 'dayGridMonth',
                headerToolbar: {
                    left: 'prev,next today',
                    center: 'title',
                    right: 'dayGridMonth,timeGridWeek,timeGridDay'
                },
                events: <?php echo json_encode($events, 15, 512) ?>,
                eventClick: function(info) {
                    // Populate the modal with event details
                    document.getElementById('eventType').value = info.event.extendedProps.type;
                    document.getElementById('eventFarm').value = info.event.extendedProps.farmName;
                    document.getElementById('eventPlantDetail').value = info.event.extendedProps
                        .plantDetail;
                    document.getElementById('eventStart').value = info.event.start.toLocaleString();

                    // Show penanam and pengait for all event types
                    if (info.event.extendedProps.penanam) {
                        document.getElementById('eventPenanam').value = info.event.extendedProps
                        .penanam;
                        document.getElementById('eventPenanam').closest('.form-group').style.display =
                            'block';
                    } else {
                        document.getElementById('eventPenanam').closest('.form-group').style.display =
                            'none';
                    }

                    if (info.event.extendedProps.pengait) {
                        document.getElementById('eventPengait').value = info.event.extendedProps
                        .pengait;
                        document.getElementById('eventPengait').closest('.form-group').style.display =
                            'block';
                    } else {
                        document.getElementById('eventPengait').closest('.form-group').style.display =
                            'none';
                    }

                    // Show additional fields for fertilization events
                    if (['Tumbesaran', 'Akar', 'Buah', 'Matang'].includes(info.event.extendedProps
                        .type)) {
                        document.getElementById('eventFertilizerName').value = info.event.extendedProps
                            .fertilizer_name;
                        document.getElementById('eventAmount').value = info.event.extendedProps.amount;
                        document.getElementById('eventAmountType').value = info.event.extendedProps
                            .amount_type;
                        document.getElementById('fertilizerDetails').style.display = 'block';

                        // Show the "View Fertilizer Image" button
                        document.getElementById('viewFertilizerImageBtn').style.display =
                        'inline-block';

                        // Set the image source for the fertilizer image modal
                        const imagePath = info.event.extendedProps.fertilizer_image ?
                            info.event.extendedProps
                            .fertilizer_image // Use the full URL from Storage::url
                            :
                            '/images/placeholder.jpg'; // Fallback image
                        document.getElementById('fertilizerImageDisplay').src = imagePath;
                    } else {
                        document.getElementById('fertilizerDetails').style.display = 'none';
                        document.getElementById('viewFertilizerImageBtn').style.display = 'none';
                    }

                    // Show the event details modal
                    var modal = new bootstrap.Modal(document.getElementById('eventModal'));
                    modal.show();
                }
            });

            calendar.render();

            // Add event listener for the "View Fertilizer Image" button
            document.getElementById('viewFertilizerImageBtn').addEventListener('click', function() {
                var fertilizerImageModal = new bootstrap.Modal(document.getElementById(
                    'fertilizerImageModal'));
                fertilizerImageModal.show();
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\desa-grow-farm\resources\views/plantation/schedule.blade.php ENDPATH**/ ?>