@extends('layouts.base')

@section('content')
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="javascript: void(0);">Baja & Racun</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('fertilizer.index') }}">Baja</a></li>
                        <li class="breadcrumb-item active">Tambah Baja</li>
                    </ol>
                </div>
                <h4 class="page-title"> Maklumat Baja</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <h4 class="header-title">Sila Isi Maklumat Dibawah.</h4> <br>
                    <div class="nav nav-pills nav-justified form-wizard-header mb-1 bg-info text-white"
                        style="padding-left:2%; padding-top:1%; padding-bottom:1%;">
                        <div class="row">
                            <!-- header plant detail -->
                            <div class="media">
                                <i class="uil uil-trees text-white font-weight-bold font-12 text-uppercase"></i> &nbsp;
                                <div class="media-body">
                                    <h5 class="mt-1 font-14">
                                        Maklumat Pokok
                                    </h5>
                                </div>
                            </div>
                            <!-- end header plant detail -->
                        </div> <!-- end row -->
                    </div>
                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                    <form role="form" method="POST" action="{{ route('fertilizer.store') }}"
                        enctype="multipart/form-data">
                        @csrf
                        <div id="basicwizard">
                            {{-- pull from plant_details table --}}
                            <div class="form-row">
                                <div class="form-group col-md-12">
                                    <label for="inputState" class="col-form-label">Kategori Pokok</label>
                                    <select id="plant_category" name="plant_category" class="form-control"
                                        onchange="updatePlantTypes(); updateFertilizerTypes();">
                                        <option value="">Sila Pilih</option>
                                        @foreach ($categories as $category)
                                            <option value="{{ $category->id }}">{{ $category->name }}</option>
                                        @endforeach
                                    </select>
                                </div>

                                <div class="form-group col-md-6">
                                    <label for="inputNamaPokok" class="col-form-label">Nama Pokok</label>
                                    <select id="inputNamaPokok" name="plant_type" class="form-control" required>
                                        <option value="">Sila Pilih</option>
                                        <!-- Options will be populated by JavaScript -->
                                    </select>
                                </div>
                                <div class="form-group col-md-6">
                                    <label for="inputTempohKematangan" class="col-form-label">Tempoh Kematangan
                                        (Bulan)</label>
                                    <input type="text" id="inputTempohKematangan" name="plant_maturity"
                                        class="form-control" readonly>
                                </div>
                            </div>

                            <br>

                            <div class="nav nav-pills nav-justified form-wizard-header mb-1 bg-info text-white"
                                style="padding-left:2%; padding-top:1%; padding-bottom:1%;">
                                <div class="row">
                                    <!-- header plant detail -->
                                    <div class="media">
                                        <i class="uil uil-trees text-white font-weight-bold font-12 text-uppercase"></i>
                                        &nbsp;
                                        <div class="media-body">
                                            <h5 class="mt-1 font-14 ">
                                                Maklumat Baja
                                            </h5>
                                        </div>
                                    </div>
                                    <!-- end header plant detail -->
                                </div> <!-- end row -->
                            </div>
                            <div class="tab-pane" id="basictab1">
                                <p class="text-muted font-14"> Sila Isi Maklumat Baja</p>
                                <div class="form-row">
                                    <div class="form-group col-md-7">
                                        <label for="inputKegunaanBaja" class="col-form-label">Kegunaan Baja</label>
                                        <select id="inputKegunaanBaja" name="fertilizer_type" class="form-control">
                                            <option value="">Sila Pilih</option>
                                            <!-- Options will be populated by JavaScript -->
                                        </select>
                                    </div>
                                    <div class="form-group col-md-5">
                                        <label for="inputNamaBaja" class="col-form-label">Nama Baja</label>
                                        <select id="inputNamaBaja" name="fertilizer_name" class="form-control">
                                            <option value="">Sila Pilih</option>
                                            <!-- Options will be populated by JavaScript -->
                                        </select>
                                    </div>
                                </div>
                                <div class="form-row">
                                    <div class="form-group col-md-6">
                                        <label for="inputQuantitiBaja" class="col-form-label">Quantiti Baja</label>
                                        <input type ="number" name="amount" class="form-control" id="inputQuantitiBaja"
                                            placeholder="Eg: 200"  min="1" max="5000">
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label for="inputJenisKuantiti" class="col-form-label">Jenis Kuantiti</label>
                                        <select name="amount_type" class="form-control">
                                            <option selected>Sila Pilih</option>
                                            <option value="l/ha">l/ha</option>
                                            <option value="ml/ha">ml/ha</option>
                                            <option value="kg/ha">kg/ha</option>
                                            <option value="g/ha">g/ha</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="form-row">
                                    <div class="form-group col-md-6">
                                        <label for="inputTempohMembaja" class="col-form-label">Tempoh Membaja</label>
                                        <select name="duration" class="form-control">
                                            <option selected>Sila Pilih</option>
                                            <option value="3 Bulan Pertama">3 Bulan Pertama</option>
                                            <option value="6 Bulan Pertama">6 Bulan Pertama</option>
                                            <option value="Setiap Bulan">Setiap Bulan</option>
                                            <option value="Setahun Sekali">Setahun Sekali</option>
                                        </select>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label for="inputKekerapanBaja" class="col-form-label">Kekerapan Baja (Dalam 1
                                            Bulan)</label>
                                        <input type="number" name="frequency" class="form-control"
                                            id="inputKekerapanBaja" placeholder="Eg: 2 Kali">
                                    </div>
                                </div>
                                <div class="text-center mt-2">
                                    <button type="button" onclick="history.back()"
                                        class="btn btn-light mr-3">Batal</button>
                                    <button type="submit" class="btn btn-info">Simpan</button>
                                </div>
                            </div>
                    </form>
                    {{-- end pull from plant_details table --}}
                </div> <!-- end card body-->
            </div><!-- end card -->
        </div> <!-- end col-->
    </div> <!-- end row-->



    <script>
        const plantDetails = @json($plantDetails);
        const fertilizerDetails = @json($fertilizerDetails);
        const fertilizerCategories = @json($fertilizerCategories);

        function updatePlantTypes() {
            const categorySelect = document.getElementById('plant_category');
            const plantTypeSelect = document.getElementById('inputNamaPokok');
            const selectedCategoryId = categorySelect.value;

            // Clear previous options
            plantTypeSelect.innerHTML = '<option value="">Sila Pilih</option>';

            if (selectedCategoryId && plantDetails[selectedCategoryId]) {
                plantDetails[selectedCategoryId].forEach(plant => {
                    const option = document.createElement('option');
                    option.value = plant.id; // Use the plant's id here
                    option.textContent = plant.plant_type; // Display the plant type
                    plantTypeSelect.appendChild(option);
                });
            }

            // Clear maturity options when category changes
            updateMaturity();
            updateFertilizerTypes();
        }

        // Attach event listener to plant type select
        document.getElementById('inputNamaPokok').addEventListener('change', updateMaturity);
        document.getElementById('inputNamaPokok').addEventListener('change', updateFertilizerTypes);

        function updateMaturity() {
            const plantTypeSelect = document.getElementById('inputNamaPokok');
            const maturityInput = document.getElementById('inputTempohKematangan');
            const selectedPlantTypeId = plantTypeSelect.value;

            // Clear the maturity input field
            maturityInput.value = '';

            if (selectedPlantTypeId) {
                // Find the selected plant in the plantDetails object
                for (const categoryId in plantDetails) {
                    const plants = plantDetails[categoryId];
                    const selectedPlant = plants.find(plant => plant.id == selectedPlantTypeId);

                    if (selectedPlant) {
                        // Set the maturity period for the selected plant
                        maturityInput.value = selectedPlant.plant_maturity + " Bulan"; // Add 'Bulan' to the display text
                        break; // Exit the loop once the plant is found
                    }
                }
            }
        }

        // Attach event listener to plant type select
        document.getElementById('inputNamaPokok').addEventListener('change', updateMaturity);

        function updateFertilizerTypes() {
            const categorySelect = document.getElementById('plant_category');
            const fertilizerTypeSelect = document.getElementById('inputKegunaanBaja');
            const selectedCategoryId = categorySelect.value;

            // Clear previous options
            fertilizerTypeSelect.innerHTML = '<option value="">Sila Pilih</option>';

            if (selectedCategoryId && fertilizerDetails[selectedCategoryId]) {
                const uniqueFertilizerCategories = new Set();

                fertilizerDetails[selectedCategoryId].forEach(fertilizer => {
                    // Add the fertilizer category ID and name to the Set
                    uniqueFertilizerCategories.add(fertilizer.fertilizer_category.id);
                });

                // Populate the select with unique fertilizer categories
                uniqueFertilizerCategories.forEach(categoryId => {
                    const option = document.createElement('option');
                    option.value = categoryId; // Use the category ID
                    option.textContent = fertilizerDetails[selectedCategoryId].find(f => f.fertilizer_category.id ==
                        categoryId).fertilizer_category.name; // Display the fertilizer category name
                    fertilizerTypeSelect.appendChild(option);
                });
            }

            // Clear fertilizer name options when category changes
            updateFertilizerNames();
        }

        function updateFertilizerNames() {
            const fertilizerTypeSelect = document.getElementById('inputKegunaanBaja');
            const fertilizerNameSelect = document.getElementById('inputNamaBaja');
            const selectedFertilizerTypeId = fertilizerTypeSelect.value;
            const selectedPlantTypeId = document.getElementById('inputNamaPokok').value;

            // Clear previous name options
            fertilizerNameSelect.innerHTML = '<option value="">Sila Pilih</option>';

            if (selectedFertilizerTypeId && selectedPlantTypeId) {
                // Get existing fertilizers for the selected plant
                const existingFertilizers = window.existingFertilizers[selectedPlantTypeId] || [];

                // Loop through the fertilizerDetails to find the fertilizers that match the selected fertilizer type ID
                for (const categoryId in fertilizerDetails) {
                    const fertilizers = fertilizerDetails[categoryId];

                    // Filter fertilizers that match the selected fertilizer type ID
                    const matchingFertilizers = fertilizers.filter(fertilizer =>
                        fertilizer.fertilizer_category.id == selectedFertilizerTypeId &&
                        !existingFertilizers.includes(fertilizer.id) // Exclude existing fertilizers
                    );

                    // Populate the fertilizer name select with matching fertilizers
                    matchingFertilizers.forEach(fertilizer => {
                        const option = document.createElement('option');
                        option.value = fertilizer.id; // Assuming 'id' holds the fertilizer ID
                        option.textContent = fertilizer
                        .fertilizer_name; // Assuming 'fertilizer_name' holds the fertilizer name
                        fertilizerNameSelect.appendChild(option);
                    });

                    // Exit the loop once we have processed the relevant category
                    break;
                }
            }
        }

        // Attach event listeners
        document.getElementById('plant_category').addEventListener('change', updateFertilizerTypes);
        document.getElementById('inputKegunaanBaja').addEventListener('change', updateFertilizerNames);
        document.getElementById('inputNamaPokok').addEventListener('change', updateFertilizerNames);
    </script>
<script>
    // Pass existingFertilizers data to JavaScript
    window.existingFertilizers = @json($existingFertilizers);
</script>


@endsection
