<?php

namespace Database\Seeders;

use App\Models\Plantation;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class PlantationSeeder extends Seeder
{
	/**
	 * Run the database seeds.
	 */
	public function run(): void
	{
		Plantation::create([
			"id" => 1,
			"farm_id" => 1,
			"plant_detail_id" => 1,
			"tumbesaran_id" => 1,
			"tumbesaran_date" => "\"2023-01-02, 2023-02-02, 2023-03-02\"",
			"akar_id" => 2,
			"akar_date" => "\"2023-01-03, 2023-02-03, 2023-03-03\"",
			"buah_id" => 3,
			"buah_date" => "\"2023-01-05, 2023-02-05, 2023-03-05, 2023-04-05, 2023-05-05, 2023-06-05, 2023-07-05, 2023-08-05\"",
			"matang_id" => 4,
			"matang_date" => "\"2023-06-15\"",
			"pengait_id" => 2,
			"penanam_id" => 3,
			"plant_date" => "2023-01-01",
			"harvest_date" => "2023-09-01",
			"quantity_plant" => 500,
			"status" => "Selesai",
			"image_tanam" => "public/banner/tanam.jpg",
			"image_kait" => "public/banner/kait.jpg",
			"created_at" => "2025-01-13 16:44:03",
			"updated_at" => "2025-01-13 16:52:00",
			"deleted_at" => NULL,
		]);

		Plantation::create([
			"id" => 2,
			"farm_id" => 2,
			"plant_detail_id" => 2,
			"tumbesaran_id" => 5,
			"tumbesaran_date" => "\"2023-10-02, 2023-11-02, 2023-12-02\"",
			"akar_id" => 6,
			"akar_date" => "\"2023-10-03, 2023-11-03, 2023-12-03\"",
			"buah_id" => 7,
			"buah_date" => "\"2023-11-05, 2023-12-05, 2024-01-05, 2024-02-05, 2024-03-05, 2024-04-05, 2024-05-05, 2024-06-05, 2024-07-05, 2024-08-10, 2024-09-05, 2024-10-05, 2024-11-05, 2024-12-05\"",
			"matang_id" => 8,
			"matang_date" => "\"2024-07-25\"",
			"pengait_id" => 2,
			"penanam_id" => 3,
			"plant_date" => "2023-10-01",
			"harvest_date" => "2024-12-01",
			"quantity_plant" => 300,
			"status" => "Selesai",
			"image_tanam" => "public/banner/tanam.jpg",
			"image_kait" => "public/banner/kait.jpg",
			"created_at" => "2025-01-13 17:01:28",
			"updated_at" => "2025-01-13 17:09:15",
			"deleted_at" => NULL,
		]);

		Plantation::create([
			"id" => 3,
			"farm_id" => 3,
			"plant_detail_id" => 3,
			"tumbesaran_id" => 5,
			"tumbesaran_date" => "\"2024-04-15, 2024-05-15, 2024-06-15\"",
			"akar_id" => 6,
			"akar_date" => "\"2024-04-16, 2024-05-16, 2024-06-16\"",
			"buah_id" => 7,
			"buah_date" => "\"2024-04-20, 2024-05-20, 2024-06-20, 2024-07-20, 2024-08-20, 2024-09-20, 2024-10-20, 2024-11-20, 2024-12-20\"",
			"matang_id" => 8,
			"matang_date" => "\"2024-08-23\"",
			"pengait_id" => 2,
			"penanam_id" => 3,
			"plant_date" => "2024-04-16",
			"harvest_date" => "2025-01-16",
			"quantity_plant" => 200,
			"status" => "Tanam",
			"image_tanam" => "public/banner/tanam.jpg",
			"image_kait" => NULL,
			"created_at" => "2025-01-13 17:13:22",
			"updated_at" => "2025-01-13 17:14:07",
			"deleted_at" => NULL,
		]);

		Plantation::create([
			"id" => 4,
			"farm_id" => 4,
			"plant_detail_id" => 1,
			"tumbesaran_id" => 1,
			"tumbesaran_date" => "\"2024-10-10, 2024-11-10, 2024-12-10\"",
			"akar_id" => 2,
			"akar_date" => "\"2024-10-12, 2024-11-12, 2024-12-12\"",
			"buah_id" => 3,
			"buah_date" => "\"2024-10-14, 2024-11-14, 2024-12-14, 2025-01-14, 2025-02-14, 2025-03-14, 2025-04-14, 2025-05-14\"",
			"matang_id" => 4,
			"matang_date" => "\"2025-03-29\"",
			"pengait_id" => 2,
			"penanam_id" => 3,
			"plant_date" => "2024-10-01",
			"harvest_date" => "2025-06-01",
			"quantity_plant" => 400,
			"status" => "Tanam",
			"image_tanam" => "public/banner/tanam.jpg",
			"image_kait" => NULL,
			"created_at" => "2025-01-13 17:17:55",
			"updated_at" => "2025-01-13 17:18:16",
			"deleted_at" => NULL,
		]);
	}
}
