<?php

namespace Database\Seeders;

use App\Models\Harvest;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class HarvestSeeder extends Seeder
{
	/**
	 * Run the database seeds.
	 */
	public function run(): void
	{
		Harvest::create([
			"id" => 2,
			"plantation_id" => 2,
			"harvest_date" => "2024-12-01",
			"grade_a_quantity" => 150,
			"grade_b_quantity" => 100,
			"grade_c_quantity" => 150,
			"grade_reject_quantity" => 0,
			"grade_a_weight" => 6000,
			"grade_b_weight" => 3000,
			"grade_c_weight" => 2500,
			"grade_reject_weight" => 0,
			"total_weight" => 11500,
			"grade_a_available" => 0,
			"grade_b_available" => 0,
			"grade_c_available" => 0,
			"status" => "Jual",
			"created_at" => "2024-01-12 17:09:15",
			"updated_at" => "2024-01-12 17:09:45",
			"deleted_at" => NULL,
		]);

		Harvest::create([
			"id" => 1,
			"plantation_id" => 1,
			"harvest_date" => "2023-09-01",
			"grade_a_quantity" => 330,
			"grade_b_quantity" => 100,
			"grade_c_quantity" => 50,
			"grade_reject_quantity" => 20,
			"grade_a_weight" => 6600,
			"grade_b_weight" => 1500,
			"grade_c_weight" => 600,
			"grade_reject_weight" => 160,
			"total_weight" => 8700,
			"grade_a_available" => 0,
			"grade_b_available" => 0,
			"grade_c_available" => 0,
			"status" => "Jual",
			"created_at" => "2023-01-09 16:52:00",
			"updated_at" => "2023-01-09 16:56:47",
			"deleted_at" => NULL,
		]);
	}
}


