<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Damage extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable =[
        'plantation_id',
        'worker_id',
        'pest_id',
        'damage_description',
        'image',
        'image_work',
        'solution_description',
        'damage_category',
        'solution_category',
        'status',
    ];

    public function worker()
    {
        return $this->belongsTo(User::class, 'worker_id'); // Adjust 'worker_id' to the foreign key in User table
    }

    public function plantation()
    {
        return $this->belongsTo(Plantation::class);
    }

    public function pestControl()
    {
        return $this->belongsTo(PestControl::class, 'pest_id');
    }

//     public function pestControlDetail()
// {
//     return $this->belongsTo(PestControlDetail::class, 'pest_id');
// }





   
}
